/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRDesignSubreport
extends JRDesignElement
implements JRSubreport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_CONNECTION_EXPRESSION = "connectionExpression";
    public static final String PROPERTY_DATASOURCE_EXPRESSION = "dataSourceExpression";
    public static final String PROPERTY_EXPRESSION = "expression";
    public static final String PROPERTY_PARAMETERS_MAP_EXPRESSION = "parametersMapExpression";
    public static final String PROPERTY_PARAMETERS = "parameters";
    public static final String PROPERTY_RETURN_VALUES = "returnValues";
    protected Boolean isUsingCache = null;
    private Boolean runToBottom;
    protected Map parametersMap = new HashMap();
    protected List returnValues = new ArrayList();
    protected JRExpression parametersMapExpression = null;
    protected JRExpression connectionExpression = null;
    protected JRExpression dataSourceExpression = null;
    protected JRExpression expression = null;

    public JRDesignSubreport(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public boolean isUsingCache() {
        if (this.isUsingCache == null) {
            JRExpression subreportExpression = this.getExpression();
            if (subreportExpression != null) {
                return String.class.getName().equals(subreportExpression.getValueClassName());
            }
            return true;
        }
        return this.isUsingCache;
    }

    public void setUsingCache(boolean isUsingCache) {
        this.setUsingCache(isUsingCache ? Boolean.TRUE : Boolean.FALSE);
    }

    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public void setParametersMapExpression(JRExpression parametersMapExpression) {
        JRExpression old = this.parametersMapExpression;
        this.parametersMapExpression = parametersMapExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_PARAMETERS_MAP_EXPRESSION, old, this.parametersMapExpression);
    }

    public JRSubreportParameter[] getParameters() {
        JRSubreportParameter[] parametersArray = new JRSubreportParameter[this.parametersMap.size()];
        this.parametersMap.values().toArray(parametersArray);
        return parametersArray;
    }

    public Map getParametersMap() {
        return this.parametersMap;
    }

    public void addParameter(JRSubreportParameter subreportParameter) throws JRException {
        if (this.parametersMap.containsKey(subreportParameter.getName())) {
            throw new JRException("Duplicate declaration of subreport parameter : " + subreportParameter.getName());
        }
        this.parametersMap.put(subreportParameter.getName(), subreportParameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARAMETERS, subreportParameter, this.parametersMap.size() - 1);
    }

    public JRSubreportParameter removeParameter(String name) {
        JRSubreportParameter removed = (JRSubreportParameter)this.parametersMap.remove(name);
        if (removed != null) {
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARAMETERS, removed, -1);
        }
        return removed;
    }

    public JRExpression getConnectionExpression() {
        return this.connectionExpression;
    }

    public void setConnectionExpression(JRExpression connectionExpression) {
        JRExpression old = this.connectionExpression;
        this.connectionExpression = connectionExpression;
        if (this.connectionExpression != null) {
            this.setDataSourceExpression(null);
        }
        this.getEventSupport().firePropertyChange(PROPERTY_CONNECTION_EXPRESSION, old, this.connectionExpression);
    }

    public JRExpression getDataSourceExpression() {
        return this.dataSourceExpression;
    }

    public void setDataSourceExpression(JRExpression dataSourceExpression) {
        JRExpression old = this.dataSourceExpression;
        this.dataSourceExpression = dataSourceExpression;
        if (this.dataSourceExpression != null) {
            this.setConnectionExpression(null);
        }
        this.getEventSupport().firePropertyChange(PROPERTY_DATASOURCE_EXPRESSION, old, this.dataSourceExpression);
    }

    public JRExpression getExpression() {
        return this.expression;
    }

    public void setExpression(JRExpression expression) {
        JRExpression old = this.expression;
        this.expression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_EXPRESSION, old, this.expression);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitSubreport(this);
    }

    public void addReturnValue(JRSubreportReturnValue returnValue) {
        this.returnValues.add(returnValue);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_RETURN_VALUES, returnValue, this.returnValues.size() - 1);
    }

    public JRSubreportReturnValue[] getReturnValues() {
        JRSubreportReturnValue[] returnValuesArray = new JRSubreportReturnValue[this.returnValues.size()];
        this.returnValues.toArray(returnValuesArray);
        return returnValuesArray;
    }

    public List getReturnValuesList() {
        return this.returnValues;
    }

    public boolean removeReturnValue(JRSubreportReturnValue returnValue) {
        int idx = this.returnValues.indexOf(returnValue);
        if (idx >= 0) {
            this.returnValues.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_RETURN_VALUES, returnValue, idx);
            return true;
        }
        return false;
    }

    public Boolean isOwnUsingCache() {
        return this.isUsingCache;
    }

    public void setUsingCache(Boolean isUsingCache) {
        Boolean old = this.isUsingCache;
        this.isUsingCache = isUsingCache;
        this.getEventSupport().firePropertyChange("usingCache", old, this.isUsingCache);
    }

    public Boolean isRunToBottom() {
        return this.runToBottom;
    }

    public void setRunToBottom(Boolean runToBottom) {
        Boolean old = this.runToBottom;
        this.runToBottom = runToBottom;
        this.getEventSupport().firePropertyChange("runToBottom", old, this.runToBottom);
    }

    public Object clone() {
        JRDesignSubreport clone = (JRDesignSubreport)super.clone();
        if (this.parametersMap != null) {
            clone.parametersMap = new HashMap(this.parametersMap.size());
            Iterator it = this.parametersMap.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                JRSubreportParameter parameter = (JRSubreportParameter)this.parametersMap.get(key);
                clone.parametersMap.put(key, parameter.clone());
            }
        }
        if (this.returnValues != null) {
            clone.returnValues = new ArrayList(this.returnValues.size());
            for (int i2 = 0; i2 < this.returnValues.size(); ++i2) {
                clone.returnValues.add(((JRSubreportReturnValue)this.returnValues.get(i2)).clone());
            }
        }
        if (this.parametersMapExpression != null) {
            clone.parametersMapExpression = (JRExpression)this.parametersMapExpression.clone();
        }
        if (this.connectionExpression != null) {
            clone.connectionExpression = (JRExpression)this.connectionExpression.clone();
        }
        if (this.dataSourceExpression != null) {
            clone.dataSourceExpression = (JRExpression)this.dataSourceExpression.clone();
        }
        if (this.expression != null) {
            clone.expression = (JRExpression)this.expression.clone();
        }
        return clone;
    }
}

