/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;
import net.sf.jasperreports.engine.export.draw.EllipseDrawer;
import net.sf.jasperreports.engine.export.draw.ImageDrawer;
import net.sf.jasperreports.engine.export.draw.LineDrawer;
import net.sf.jasperreports.engine.export.draw.RectangleDrawer;
import net.sf.jasperreports.engine.export.draw.TextDrawer;

public class FrameDrawer
extends ElementDrawer {
    private static final int ELEMENT_RECTANGLE_PADDING = 3;
    private ExporterFilter filter = null;
    private Graphics2D grx = null;
    private LinkedList elementOffsetStack = new LinkedList();
    private int elementOffsetX = 0;
    private int elementOffsetY = 0;
    private boolean isClip = false;
    private LineDrawer lineDrawer = null;
    private RectangleDrawer rectangleDrawer = null;
    private EllipseDrawer ellipseDrawer = null;
    private ImageDrawer imageDrawer = null;
    private TextDrawer textDrawer = null;

    public FrameDrawer(ExporterFilter filter, TextRenderer textRenderer) {
        this.filter = filter;
        this.lineDrawer = new LineDrawer();
        this.rectangleDrawer = new RectangleDrawer();
        this.ellipseDrawer = new EllipseDrawer();
        this.imageDrawer = new ImageDrawer();
        this.textDrawer = new TextDrawer(textRenderer);
    }

    public void setClip(boolean isClip) {
        this.isClip = isClip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D grx, JRPrintElement element, int offsetX, int offsetY) throws JRException {
        this.grx = grx;
        JRPrintFrame frame2 = (JRPrintFrame)element;
        Shape oldClipShape = null;
        if (this.isClip) {
            oldClipShape = grx.getClip();
            grx.clip(new Rectangle(frame2.getX() + offsetX, frame2.getY() + offsetY, frame2.getWidth(), frame2.getHeight()));
        }
        if (frame2.getMode() == 1) {
            grx.setColor(frame2.getBackcolor());
            grx.fillRect(frame2.getX() + offsetX, frame2.getY() + offsetY, frame2.getWidth(), frame2.getHeight());
        }
        grx.setColor(frame2.getForecolor());
        this.setFrameElementsOffset(frame2, offsetX, offsetY);
        try {
            this.draw(frame2.getElements());
        }
        finally {
            if (this.isClip) {
                grx.setClip(oldClipShape);
            }
            this.restoreElementOffsets();
        }
        this.drawBox(grx, frame2.getLineBox(), frame2, offsetX, offsetY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D grx, Collection elements, int offsetX, int offsetY) throws JRException {
        this.grx = grx;
        this.setElementOffsets(offsetX, offsetY);
        try {
            this.draw(elements);
        }
        finally {
            this.restoreElementOffsets();
        }
    }

    private void draw(Collection elements) throws JRException {
        if (elements != null && elements.size() > 0) {
            Shape clipArea = this.grx.getClip();
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                JRPrintElement element = (JRPrintElement)it.next();
                if (this.filter != null && !this.filter.isToExport(element) || !clipArea.intersects(element.getX() + this.getOffsetX() - 3, element.getY() + this.getOffsetY() - 3, element.getWidth() + 6, element.getHeight() + 6)) continue;
                if (element instanceof JRPrintLine) {
                    this.lineDrawer.draw(this.grx, element, this.getOffsetX(), this.getOffsetY());
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.rectangleDrawer.draw(this.grx, element, this.getOffsetX(), this.getOffsetY());
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.ellipseDrawer.draw(this.grx, element, this.getOffsetX(), this.getOffsetY());
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.imageDrawer.draw(this.grx, element, this.getOffsetX(), this.getOffsetY());
                    continue;
                }
                if (element instanceof JRPrintText) {
                    this.textDrawer.draw(this.grx, element, this.getOffsetX(), this.getOffsetY());
                    continue;
                }
                if (!(element instanceof JRPrintFrame)) continue;
                this.draw(this.grx, element, this.getOffsetX(), this.getOffsetY());
            }
        }
    }

    private void setFrameElementsOffset(JRPrintFrame frame2, int offsetX, int offsetY) {
        this.setElementOffsets(offsetX + frame2.getX() + frame2.getLineBox().getLeftPadding(), offsetY + frame2.getY() + frame2.getLineBox().getTopPadding());
    }

    private void setElementOffsets(int offsetX, int offsetY) {
        this.elementOffsetStack.addLast(new int[]{this.elementOffsetX, this.elementOffsetY});
        this.elementOffsetX = offsetX;
        this.elementOffsetY = offsetY;
    }

    private void restoreElementOffsets() {
        int[] offsets = (int[])this.elementOffsetStack.removeLast();
        this.elementOffsetX = offsets[0];
        this.elementOffsetY = offsets[1];
    }

    private int getOffsetX() {
        return this.elementOffsetX;
    }

    private int getOffsetY() {
        return this.elementOffsetY;
    }
}

