/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.CellHelper;
import net.sf.jasperreports.engine.export.ooxml.ParagraphHelper;
import net.sf.jasperreports.engine.export.ooxml.RunHelper;
import net.sf.jasperreports.engine.export.ooxml.Utility;

public class TableHelper
extends BaseHelper {
    private CutsInfo xCuts = null;
    private CellHelper cellHelper = null;
    private ParagraphHelper paragraphHelper = null;
    private RunHelper runHelper = null;

    protected TableHelper(Writer writer, CutsInfo xCuts, RunHelper runHelper, boolean pageBreak) {
        super(writer);
        this.xCuts = xCuts;
        this.cellHelper = new CellHelper(writer);
        this.paragraphHelper = new ParagraphHelper(writer, pageBreak);
        this.runHelper = runHelper;
    }

    public CellHelper getCellHelper() {
        return this.cellHelper;
    }

    public ParagraphHelper getParagraphHelper() {
        return this.paragraphHelper;
    }

    public void exportHeader() throws IOException {
        this.writer.write("  <w:tbl>\n");
        this.writer.write("   <w:tblPr>\n");
        this.writer.write("    <w:tblLayout w:type=\"fixed\"/>\n");
        this.writer.write("   </w:tblPr>\n");
        this.writer.write("   <w:tblGrid>\n");
        for (int col2 = 1; col2 < this.xCuts.size(); ++col2) {
            this.writer.write("    <w:gridCol w:w=\"" + Utility.twip(this.xCuts.getCut(col2) - this.xCuts.getCut(col2 - 1)) + "\"/>\n");
        }
        this.writer.write("   </w:tblGrid>\n");
    }

    public void exportFooter(boolean lastPage, int pageWidth, int pageHeight) throws IOException {
        this.writer.write("  </w:tbl>\n");
        if (lastPage) {
            this.writer.write("    <w:p>\n");
            this.writer.write("    <w:pPr>\n");
            this.writer.write("  <w:sectPr>\n");
            this.writer.write("   <w:pgSz w:w=\"" + Utility.twip(pageWidth) + "\" w:h=\"" + Utility.twip(pageHeight) + "\" />\n");
            this.writer.write("   <w:pgMar w:top=\"0\" w:right=\"0\" w:bottom=\"0\" w:left=\"0\" w:header=\"0\" w:footer=\"0\" w:gutter=\"0\" />\n");
            this.writer.write("   <w:docGrid w:linePitch=\"360\" />\n");
            this.writer.write("  </w:sectPr>\n");
            this.writer.write("    </w:pPr>\n");
            this.writer.write("    </w:p>\n");
        }
    }

    public void exportRowHeader(int rowHeight) throws IOException {
        this.writer.write("   <w:tr>\n");
        this.writer.write("    <w:trPr>\n");
        this.writer.write("     <w:trHeight w:hRule=\"exact\" w:val=\"" + Utility.twip(rowHeight) + "\" />\n");
        this.writer.write("    </w:trPr>\n");
    }

    public void exportRowFooter() throws IOException {
        this.writer.write("   </w:tr>\n");
    }

    public void exportEmptyCell(JRExporterGridCell gridCell, int emptyCellColSpan) throws IOException {
        this.writer.write("    <w:tc>\n");
        this.writer.write("     <w:tcPr>\n");
        if (emptyCellColSpan > 1) {
            this.writer.write("      <w:gridSpan w:val=\"" + emptyCellColSpan + "\" />\n");
        }
        if (gridCell != null) {
            this.cellHelper.exportProps(gridCell);
        }
        this.writer.write("     </w:tcPr>\n");
        this.paragraphHelper.exportEmptyParagraph();
        this.writer.write("    </w:tc>\n");
    }

    public void exportOccupiedCells(JRExporterGridCell gridCell) throws IOException {
        this.writer.write("    <w:tc>\n");
        this.writer.write("     <w:tcPr>\n");
        if (gridCell.getColSpan() > 1) {
            this.writer.write("      <w:gridSpan w:val=\"" + gridCell.getColSpan() + "\" />\n");
        }
        this.writer.write("      <w:vMerge w:val=\"continue\" />\n");
        this.cellHelper.exportProps(gridCell.getElement(), gridCell);
        this.writer.write("     </w:tcPr>\n");
        this.paragraphHelper.exportEmptyParagraph();
        this.cellHelper.exportFooter();
    }
}

