/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;

public class JRFillElementGroup
implements JRElementGroup,
JRFillCloneable {
    protected List children = new ArrayList();
    protected JRElementGroup elementGroup = null;
    protected JRFillElement[] elements = null;
    private JRElement topElementInGroup = null;
    private JRElement bottomElementInGroup = null;
    private int stretchHeightDiff = 0;

    protected JRFillElementGroup(JRElementGroup elementGrp, JRFillObjectFactory factory) {
        if (elementGrp != null) {
            factory.put(elementGrp, this);
            List list = elementGrp.getChildren();
            if (list != null && list.size() > 0) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    JRChild child = (JRChild)list.get(i2);
                    child = (JRChild)factory.getVisitResult(child);
                    this.children.add(child);
                }
            }
            this.getElements();
            this.elementGroup = (JRElementGroup)factory.getVisitResult(elementGrp.getElementGroup());
        }
    }

    protected JRFillElementGroup(JRFillElementGroup elementGrp, JRFillCloneFactory factory) {
        factory.put(elementGrp, this);
        List list = elementGrp.getChildren();
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                JRFillCloneable child = (JRFillCloneable)list.get(i2);
                JRFillCloneable clone = child.createClone(factory);
                this.children.add(clone);
            }
        }
        this.getElements();
        this.elementGroup = (JRFillElementGroup)factory.getClone((JRFillElementGroup)elementGrp.getElementGroup());
    }

    public List getChildren() {
        return this.children;
    }

    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    public JRElement[] getElements() {
        if (this.elements == null && this.children != null) {
            ArrayList<JRElement> allElements = new ArrayList<JRElement>();
            Object child = null;
            JRElement[] childElementArray = null;
            for (int i2 = 0; i2 < this.children.size(); ++i2) {
                child = this.children.get(i2);
                if (child instanceof JRFillElement) {
                    allElements.add((JRElement)child);
                    continue;
                }
                if (!(child instanceof JRFillElementGroup) || (childElementArray = ((JRFillElementGroup)child).getElements()) == null) continue;
                allElements.addAll(Arrays.asList(childElementArray));
            }
            this.elements = new JRFillElement[allElements.size()];
            allElements.toArray(this.elements);
        }
        return this.elements;
    }

    public JRElement getElementByKey(String key) {
        return null;
    }

    protected void reset() {
        this.topElementInGroup = null;
    }

    protected int getStretchHeightDiff() {
        if (this.topElementInGroup == null) {
            this.stretchHeightDiff = 0;
            this.setTopBottomElements();
            JRElement[] allElements = this.getElements();
            if (allElements != null && allElements.length > 0) {
                JRFillElement topElem = null;
                JRFillElement bottomElem = null;
                for (int i2 = 0; i2 < allElements.length; ++i2) {
                    JRFillElement element = (JRFillElement)allElements[i2];
                    if (!element.isToPrint()) continue;
                    if (topElem == null || topElem != null && element.getRelativeY() + element.getStretchHeight() < topElem.getRelativeY() + topElem.getStretchHeight()) {
                        topElem = element;
                    }
                    if (bottomElem != null && (bottomElem == null || element.getRelativeY() + element.getStretchHeight() <= bottomElem.getRelativeY() + bottomElem.getStretchHeight())) continue;
                    bottomElem = element;
                }
                if (topElem != null) {
                    this.stretchHeightDiff = bottomElem.getRelativeY() + bottomElem.getStretchHeight() - topElem.getRelativeY() - (this.bottomElementInGroup.getY() + this.bottomElementInGroup.getHeight() - this.topElementInGroup.getY());
                }
                if (this.stretchHeightDiff < 0) {
                    this.stretchHeightDiff = 0;
                }
            }
        }
        return this.stretchHeightDiff;
    }

    private void setTopBottomElements() {
        JRElement[] allElements = this.getElements();
        if (allElements != null && allElements.length > 0) {
            for (int i2 = 0; i2 < allElements.length; ++i2) {
                if (this.topElementInGroup == null || this.topElementInGroup != null && allElements[i2].getY() + allElements[i2].getHeight() < this.topElementInGroup.getY() + this.topElementInGroup.getHeight()) {
                    this.topElementInGroup = allElements[i2];
                }
                if (this.bottomElementInGroup != null && (this.bottomElementInGroup == null || allElements[i2].getY() + allElements[i2].getHeight() <= this.bottomElementInGroup.getY() + this.bottomElementInGroup.getHeight())) continue;
                this.bottomElementInGroup = allElements[i2];
            }
        }
    }

    public void visit(JRVisitor visitor) {
        visitor.visitElementGroup(this);
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillElementGroup(this, factory);
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public Object clone(JRElementGroup parentGroup) {
        throw new UnsupportedOperationException();
    }
}

