/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.awt.Color;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public abstract class JRAbstractStyleFactory
extends JRBaseFactory {
    private static final Log log = LogFactory.getLog(JRAbstractStyleFactory.class);

    public Object createObject(Attributes atts) {
        Byte lineSpacing;
        Byte rotation;
        String padding;
        Color borderColor;
        Byte border;
        Byte verticalAlignment;
        Byte horizontalAlignment;
        Byte scaleImage;
        Byte mode;
        JRDesignStyle style2 = new JRDesignStyle();
        style2.setName(atts.getValue("name"));
        String isDefault = atts.getValue("isDefault");
        if (isDefault != null && isDefault.length() > 0) {
            style2.setDefault(Boolean.valueOf(isDefault));
        }
        if (atts.getValue("style") != null) {
            this.setParentStyle(style2, atts.getValue("style"));
        }
        if ((mode = (Byte)JRXmlConstants.getModeMap().get(atts.getValue("mode"))) != null) {
            style2.setMode(mode);
        }
        String forecolor = atts.getValue("forecolor");
        style2.setForecolor(JRColorUtil.getColor(forecolor, null));
        String backcolor = atts.getValue("backcolor");
        style2.setBackcolor(JRColorUtil.getColor(backcolor, null));
        Byte pen = (Byte)JRXmlConstants.getPenMap().get(atts.getValue("pen"));
        if (pen != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'pen' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(pen, style2.getLinePen());
        }
        Byte fill = (Byte)JRXmlConstants.getFillMap().get(atts.getValue("fill"));
        style2.setFill(fill);
        String radius = atts.getValue("radius");
        if (radius != null && radius.length() > 0) {
            style2.setRadius(Integer.parseInt(radius));
        }
        if ((scaleImage = (Byte)JRXmlConstants.getScaleImageMap().get(atts.getValue("scaleImage"))) != null) {
            style2.setScaleImage(scaleImage);
        }
        if ((horizontalAlignment = (Byte)JRXmlConstants.getHorizontalAlignMap().get(atts.getValue("hAlign"))) != null) {
            style2.setHorizontalAlignment(horizontalAlignment);
        }
        if ((verticalAlignment = (Byte)JRXmlConstants.getVerticalAlignMap().get(atts.getValue("vAlign"))) != null) {
            style2.setVerticalAlignment(verticalAlignment);
        }
        if ((border = (Byte)JRXmlConstants.getPenMap().get(atts.getValue("border"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'border' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(border, (JRPen)style2.getLineBox().getPen());
        }
        if ((borderColor = JRColorUtil.getColor(atts.getValue("borderColor"), null)) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'borderColor' attribute is deprecated. Use the <pen> tag instead.");
            }
            style2.getLineBox().getPen().setLineColor(borderColor);
        }
        if ((padding = atts.getValue("padding")) != null && padding.length() > 0) {
            if (log.isWarnEnabled()) {
                log.warn("The 'padding' attribute is deprecated. Use the <box> tag instead.");
            }
            style2.getLineBox().setPadding(Integer.parseInt(padding));
        }
        if ((border = (Byte)JRXmlConstants.getPenMap().get(atts.getValue("topBorder"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'topBorder' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(border, (JRPen)style2.getLineBox().getTopPen());
        }
        if ((borderColor = JRColorUtil.getColor(atts.getValue("topBorderColor"), Color.black)) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'topBorderColor' attribute is deprecated. Use the <pen> tag instead.");
            }
            style2.getLineBox().getTopPen().setLineColor(borderColor);
        }
        if ((padding = atts.getValue("topPadding")) != null && padding.length() > 0) {
            if (log.isWarnEnabled()) {
                log.warn("The 'topPadding' attribute is deprecated. Use the <box> tag instead.");
            }
            style2.getLineBox().setTopPadding(Integer.parseInt(padding));
        }
        if ((border = (Byte)JRXmlConstants.getPenMap().get(atts.getValue("leftBorder"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'leftBorder' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(border, (JRPen)style2.getLineBox().getLeftPen());
        }
        if ((borderColor = JRColorUtil.getColor(atts.getValue("leftBorderColor"), Color.black)) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'leftBorderColor' attribute is deprecated. Use the <pen> tag instead.");
            }
            style2.getLineBox().getLeftPen().setLineColor(borderColor);
        }
        if ((padding = atts.getValue("leftPadding")) != null && padding.length() > 0) {
            if (log.isWarnEnabled()) {
                log.warn("The 'leftPadding' attribute is deprecated. Use the <box> tag instead.");
            }
            style2.getLineBox().setLeftPadding(Integer.parseInt(padding));
        }
        if ((border = (Byte)JRXmlConstants.getPenMap().get(atts.getValue("bottomBorder"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'bottomBorder' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(border, (JRPen)style2.getLineBox().getBottomPen());
        }
        if ((borderColor = JRColorUtil.getColor(atts.getValue("bottomBorderColor"), Color.black)) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'bottomBorderColor' attribute is deprecated. Use the <pen> tag instead.");
            }
            style2.getLineBox().getBottomPen().setLineColor(borderColor);
        }
        if ((padding = atts.getValue("bottomPadding")) != null && padding.length() > 0) {
            if (log.isWarnEnabled()) {
                log.warn("The 'bottomPadding' attribute is deprecated. Use the <box> tag instead.");
            }
            style2.getLineBox().setBottomPadding(Integer.parseInt(padding));
        }
        if ((border = (Byte)JRXmlConstants.getPenMap().get(atts.getValue("rightBorder"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'rightBorder' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(border, (JRPen)style2.getLineBox().getRightPen());
        }
        if ((borderColor = JRColorUtil.getColor(atts.getValue("rightBorderColor"), Color.black)) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'rightBorderColor' attribute is deprecated. Use the <pen> tag instead.");
            }
            style2.getLineBox().getRightPen().setLineColor(borderColor);
        }
        if ((padding = atts.getValue("rightPadding")) != null && padding.length() > 0) {
            if (log.isWarnEnabled()) {
                log.warn("The 'rightPadding' attribute is deprecated. Use the <box> tag instead.");
            }
            style2.getLineBox().setRightPadding(Integer.parseInt(padding));
        }
        if ((rotation = (Byte)JRXmlConstants.getRotationMap().get(atts.getValue("rotation"))) != null) {
            style2.setRotation(rotation);
        }
        if ((lineSpacing = (Byte)JRXmlConstants.getLineSpacingMap().get(atts.getValue("lineSpacing"))) != null) {
            style2.setLineSpacing(lineSpacing);
        }
        style2.setMarkup(atts.getValue("markup"));
        String isStyledText = atts.getValue("isStyledText");
        if (isStyledText != null && isStyledText.length() > 0) {
            if (log.isWarnEnabled()) {
                log.warn("The 'isStyledText' attribute is deprecated. Use the 'markup' attribute instead.");
            }
            style2.setStyledText(Boolean.valueOf(isStyledText));
        }
        style2.setPattern(atts.getValue("pattern"));
        String isBlankWhenNull = atts.getValue("isBlankWhenNull");
        if (isBlankWhenNull != null && isBlankWhenNull.length() > 0) {
            style2.setBlankWhenNull(Boolean.valueOf(isBlankWhenNull));
        }
        if (atts.getValue("fontName") != null) {
            style2.setFontName(atts.getValue("fontName"));
        }
        if (atts.getValue("isBold") != null) {
            style2.setBold(Boolean.valueOf(atts.getValue("isBold")));
        }
        if (atts.getValue("isItalic") != null) {
            style2.setItalic(Boolean.valueOf(atts.getValue("isItalic")));
        }
        if (atts.getValue("isUnderline") != null) {
            style2.setUnderline(Boolean.valueOf(atts.getValue("isUnderline")));
        }
        if (atts.getValue("isStrikeThrough") != null) {
            style2.setStrikeThrough(Boolean.valueOf(atts.getValue("isStrikeThrough")));
        }
        if (atts.getValue("fontSize") != null) {
            style2.setFontSize(Integer.valueOf(atts.getValue("fontSize")));
        }
        if (atts.getValue("pdfFontName") != null) {
            style2.setPdfFontName(atts.getValue("pdfFontName"));
        }
        if (atts.getValue("pdfEncoding") != null) {
            style2.setPdfEncoding(atts.getValue("pdfEncoding"));
        }
        if (atts.getValue("isPdfEmbedded") != null) {
            style2.setPdfEmbedded(Boolean.valueOf(atts.getValue("isPdfEmbedded")));
        }
        return style2;
    }

    protected abstract void setParentStyle(JRDesignStyle var1, String var2);
}

