/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap.mapping;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.olap.mapping.Axis;
import net.sf.jasperreports.olap.mapping.AxisPosition;
import net.sf.jasperreports.olap.mapping.DataMapping;
import net.sf.jasperreports.olap.mapping.Mapping;
import net.sf.jasperreports.olap.mapping.MappingMetadata;
import net.sf.jasperreports.olap.mapping.MappingParserTokenTypes;
import net.sf.jasperreports.olap.mapping.Member;
import net.sf.jasperreports.olap.mapping.MemberDepth;
import net.sf.jasperreports.olap.mapping.MemberMapping;
import net.sf.jasperreports.olap.mapping.MemberProperty;
import net.sf.jasperreports.olap.mapping.Tuple;
import net.sf.jasperreports.olap.mapping.TupleMember;
import net.sf.jasperreports.olap.mapping.TuplePosition;

public class MappingParser
extends LLkParser
implements MappingParserTokenTypes {
    private MappingMetadata mappingMeta;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"Axis\"", "LPAREN", "RPAREN", "\"Columns\"", "\"Rows\"", "\"Pages\"", "\"Chapters\"", "\"Sections\"", "\"Data\"", "\"FormattedData\"", "COMMA", "QMARK", "POINT", "INT", "MONDRNAME", "MONDRIDX", "NAME", "PLUS", "MINUS", "STAR", "WS", "MONDRCH", "DIGIT", "LETTER"};
    public static final BitSet _tokenSet_0 = new BitSet(MappingParser.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(MappingParser.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(MappingParser.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(MappingParser.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(MappingParser.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(MappingParser.mk_tokenSet_5());
    public static final BitSet _tokenSet_6 = new BitSet(MappingParser.mk_tokenSet_6());
    public static final BitSet _tokenSet_7 = new BitSet(MappingParser.mk_tokenSet_7());
    public static final BitSet _tokenSet_8 = new BitSet(MappingParser.mk_tokenSet_8());
    public static final BitSet _tokenSet_9 = new BitSet(MappingParser.mk_tokenSet_9());
    public static final BitSet _tokenSet_10 = new BitSet(MappingParser.mk_tokenSet_10());

    public void setMappingMetadata(MappingMetadata mappingMeta) {
        this.mappingMeta = mappingMeta;
    }

    private String getMondrName(String text) {
        return text.substring(1, text.length() - 1).trim();
    }

    private int getMondrIdx(String text) {
        return Integer.parseInt(text.substring(2, text.length() - 1).trim());
    }

    protected MappingParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public MappingParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 2);
    }

    protected MappingParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public MappingParser(TokenStream lexer) {
        this(lexer, 2);
    }

    public MappingParser(ParserSharedInputState state) {
        super(state, 2);
        this.tokenNames = _tokenNames;
    }

    public final Mapping mapping() throws RecognitionException, TokenStreamException {
        Mapping mapping = null;
        try {
            switch (this.LA(1)) {
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    mapping = this.memberMapping();
                    break;
                }
                case 12: 
                case 13: {
                    mapping = this.dataMapping();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(1);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_0);
        }
        return mapping;
    }

    public final MemberMapping memberMapping() throws RecognitionException, TokenStreamException {
        MemberMapping mapping = null;
        MemberProperty prop = null;
        try {
            Member member = this.member();
            switch (this.LA(1)) {
                case 5: {
                    prop = this.property();
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            mapping = new MemberMapping(member, prop);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_0);
        }
        return mapping;
    }

    public final DataMapping dataMapping() throws RecognitionException, TokenStreamException {
        DataMapping mapping = null;
        boolean formatted = false;
        List filter = null;
        List positions = null;
        try {
            switch (this.LA(1)) {
                case 12: {
                    this.match(12);
                    break;
                }
                case 13: {
                    this.match(13);
                    formatted = true;
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            if (this.LA(1) == 5 && _tokenSet_1.member(this.LA(2))) {
                filter = this.memberFilter();
            } else if (this.LA(1) != 1 && this.LA(1) != 5 || !_tokenSet_2.member(this.LA(2))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            switch (this.LA(1)) {
                case 5: {
                    positions = this.axisPositions();
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            mapping = new DataMapping(formatted, filter, positions);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_0);
        }
        return mapping;
    }

    public final Member member() throws RecognitionException, TokenStreamException {
        Member member = null;
        MemberDepth depth = null;
        try {
            Axis axis = this.axis();
            TuplePosition pos = this.tuplePosition(axis);
            switch (this.LA(1)) {
                case 18: 
                case 19: {
                    depth = this.memberDepth(axis, pos);
                    break;
                }
                case 1: 
                case 5: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            member = new Member(pos, depth);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_3);
        }
        return member;
    }

    public final MemberProperty property() throws RecognitionException, TokenStreamException {
        MemberProperty prop = null;
        try {
            this.match(5);
            String name = this.name();
            this.match(6);
            prop = new MemberProperty(name);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_0);
        }
        return prop;
    }

    public final Axis axis() throws RecognitionException, TokenStreamException {
        Axis axis = null;
        try {
            int idx;
            switch (this.LA(1)) {
                case 4: {
                    this.match(4);
                    this.match(5);
                    idx = this.idx();
                    this.match(6);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    idx = this.axisName();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            axis = new Axis(idx);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
        return axis;
    }

    public final TuplePosition tuplePosition(Axis axis) throws RecognitionException, TokenStreamException {
        TuplePosition pos = null;
        try {
            int idx;
            switch (this.LA(1)) {
                case 19: {
                    idx = this.mondrIdx();
                    break;
                }
                case 18: {
                    String dimensionName = this.mondrName();
                    idx = this.mappingMeta.getDimensionIndex(axis, dimensionName);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            pos = new TuplePosition(axis, idx);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_5);
        }
        return pos;
    }

    public final MemberDepth memberDepth(Axis axis, TuplePosition pos) throws RecognitionException, TokenStreamException {
        MemberDepth memberDepth = null;
        try {
            switch (this.LA(1)) {
                case 19: {
                    int depth = this.mondrIdx();
                    memberDepth = new MemberDepth(depth);
                    break;
                }
                case 18: {
                    String levelName = this.mondrName();
                    memberDepth = new MemberDepth(this.mappingMeta.getLevelDepth(pos, levelName));
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
        return memberDepth;
    }

    public final Member memberLevel() throws RecognitionException, TokenStreamException {
        Member member = null;
        try {
            Axis axis = this.axis();
            TuplePosition pos = this.tuplePosition(axis);
            MemberDepth depth = this.memberDepth(axis, pos);
            member = new Member(pos, depth);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
        return member;
    }

    public final int idx() throws RecognitionException, TokenStreamException {
        int i2 = -1;
        Token idx = null;
        try {
            idx = this.LT(1);
            this.match(17);
            i2 = Integer.parseInt(idx.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
        return i2;
    }

    public final int axisName() throws RecognitionException, TokenStreamException {
        int idx = -1;
        try {
            switch (this.LA(1)) {
                case 7: {
                    this.match(7);
                    idx = 0;
                    break;
                }
                case 8: {
                    this.match(8);
                    idx = 1;
                    break;
                }
                case 9: {
                    this.match(9);
                    idx = 2;
                    break;
                }
                case 10: {
                    this.match(10);
                    idx = 3;
                    break;
                }
                case 11: {
                    this.match(11);
                    idx = 4;
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
        return idx;
    }

    public final int mondrIdx() throws RecognitionException, TokenStreamException {
        int i2 = -1;
        Token n = null;
        try {
            n = this.LT(1);
            this.match(19);
            i2 = this.getMondrIdx(n.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
        return i2;
    }

    public final String mondrName() throws RecognitionException, TokenStreamException {
        String name = null;
        Token n = null;
        try {
            n = this.LT(1);
            this.match(18);
            name = this.getMondrName(n.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_9);
        }
        return name;
    }

    public final String name() throws RecognitionException, TokenStreamException {
        String name = null;
        Token n = null;
        try {
            n = this.LT(1);
            this.match(20);
            name = n.getText();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_10);
        }
        return name;
    }

    public final List memberFilter() throws RecognitionException, TokenStreamException {
        ArrayList<Member> filter = new ArrayList<Member>();
        try {
            this.match(5);
            Member member = this.memberLevel();
            filter.add(member);
            while (this.LA(1) == 14) {
                this.match(14);
                member = this.memberLevel();
                filter.add(member);
            }
            this.match(6);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_3);
        }
        return filter;
    }

    public final List axisPositions() throws RecognitionException, TokenStreamException {
        ArrayList<AxisPosition> positions = new ArrayList<AxisPosition>();
        int axis = 0;
        try {
            this.match(5);
            AxisPosition pos = this.axisPosition(axis);
            ++axis;
            positions.add(pos);
            while (this.LA(1) == 14) {
                this.match(14);
                pos = this.axisPosition(axis);
                ++axis;
                positions.add(pos);
            }
            this.match(6);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_0);
        }
        return positions;
    }

    public final AxisPosition axisPosition(int axis) throws RecognitionException, TokenStreamException {
        AxisPosition pos = null;
        try {
            int idx;
            switch (this.LA(1)) {
                case 15: {
                    this.match(15);
                    idx = -1;
                    break;
                }
                case 17: {
                    idx = this.idx();
                    break;
                }
                case 5: 
                case 18: {
                    Tuple tuple = this.tuple();
                    idx = this.mappingMeta.getTuplePosition(axis, tuple);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            pos = new AxisPosition(idx);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
        return pos;
    }

    public final Tuple tuple() throws RecognitionException, TokenStreamException {
        Tuple tuple = null;
        try {
            switch (this.LA(1)) {
                case 5: {
                    this.match(5);
                    tuple = new Tuple();
                    TupleMember member = this.tupleMember();
                    tuple.addMember(member);
                    while (this.LA(1) == 14) {
                        this.match(14);
                        member = this.tupleMember();
                        tuple.addMember(member);
                    }
                    this.match(6);
                    break;
                }
                case 18: {
                    TupleMember member = this.tupleMember();
                    tuple = new Tuple(member);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
        return tuple;
    }

    public final TupleMember tupleMember() throws RecognitionException, TokenStreamException {
        TupleMember tuple = new TupleMember();
        try {
            String name = this.mondrName();
            tuple.addName(name);
            while (this.LA(1) == 16) {
                this.match(16);
                name = this.mondrName();
                tuple.addName(name);
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
        return tuple;
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{2L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] data = new long[]{3984L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] data = new long[]{426018L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] data = new long[]{34L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        long[] data = new long[]{786432L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_5() {
        long[] data = new long[]{786466L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_6() {
        long[] data = new long[]{16482L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_7() {
        long[] data = new long[]{16448L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_8() {
        long[] data = new long[]{802914L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_9() {
        long[] data = new long[]{868450L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_10() {
        long[] data = new long[]{64L, 0L};
        return data;
    }
}

