/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class FloatArrayConverter
extends AbstractArrayConverter {
    private static final float[] MODEL = new float[0];

    public FloatArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public FloatArrayConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (MODEL.getClass() == value.getClass()) {
            return value;
        }
        if (strings.getClass() == value.getClass()) {
            try {
                String[] values = (String[])value;
                float[] results = new float[values.length];
                for (int i2 = 0; i2 < values.length; ++i2) {
                    results[i2] = Float.parseFloat(values[i2]);
                }
                return results;
            }
            catch (Exception e2) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(value.toString(), e2);
            }
        }
        try {
            List list = this.parseElements(value.toString());
            float[] results = new float[list.size()];
            for (int i3 = 0; i3 < results.length; ++i3) {
                results[i3] = Float.parseFloat((String)list.get(i3));
            }
            return results;
        }
        catch (Exception e3) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(value.toString(), e3);
        }
    }
}

