/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;

public class IfClosure
implements Closure,
Serializable {
    static final long serialVersionUID = 3518477308466486130L;
    private final Predicate iPredicate;
    private final Closure iTrueClosure;
    private final Closure iFalseClosure;

    public static Closure getInstance(Predicate predicate, Closure trueClosure, Closure falseClosure) {
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate must not be null");
        }
        if (trueClosure == null || falseClosure == null) {
            throw new IllegalArgumentException("Closures must not be null");
        }
        return new IfClosure(predicate, trueClosure, falseClosure);
    }

    public IfClosure(Predicate predicate, Closure trueClosure, Closure falseClosure) {
        this.iPredicate = predicate;
        this.iTrueClosure = trueClosure;
        this.iFalseClosure = falseClosure;
    }

    public void execute(Object input2) {
        if (this.iPredicate.evaluate(input2)) {
            this.iTrueClosure.execute(input2);
        } else {
            this.iFalseClosure.execute(input2);
        }
    }

    public Predicate getPredicate() {
        return this.iPredicate;
    }

    public Closure getTrueClosure() {
        return this.iTrueClosure;
    }

    public Closure getFalseClosure() {
        return this.iFalseClosure;
    }
}

