/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventusermodel;

import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingRowDummyRecord;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;

public final class MissingRecordAwareHSSFListener
implements HSSFListener {
    private HSSFListener childListener;
    private int lastRowRow;
    private int lastCellRow;
    private int lastCellColumn;

    public MissingRecordAwareHSSFListener(HSSFListener listener) {
        this.resetCounts();
        this.childListener = listener;
    }

    public void processRecord(Record record) {
        int thisColumn;
        int thisRow;
        if (record instanceof CellValueRecordInterface) {
            CellValueRecordInterface valueRec = (CellValueRecordInterface)((Object)record);
            thisRow = valueRec.getRow();
            thisColumn = valueRec.getColumn();
        } else {
            thisRow = -1;
            thisColumn = -1;
            switch (record.getSid()) {
                case 2057: {
                    BOFRecord bof = (BOFRecord)record;
                    if (bof.getType() != 5) {
                        if (bof.getType() != 16) break;
                    }
                    this.resetCounts();
                    break;
                }
                case 520: {
                    RowRecord rowrec = (RowRecord)record;
                    if (this.lastRowRow + 1 < rowrec.getRowNumber()) {
                        for (int i2 = this.lastRowRow + 1; i2 < rowrec.getRowNumber(); ++i2) {
                            MissingRowDummyRecord dr = new MissingRowDummyRecord(i2);
                            this.childListener.processRecord(dr);
                        }
                    }
                    this.lastRowRow = rowrec.getRowNumber();
                    break;
                }
                case 1212: {
                    this.childListener.processRecord(record);
                    return;
                }
                case 28: {
                    NoteRecord nrec = (NoteRecord)record;
                    thisRow = nrec.getRow();
                    thisColumn = nrec.getColumn();
                }
            }
        }
        if (thisRow != this.lastCellRow && this.lastCellRow > -1) {
            for (int i3 = this.lastCellRow; i3 < thisRow; ++i3) {
                int cols = -1;
                if (i3 == this.lastCellRow) {
                    cols = this.lastCellColumn;
                }
                this.childListener.processRecord(new LastCellOfRowDummyRecord(i3, cols));
            }
        }
        if (this.lastCellRow != -1 && this.lastCellColumn != -1 && thisRow == -1) {
            this.childListener.processRecord(new LastCellOfRowDummyRecord(this.lastCellRow, this.lastCellColumn));
            this.lastCellRow = -1;
            this.lastCellColumn = -1;
        }
        if (thisRow != this.lastCellRow) {
            this.lastCellColumn = -1;
        }
        if (this.lastCellColumn != thisColumn - 1) {
            for (int i4 = this.lastCellColumn + 1; i4 < thisColumn; ++i4) {
                this.childListener.processRecord(new MissingCellDummyRecord(thisRow, i4));
            }
        }
        if (thisColumn != -1) {
            this.lastCellColumn = thisColumn;
            this.lastCellRow = thisRow;
        }
        this.childListener.processRecord(record);
    }

    private void resetCounts() {
        this.lastRowRow = -1;
        this.lastCellRow = -1;
        this.lastCellColumn = -1;
    }
}

