/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import org.apache.poi.hssf.record.ExtSSTInfoSubRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class ExtSSTRecord
extends Record {
    public static final int DEFAULT_BUCKET_SIZE = 8;
    public static final int MAX_BUCKETS = 128;
    public static final short sid = 255;
    private short field_1_strings_per_bucket = (short)8;
    private ArrayList field_2_sst_info = new ArrayList();

    public ExtSSTRecord() {
    }

    public ExtSSTRecord(RecordInputStream in) {
        this.field_1_strings_per_bucket = in.readShort();
        while (in.remaining() > 0) {
            ExtSSTInfoSubRecord rec = new ExtSSTInfoSubRecord(in);
            this.field_2_sst_info.add(rec);
        }
    }

    public void setNumStringsPerBucket(short numStrings) {
        this.field_1_strings_per_bucket = numStrings;
    }

    public void addInfoRecord(ExtSSTInfoSubRecord rec) {
        this.field_2_sst_info.add(rec);
    }

    public short getNumStringsPerBucket() {
        return this.field_1_strings_per_bucket;
    }

    public int getNumInfoRecords() {
        return this.field_2_sst_info.size();
    }

    public ExtSSTInfoSubRecord getInfoRecordAt(int elem) {
        return (ExtSSTInfoSubRecord)this.field_2_sst_info.get(elem);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[EXTSST]\n");
        buffer.append("    .dsst           = ").append(Integer.toHexString(this.getNumStringsPerBucket())).append("\n");
        buffer.append("    .numInfoRecords = ").append(this.getNumInfoRecords()).append("\n");
        for (int k = 0; k < this.getNumInfoRecords(); ++k) {
            buffer.append("    .inforecord     = ").append(k).append("\n");
            buffer.append("    .streampos      = ").append(Integer.toHexString(this.getInfoRecordAt(k).getStreamPos())).append("\n");
            buffer.append("    .sstoffset      = ").append(Integer.toHexString(this.getInfoRecordAt(k).getBucketSSTOffset())).append("\n");
        }
        buffer.append("[/EXTSST]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)255);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, this.field_1_strings_per_bucket);
        int pos = 6;
        for (int k = 0; k < this.getNumInfoRecords(); ++k) {
            ExtSSTInfoSubRecord rec = this.getInfoRecordAt(k);
            pos += rec.serialize(pos + offset, data);
        }
        return pos;
    }

    public int getRecordSize() {
        return 6 + 8 * this.getNumInfoRecords();
    }

    public static final int getNumberOfInfoRecsForStrings(int numStrings) {
        int infoRecs = numStrings / 8;
        if (numStrings % 8 != 0) {
            ++infoRecs;
        }
        if (infoRecs > 128) {
            infoRecs = 128;
        }
        return infoRecs;
    }

    public static final int getRecordSizeForStrings(int numStrings) {
        return 6 + ExtSSTRecord.getNumberOfInfoRecsForStrings(numStrings) * 8;
    }

    public short getSid() {
        return 255;
    }

    public void setBucketOffsets(int[] bucketAbsoluteOffsets, int[] bucketRelativeOffsets) {
        this.field_2_sst_info = new ArrayList(bucketAbsoluteOffsets.length);
        for (int i2 = 0; i2 < bucketAbsoluteOffsets.length; ++i2) {
            ExtSSTInfoSubRecord r = new ExtSSTInfoSubRecord();
            r.setBucketRecordOffset((short)bucketRelativeOffsets[i2]);
            r.setStreamPos(bucketAbsoluteOffsets[i2]);
            this.field_2_sst_info.add(r);
        }
    }
}

