/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.UnionPtg;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.AreaReference;
import org.apache.poi.hssf.util.RangeAddress;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public final class NameRecord
extends Record {
    public static final short sid = 24;
    public static final byte BUILTIN_CONSOLIDATE_AREA = 1;
    public static final byte BUILTIN_AUTO_OPEN = 2;
    public static final byte BUILTIN_AUTO_CLOSE = 3;
    public static final byte BUILTIN_DATABASE = 4;
    public static final byte BUILTIN_CRITERIA = 5;
    public static final byte BUILTIN_PRINT_AREA = 6;
    public static final byte BUILTIN_PRINT_TITLE = 7;
    public static final byte BUILTIN_RECORDER = 8;
    public static final byte BUILTIN_DATA_FORM = 9;
    public static final byte BUILTIN_AUTO_ACTIVATE = 10;
    public static final byte BUILTIN_AUTO_DEACTIVATE = 11;
    public static final byte BUILTIN_SHEET_TITLE = 12;
    public static final byte BUILTIN_FILTER_DB = 13;
    private short field_1_option_flag;
    private byte field_2_keyboard_shortcut;
    private short field_5_externSheetIndex_plus1;
    private int field_6_sheetNumber;
    private boolean field_11_nameIsMultibyte;
    private byte field_12_built_in_code;
    private String field_12_name_text;
    private Ptg[] field_13_name_definition;
    private String field_14_custom_menu_text;
    private String field_15_description_text;
    private String field_16_help_topic_text;
    private String field_17_status_bar_text;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$Area3DPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$Ref3DPtg;

    public NameRecord() {
        this.field_13_name_definition = Ptg.EMPTY_PTG_ARRAY;
        this.field_12_name_text = "";
        this.field_14_custom_menu_text = "";
        this.field_15_description_text = "";
        this.field_16_help_topic_text = "";
        this.field_17_status_bar_text = "";
    }

    public NameRecord(byte builtin, int sheetNumber) {
        this();
        this.field_12_built_in_code = builtin;
        this.setOptionFlag((short)(this.field_1_option_flag | 0x20));
        this.field_6_sheetNumber = sheetNumber;
    }

    public void setOptionFlag(short flag) {
        this.field_1_option_flag = flag;
    }

    public void setKeyboardShortcut(byte shortcut) {
        this.field_2_keyboard_shortcut = shortcut;
    }

    public int getSheetNumber() {
        return this.field_6_sheetNumber;
    }

    public byte getFnGroup() {
        int masked = this.field_1_option_flag & 0xFC0;
        return (byte)(masked >> 4);
    }

    public void setSheetNumber(int value) {
        this.field_6_sheetNumber = value;
    }

    public void setNameText(String name) {
        this.field_12_name_text = name;
        this.field_11_nameIsMultibyte = StringUtil.hasMultibyte(name);
    }

    public void setCustomMenuText(String text) {
        this.field_14_custom_menu_text = text;
    }

    public void setDescriptionText(String text) {
        this.field_15_description_text = text;
    }

    public void setHelpTopicText(String text) {
        this.field_16_help_topic_text = text;
    }

    public void setStatusBarText(String text) {
        this.field_17_status_bar_text = text;
    }

    public short getOptionFlag() {
        return this.field_1_option_flag;
    }

    public byte getKeyboardShortcut() {
        return this.field_2_keyboard_shortcut;
    }

    private int getNameTextLength() {
        if (this.isBuiltInName()) {
            return 1;
        }
        return this.field_12_name_text.length();
    }

    public boolean isHiddenName() {
        return (this.field_1_option_flag & 1) != 0;
    }

    public void setHidden(boolean b2) {
        this.field_1_option_flag = b2 ? (short)(this.field_1_option_flag | 1) : (short)(this.field_1_option_flag & 0xFFFFFFFE);
    }

    public boolean isFunctionName() {
        return (this.field_1_option_flag & 2) != 0;
    }

    public boolean hasFormula() {
        return this.field_1_option_flag == 0 && this.field_13_name_definition.length > 0;
    }

    public boolean isCommandName() {
        return (this.field_1_option_flag & 4) != 0;
    }

    public boolean isMacro() {
        return (this.field_1_option_flag & 8) != 0;
    }

    public boolean isComplexFunction() {
        return (this.field_1_option_flag & 0x10) != 0;
    }

    public boolean isBuiltInName() {
        return (this.field_1_option_flag & 0x20) != 0;
    }

    public String getNameText() {
        return this.isBuiltInName() ? NameRecord.translateBuiltInName(this.getBuiltInName()) : this.field_12_name_text;
    }

    public byte getBuiltInName() {
        return this.field_12_built_in_code;
    }

    public Ptg[] getNameDefinition() {
        return (Ptg[])this.field_13_name_definition.clone();
    }

    public void setNameDefinition(Ptg[] ptgs) {
        this.field_13_name_definition = (Ptg[])ptgs.clone();
    }

    public String getCustomMenuText() {
        return this.field_14_custom_menu_text;
    }

    public String getDescriptionText() {
        return this.field_15_description_text;
    }

    public String getHelpTopicText() {
        return this.field_16_help_topic_text;
    }

    public String getStatusBarText() {
        return this.field_17_status_bar_text;
    }

    public int serialize(int offset, byte[] data) {
        int field_7_length_custom_menu = this.field_14_custom_menu_text.length();
        int field_8_length_description_text = this.field_15_description_text.length();
        int field_9_length_help_topic_text = this.field_16_help_topic_text.length();
        int field_10_length_status_bar_text = this.field_17_status_bar_text.length();
        int rawNameSize = this.getNameRawSize();
        int formulaTotalSize = Ptg.getEncodedSize(this.field_13_name_definition);
        int dataSize = 15 + rawNameSize + field_7_length_custom_menu + field_8_length_description_text + field_9_length_help_topic_text + field_10_length_status_bar_text + formulaTotalSize;
        LittleEndian.putShort(data, 0 + offset, (short)24);
        LittleEndian.putUShort(data, 2 + offset, dataSize);
        LittleEndian.putShort(data, 4 + offset, this.getOptionFlag());
        LittleEndian.putByte(data, 6 + offset, this.getKeyboardShortcut());
        LittleEndian.putByte(data, 7 + offset, this.getNameTextLength());
        LittleEndian.putUShort(data, 8 + offset, Ptg.getEncodedSizeWithoutArrayData(this.field_13_name_definition));
        LittleEndian.putUShort(data, 10 + offset, this.field_5_externSheetIndex_plus1);
        LittleEndian.putUShort(data, 12 + offset, this.field_6_sheetNumber);
        LittleEndian.putByte(data, 14 + offset, field_7_length_custom_menu);
        LittleEndian.putByte(data, 15 + offset, field_8_length_description_text);
        LittleEndian.putByte(data, 16 + offset, field_9_length_help_topic_text);
        LittleEndian.putByte(data, 17 + offset, field_10_length_status_bar_text);
        LittleEndian.putByte(data, 18 + offset, this.field_11_nameIsMultibyte ? 1 : 0);
        int pos = 19 + offset;
        if (this.isBuiltInName()) {
            LittleEndian.putByte(data, pos, this.field_12_built_in_code);
        } else {
            String nameText = this.field_12_name_text;
            if (this.field_11_nameIsMultibyte) {
                StringUtil.putUnicodeLE(nameText, data, pos);
            } else {
                StringUtil.putCompressedUnicode(nameText, data, pos);
            }
        }
        Ptg.serializePtgs(this.field_13_name_definition, data, pos += rawNameSize);
        StringUtil.putCompressedUnicode(this.getCustomMenuText(), data, pos += formulaTotalSize);
        StringUtil.putCompressedUnicode(this.getDescriptionText(), data, pos += field_7_length_custom_menu);
        StringUtil.putCompressedUnicode(this.getHelpTopicText(), data, pos += field_8_length_description_text);
        StringUtil.putCompressedUnicode(this.getStatusBarText(), data, pos += field_9_length_help_topic_text);
        return 4 + dataSize;
    }

    private int getNameRawSize() {
        if (this.isBuiltInName()) {
            return 1;
        }
        int nChars = this.field_12_name_text.length();
        if (this.field_11_nameIsMultibyte) {
            return 2 * nChars;
        }
        return nChars;
    }

    public int getRecordSize() {
        return 19 + this.getNameRawSize() + this.field_14_custom_menu_text.length() + this.field_15_description_text.length() + this.field_16_help_topic_text.length() + this.field_17_status_bar_text.length() + Ptg.getEncodedSize(this.field_13_name_definition);
    }

    public int getExternSheetNumber() {
        if (this.field_13_name_definition.length < 1) {
            return 0;
        }
        Ptg ptg = this.field_13_name_definition[0];
        if (ptg.getClass() == (class$org$apache$poi$hssf$record$formula$Area3DPtg == null ? (class$org$apache$poi$hssf$record$formula$Area3DPtg = NameRecord.class$("org.apache.poi.hssf.record.formula.Area3DPtg")) : class$org$apache$poi$hssf$record$formula$Area3DPtg)) {
            return ((Area3DPtg)ptg).getExternSheetIndex();
        }
        if (ptg.getClass() == (class$org$apache$poi$hssf$record$formula$Ref3DPtg == null ? (class$org$apache$poi$hssf$record$formula$Ref3DPtg = NameRecord.class$("org.apache.poi.hssf.record.formula.Ref3DPtg")) : class$org$apache$poi$hssf$record$formula$Ref3DPtg)) {
            return ((Ref3DPtg)ptg).getExternSheetIndex();
        }
        return 0;
    }

    public void setExternSheetNumber(short externSheetNumber) {
        Ptg ptg;
        if (this.field_13_name_definition.length < 1) {
            ptg = NameRecord.createNewPtg();
            this.field_13_name_definition = new Ptg[]{ptg};
        } else {
            ptg = this.field_13_name_definition[0];
        }
        if (ptg.getClass() == (class$org$apache$poi$hssf$record$formula$Area3DPtg == null ? (class$org$apache$poi$hssf$record$formula$Area3DPtg = NameRecord.class$("org.apache.poi.hssf.record.formula.Area3DPtg")) : class$org$apache$poi$hssf$record$formula$Area3DPtg)) {
            ((Area3DPtg)ptg).setExternSheetIndex(externSheetNumber);
        } else if (ptg.getClass() == (class$org$apache$poi$hssf$record$formula$Ref3DPtg == null ? (class$org$apache$poi$hssf$record$formula$Ref3DPtg = NameRecord.class$("org.apache.poi.hssf.record.formula.Ref3DPtg")) : class$org$apache$poi$hssf$record$formula$Ref3DPtg)) {
            ((Ref3DPtg)ptg).setExternSheetIndex(externSheetNumber);
        }
    }

    private static Ptg createNewPtg() {
        return new Area3DPtg("A1:A1", 0);
    }

    public String getAreaReference(HSSFWorkbook book) {
        return HSSFFormulaParser.toFormulaString(book, this.field_13_name_definition);
    }

    public void setAreaReference(String ref) {
        RangeAddress ra = new RangeAddress(ref);
        Ptg oldPtg = this.field_13_name_definition.length < 1 ? NameRecord.createNewPtg() : this.field_13_name_definition[0];
        ArrayList<Ptg> temp = new ArrayList<Ptg>();
        int externSheetIndex = 0;
        if (oldPtg.getClass() == (class$org$apache$poi$hssf$record$formula$Area3DPtg == null ? (class$org$apache$poi$hssf$record$formula$Area3DPtg = NameRecord.class$("org.apache.poi.hssf.record.formula.Area3DPtg")) : class$org$apache$poi$hssf$record$formula$Area3DPtg)) {
            externSheetIndex = ((Area3DPtg)oldPtg).getExternSheetIndex();
        } else if (oldPtg.getClass() == (class$org$apache$poi$hssf$record$formula$Ref3DPtg == null ? (class$org$apache$poi$hssf$record$formula$Ref3DPtg = NameRecord.class$("org.apache.poi.hssf.record.formula.Ref3DPtg")) : class$org$apache$poi$hssf$record$formula$Ref3DPtg)) {
            externSheetIndex = ((Ref3DPtg)oldPtg).getExternSheetIndex();
        }
        if (ra.hasRange()) {
            AreaReference[] refs = AreaReference.generateContiguous(ref);
            for (int i2 = 0; i2 < refs.length; ++i2) {
                Area3DPtg ptg = new Area3DPtg(refs[i2].formatAsString(), externSheetIndex);
                temp.add(ptg);
            }
            if (refs.length > 1) {
                OperationPtg ptg = UnionPtg.instance;
                temp.add(ptg);
            }
        } else {
            Ref3DPtg ptg = new Ref3DPtg(ra.getFromCell(), externSheetIndex);
            temp.add(ptg);
        }
        Ptg[] ptgs = new Ptg[temp.size()];
        temp.toArray(ptgs);
        this.field_13_name_definition = ptgs;
    }

    public NameRecord(RecordInputStream in) {
        this.field_1_option_flag = in.readShort();
        this.field_2_keyboard_shortcut = in.readByte();
        byte field_3_length_name_text = in.readByte();
        short field_4_length_name_definition = in.readShort();
        this.field_5_externSheetIndex_plus1 = in.readShort();
        this.field_6_sheetNumber = in.readUShort();
        short field_7_length_custom_menu = in.readUByte();
        short field_8_length_description_text = in.readUByte();
        short field_9_length_help_topic_text = in.readUByte();
        short field_10_length_status_bar_text = in.readUByte();
        boolean bl = this.field_11_nameIsMultibyte = in.readByte() != 0;
        if (this.isBuiltInName()) {
            this.field_12_built_in_code = in.readByte();
        } else {
            this.field_12_name_text = this.field_11_nameIsMultibyte ? in.readUnicodeLEString(field_3_length_name_text) : in.readCompressedUnicode(field_3_length_name_text);
        }
        this.field_13_name_definition = Ptg.readTokens(field_4_length_name_definition, in);
        this.field_14_custom_menu_text = in.readCompressedUnicode(field_7_length_custom_menu);
        this.field_15_description_text = in.readCompressedUnicode(field_8_length_description_text);
        this.field_16_help_topic_text = in.readCompressedUnicode(field_9_length_help_topic_text);
        this.field_17_status_bar_text = in.readCompressedUnicode(field_10_length_status_bar_text);
    }

    public short getSid() {
        return 24;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[NAME]\n");
        sb.append("    .option flags           = ").append(HexDump.shortToHex(this.field_1_option_flag)).append("\n");
        sb.append("    .keyboard shortcut      = ").append(HexDump.byteToHex(this.field_2_keyboard_shortcut)).append("\n");
        sb.append("    .length of the name     = ").append(this.getNameTextLength()).append("\n");
        sb.append("    .extSheetIx(1-based, 0=Global)= ").append(this.field_5_externSheetIndex_plus1).append("\n");
        sb.append("    .sheetTabIx             = ").append(this.field_6_sheetNumber).append("\n");
        sb.append("    .Menu text length       = ").append(this.field_14_custom_menu_text.length()).append("\n");
        sb.append("    .Description text length= ").append(this.field_15_description_text.length()).append("\n");
        sb.append("    .Help topic text length = ").append(this.field_16_help_topic_text.length()).append("\n");
        sb.append("    .Status bar text length = ").append(this.field_17_status_bar_text.length()).append("\n");
        sb.append("    .NameIsMultibyte        = ").append(this.field_11_nameIsMultibyte).append("\n");
        sb.append("    .Name (Unicode text)    = ").append(this.getNameText()).append("\n");
        sb.append("    .Formula (nTokens=").append(this.field_13_name_definition.length).append("):").append("\n");
        for (int i2 = 0; i2 < this.field_13_name_definition.length; ++i2) {
            Ptg ptg = this.field_13_name_definition[i2];
            sb.append("       " + ptg.toString()).append(ptg.getRVAType()).append("\n");
        }
        sb.append("    .Menu text       = ").append(this.field_14_custom_menu_text).append("\n");
        sb.append("    .Description text= ").append(this.field_15_description_text).append("\n");
        sb.append("    .Help topic text = ").append(this.field_16_help_topic_text).append("\n");
        sb.append("    .Status bar text = ").append(this.field_17_status_bar_text).append("\n");
        sb.append("[/NAME]\n");
        return sb.toString();
    }

    private static String translateBuiltInName(byte name) {
        switch (name) {
            case 10: {
                return "Auto_Activate";
            }
            case 3: {
                return "Auto_Close";
            }
            case 11: {
                return "Auto_Deactivate";
            }
            case 2: {
                return "Auto_Open";
            }
            case 1: {
                return "Consolidate_Area";
            }
            case 5: {
                return "Criteria";
            }
            case 4: {
                return "Database";
            }
            case 9: {
                return "Data_Form";
            }
            case 6: {
                return "Print_Area";
            }
            case 7: {
                return "Print_Titles";
            }
            case 8: {
                return "Recorder";
            }
            case 12: {
                return "Sheet_Title";
            }
            case 13: {
                return "_FilterDatabase";
            }
        }
        return "Unknown";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Option {
        public static final int OPT_HIDDEN_NAME = 1;
        public static final int OPT_FUNCTION_NAME = 2;
        public static final int OPT_COMMAND_NAME = 4;
        public static final int OPT_MACRO = 8;
        public static final int OPT_COMPLEX = 16;
        public static final int OPT_BUILTIN = 32;
        public static final int OPT_BINDATA = 4096;

        private Option() {
        }
    }
}

