/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.ScalarConstantPtg;
import org.apache.poi.hssf.usermodel.HSSFErrorConstants;

public final class ErrPtg
extends ScalarConstantPtg {
    private static final HSSFErrorConstants EC = null;
    public static final ErrPtg NULL_INTERSECTION = new ErrPtg(0);
    public static final ErrPtg DIV_ZERO = new ErrPtg(7);
    public static final ErrPtg VALUE_INVALID = new ErrPtg(15);
    public static final ErrPtg REF_INVALID = new ErrPtg(23);
    public static final ErrPtg NAME_INVALID = new ErrPtg(29);
    public static final ErrPtg NUM_ERROR = new ErrPtg(36);
    public static final ErrPtg N_A = new ErrPtg(42);
    public static final short sid = 28;
    private static final int SIZE = 2;
    private final int field_1_error_code;

    private ErrPtg(int errorCode) {
        if (!HSSFErrorConstants.isValidCode(errorCode)) {
            throw new IllegalArgumentException("Invalid error code (" + errorCode + ")");
        }
        this.field_1_error_code = errorCode;
    }

    public static ErrPtg read(RecordInputStream in) {
        return ErrPtg.valueOf(in.readByte());
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(28 + this.getPtgClass());
        array[offset + 1] = (byte)this.field_1_error_code;
    }

    public String toFormulaString() {
        return HSSFErrorConstants.getText(this.field_1_error_code);
    }

    public int getSize() {
        return 2;
    }

    public int getErrorCode() {
        return this.field_1_error_code;
    }

    public static ErrPtg valueOf(int code2) {
        switch (code2) {
            case 7: {
                return DIV_ZERO;
            }
            case 42: {
                return N_A;
            }
            case 29: {
                return NAME_INVALID;
            }
            case 0: {
                return NULL_INTERSECTION;
            }
            case 36: {
                return NUM_ERROR;
            }
            case 23: {
                return REF_INVALID;
            }
            case 15: {
                return VALUE_INVALID;
            }
        }
        throw new RuntimeException("Unexpected error code (" + code2 + ")");
    }
}

