/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;

public final class CalendarFieldFunction
implements Function {
    public static final Function YEAR = new CalendarFieldFunction(1, false);
    public static final Function MONTH = new CalendarFieldFunction(2, true);
    public static final Function DAY = new CalendarFieldFunction(5, false);
    private final int _dateFieldId;
    private final boolean _needsOneBaseAdjustment;

    private CalendarFieldFunction(int dateFieldId, boolean needsOneBaseAdjustment) {
        this._dateFieldId = dateFieldId;
        this._needsOneBaseAdjustment = needsOneBaseAdjustment;
    }

    public Eval evaluate(Eval[] operands, int srcCellRow, short srcCellCol) {
        int val;
        if (operands.length != 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ValueEval ve = OperandResolver.getSingleValue(operands[0], srcCellRow, srcCellCol);
            val = OperandResolver.coerceValueToInt(ve);
        }
        catch (EvaluationException e2) {
            return e2.getErrorEval();
        }
        if (val < 0) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(this.getCalField(val));
    }

    private int getCalField(int serialDay) {
        if (serialDay == 0) {
            switch (this._dateFieldId) {
                case 1: {
                    return 1900;
                }
                case 2: {
                    return 1;
                }
                case 5: {
                    return 0;
                }
            }
            throw new IllegalStateException("bad date field " + this._dateFieldId);
        }
        Date d2 = HSSFDateUtil.getJavaDate(serialDay, false);
        GregorianCalendar c2 = new GregorianCalendar();
        c2.setTime(d2);
        int result = c2.get(this._dateFieldId);
        if (this._needsOneBaseAdjustment) {
            ++result;
        }
        return result;
    }
}

