/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.model.Sheet;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import org.apache.poi.hssf.record.DrawingRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.HyperlinkRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordBase;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public final class HSSFCell {
    public static final int CELL_TYPE_NUMERIC = 0;
    public static final int CELL_TYPE_STRING = 1;
    public static final int CELL_TYPE_FORMULA = 2;
    public static final int CELL_TYPE_BLANK = 3;
    public static final int CELL_TYPE_BOOLEAN = 4;
    public static final int CELL_TYPE_ERROR = 5;
    public static final short ENCODING_UNCHANGED = -1;
    public static final short ENCODING_COMPRESSED_UNICODE = 0;
    public static final short ENCODING_UTF_16 = 1;
    private final HSSFWorkbook book;
    private final HSSFSheet sheet;
    private int cellType;
    private HSSFRichTextString stringValue;
    private CellValueRecordInterface record;
    private HSSFComment comment;

    protected HSSFCell(HSSFWorkbook book, HSSFSheet sheet, int row, short col2) {
        this.checkBounds(col2);
        this.stringValue = null;
        this.book = book;
        this.sheet = sheet;
        short xfindex = sheet.getSheet().getXFIndexForColAt(col2);
        this.setCellType(3, false, row, col2, xfindex);
    }

    public HSSFSheet getSheet() {
        return this.sheet;
    }

    protected HSSFCell(HSSFWorkbook book, HSSFSheet sheet, int row, short col2, int type) {
        this.checkBounds(col2);
        this.cellType = -1;
        this.stringValue = null;
        this.book = book;
        this.sheet = sheet;
        short xfindex = sheet.getSheet().getXFIndexForColAt(col2);
        this.setCellType(type, false, row, col2, xfindex);
    }

    protected HSSFCell(HSSFWorkbook book, HSSFSheet sheet, CellValueRecordInterface cval) {
        this.record = cval;
        this.cellType = HSSFCell.determineType(cval);
        this.stringValue = null;
        this.book = book;
        this.sheet = sheet;
        switch (this.cellType) {
            case 1: {
                this.stringValue = new HSSFRichTextString(book.getWorkbook(), (LabelSSTRecord)cval);
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                this.stringValue = new HSSFRichTextString(((FormulaRecordAggregate)cval).getStringValue());
            }
        }
        ExtendedFormatRecord xf = book.getWorkbook().getExFormatAt(cval.getXFIndex());
        this.setCellStyle(new HSSFCellStyle(cval.getXFIndex(), xf, book));
    }

    private static int determineType(CellValueRecordInterface cval) {
        if (cval instanceof FormulaRecordAggregate) {
            return 2;
        }
        Record record = (Record)((Object)cval);
        switch (record.getSid()) {
            case 515: {
                return 0;
            }
            case 513: {
                return 3;
            }
            case 253: {
                return 1;
            }
            case 517: {
                BoolErrRecord boolErrRecord = (BoolErrRecord)record;
                return boolErrRecord.isBoolean() ? 4 : 5;
            }
        }
        throw new RuntimeException("Bad cell value rec (" + cval.getClass().getName() + ")");
    }

    protected Workbook getBoundWorkbook() {
        return this.book.getWorkbook();
    }

    public int getRowIndex() {
        return this.record.getRow();
    }

    public void setCellNum(short num) {
        this.record.setColumn(num);
    }

    protected void updateCellNum(short num) {
        this.record.setColumn(num);
    }

    public short getCellNum() {
        return (short)this.getColumnIndex();
    }

    public int getColumnIndex() {
        return this.record.getColumn() & 0xFFFF;
    }

    public void setCellType(int cellType) {
        int row = this.record.getRow();
        short col2 = this.record.getColumn();
        short styleIndex = this.record.getXFIndex();
        this.setCellType(cellType, true, row, col2, styleIndex);
    }

    private void setCellType(int cellType, boolean setValue, int row, short col2, short styleIndex) {
        if (cellType > 5) {
            throw new RuntimeException("I have no idea what type that is!");
        }
        switch (cellType) {
            case 2: {
                FormulaRecordAggregate frec;
                if (cellType != this.cellType) {
                    frec = this.sheet.getSheet().getRowsAggregate().createFormula(row, col2);
                } else {
                    frec = (FormulaRecordAggregate)this.record;
                    frec.setRow(row);
                    frec.setColumn(col2);
                }
                if (setValue) {
                    frec.getFormulaRecord().setValue(this.getNumericCellValue());
                }
                frec.setXFIndex(styleIndex);
                this.record = frec;
                break;
            }
            case 0: {
                NumberRecord nrec = null;
                nrec = cellType != this.cellType ? new NumberRecord() : (NumberRecord)this.record;
                nrec.setColumn(col2);
                if (setValue) {
                    nrec.setValue(this.getNumericCellValue());
                }
                nrec.setXFIndex(styleIndex);
                nrec.setRow(row);
                this.record = nrec;
                break;
            }
            case 1: {
                LabelSSTRecord lrec = null;
                lrec = cellType != this.cellType ? new LabelSSTRecord() : (LabelSSTRecord)this.record;
                lrec.setColumn(col2);
                lrec.setRow(row);
                lrec.setXFIndex(styleIndex);
                if (setValue && this.getStringCellValue() != null && !this.getStringCellValue().equals("")) {
                    int sst = 0;
                    UnicodeString str = this.getRichStringCellValue().getUnicodeString();
                    sst = this.book.getWorkbook().addSSTString(str);
                    lrec.setSSTIndex(sst);
                    this.getRichStringCellValue().setUnicodeString(this.book.getWorkbook().getSSTString(sst));
                }
                this.record = lrec;
                break;
            }
            case 3: {
                BlankRecord brec = null;
                brec = cellType != this.cellType ? new BlankRecord() : (BlankRecord)this.record;
                brec.setColumn(col2);
                brec.setXFIndex(styleIndex);
                brec.setRow(row);
                this.record = brec;
                break;
            }
            case 4: {
                BoolErrRecord boolRec = null;
                boolRec = cellType != this.cellType ? new BoolErrRecord() : (BoolErrRecord)this.record;
                boolRec.setColumn(col2);
                if (setValue) {
                    boolRec.setValue(this.convertCellValueToBoolean());
                }
                boolRec.setXFIndex(styleIndex);
                boolRec.setRow(row);
                this.record = boolRec;
                break;
            }
            case 5: {
                BoolErrRecord errRec = null;
                errRec = cellType != this.cellType ? new BoolErrRecord() : (BoolErrRecord)this.record;
                errRec.setColumn(col2);
                if (setValue) {
                    errRec.setValue((byte)15);
                }
                errRec.setXFIndex(styleIndex);
                errRec.setRow(row);
                this.record = errRec;
            }
        }
        if (cellType != this.cellType && this.cellType != -1) {
            this.sheet.getSheet().replaceValueRecord(this.record);
        }
        this.cellType = cellType;
    }

    public int getCellType() {
        return this.cellType;
    }

    public void setCellValue(double value) {
        int row = this.record.getRow();
        short col2 = this.record.getColumn();
        short styleIndex = this.record.getXFIndex();
        switch (this.cellType) {
            default: {
                this.setCellType(0, false, row, col2, styleIndex);
            }
            case 5: {
                ((NumberRecord)this.record).setValue(value);
                break;
            }
            case 2: {
                ((FormulaRecordAggregate)this.record).getFormulaRecord().setValue(value);
            }
        }
    }

    public void setCellValue(Date value) {
        this.setCellValue(HSSFDateUtil.getExcelDate(value, this.book.getWorkbook().isUsing1904DateWindowing()));
    }

    public void setCellValue(Calendar value) {
        this.setCellValue(HSSFDateUtil.getExcelDate(value, this.book.getWorkbook().isUsing1904DateWindowing()));
    }

    public void setCellValue(String value) {
        HSSFRichTextString str = new HSSFRichTextString(value);
        this.setCellValue(str);
    }

    public void setCellValue(HSSFRichTextString value) {
        int row = this.record.getRow();
        short col2 = this.record.getColumn();
        short styleIndex = this.record.getXFIndex();
        if (value == null) {
            this.setCellType(3, false, row, col2, styleIndex);
            return;
        }
        if (this.cellType == 2) {
            FormulaRecordAggregate fr = (FormulaRecordAggregate)this.record;
            fr.setCachedStringResult(value.getString());
            this.stringValue = new HSSFRichTextString(value.getString());
            return;
        }
        if (this.cellType != 1) {
            this.setCellType(1, false, row, col2, styleIndex);
        }
        int index = 0;
        UnicodeString str = value.getUnicodeString();
        index = this.book.getWorkbook().addSSTString(str);
        ((LabelSSTRecord)this.record).setSSTIndex(index);
        this.stringValue = value;
        this.stringValue.setWorkbookReferences(this.book.getWorkbook(), (LabelSSTRecord)this.record);
        this.stringValue.setUnicodeString(this.book.getWorkbook().getSSTString(index));
    }

    public void setCellFormula(String formula) {
        int row = this.record.getRow();
        short col2 = this.record.getColumn();
        short styleIndex = this.record.getXFIndex();
        if (formula == null) {
            this.setCellType(3, false, row, col2, styleIndex);
            return;
        }
        this.setCellType(2, false, row, col2, styleIndex);
        FormulaRecordAggregate rec = (FormulaRecordAggregate)this.record;
        FormulaRecord frec = rec.getFormulaRecord();
        frec.setOptions((short)2);
        frec.setValue(0.0);
        if (rec.getXFIndex() == 0) {
            rec.setXFIndex((short)15);
        }
        Ptg[] ptgs = HSSFFormulaParser.parse(formula, this.book);
        frec.setParsedExpression(ptgs);
    }

    public String getCellFormula() {
        return HSSFFormulaParser.toFormulaString(this.book, ((FormulaRecordAggregate)this.record).getFormulaRecord().getParsedExpression());
    }

    private static String getCellTypeName(int cellTypeCode) {
        switch (cellTypeCode) {
            case 3: {
                return "blank";
            }
            case 1: {
                return "text";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "error";
            }
            case 0: {
                return "numeric";
            }
            case 2: {
                return "formula";
            }
        }
        return "#unknown cell type (" + cellTypeCode + ")#";
    }

    private static RuntimeException typeMismatch(int expectedTypeCode, int actualTypeCode, boolean isFormulaCell) {
        String msg = "Cannot get a " + HSSFCell.getCellTypeName(expectedTypeCode) + " value from a " + HSSFCell.getCellTypeName(actualTypeCode) + " " + (isFormulaCell ? "formula " : "") + "cell";
        return new IllegalStateException(msg);
    }

    private static void checkFormulaCachedValueType(int expectedTypeCode, FormulaRecord fr) {
        int cachedValueType = fr.getCachedResultType();
        if (cachedValueType != expectedTypeCode) {
            throw HSSFCell.typeMismatch(expectedTypeCode, cachedValueType, true);
        }
    }

    public double getNumericCellValue() {
        switch (this.cellType) {
            case 3: {
                return 0.0;
            }
            case 0: {
                return ((NumberRecord)this.record).getValue();
            }
            default: {
                throw HSSFCell.typeMismatch(0, this.cellType, false);
            }
            case 2: 
        }
        FormulaRecord fr = ((FormulaRecordAggregate)this.record).getFormulaRecord();
        HSSFCell.checkFormulaCachedValueType(0, fr);
        return fr.getValue();
    }

    public Date getDateCellValue() {
        if (this.cellType == 3) {
            return null;
        }
        double value = this.getNumericCellValue();
        if (this.book.getWorkbook().isUsing1904DateWindowing()) {
            return HSSFDateUtil.getJavaDate(value, true);
        }
        return HSSFDateUtil.getJavaDate(value, false);
    }

    public String getStringCellValue() {
        HSSFRichTextString str = this.getRichStringCellValue();
        return str.getString();
    }

    public HSSFRichTextString getRichStringCellValue() {
        switch (this.cellType) {
            case 3: {
                return new HSSFRichTextString("");
            }
            case 1: {
                return this.stringValue;
            }
            default: {
                throw HSSFCell.typeMismatch(1, this.cellType, false);
            }
            case 2: 
        }
        FormulaRecordAggregate fra = (FormulaRecordAggregate)this.record;
        HSSFCell.checkFormulaCachedValueType(1, fra.getFormulaRecord());
        String strVal = fra.getStringValue();
        return new HSSFRichTextString(strVal == null ? "" : strVal);
    }

    public void setCellValue(boolean value) {
        int row = this.record.getRow();
        short col2 = this.record.getColumn();
        short styleIndex = this.record.getXFIndex();
        switch (this.cellType) {
            default: {
                this.setCellType(4, false, row, col2, styleIndex);
            }
            case 5: {
                ((BoolErrRecord)this.record).setValue(value);
                break;
            }
            case 2: {
                ((FormulaRecordAggregate)this.record).getFormulaRecord().setCachedResultBoolean(value);
            }
        }
    }

    public void setCellErrorValue(byte errorCode) {
        int row = this.record.getRow();
        short col2 = this.record.getColumn();
        short styleIndex = this.record.getXFIndex();
        switch (this.cellType) {
            default: {
                this.setCellType(5, false, row, col2, styleIndex);
            }
            case 5: {
                ((BoolErrRecord)this.record).setValue(errorCode);
                break;
            }
            case 2: {
                ((FormulaRecordAggregate)this.record).getFormulaRecord().setCachedResultErrorCode(errorCode);
            }
        }
    }

    private boolean convertCellValueToBoolean() {
        switch (this.cellType) {
            case 4: {
                return ((BoolErrRecord)this.record).getBooleanValue();
            }
            case 1: {
                return Boolean.valueOf(((StringRecord)((Object)this.record)).getString());
            }
            case 0: {
                return ((NumberRecord)this.record).getValue() != 0.0;
            }
            case 2: 
            case 3: 
            case 5: {
                return false;
            }
        }
        throw new RuntimeException("Unexpected cell type (" + this.cellType + ")");
    }

    public boolean getBooleanCellValue() {
        switch (this.cellType) {
            case 3: {
                return false;
            }
            case 4: {
                return ((BoolErrRecord)this.record).getBooleanValue();
            }
            default: {
                throw HSSFCell.typeMismatch(4, this.cellType, false);
            }
            case 2: 
        }
        FormulaRecord fr = ((FormulaRecordAggregate)this.record).getFormulaRecord();
        HSSFCell.checkFormulaCachedValueType(4, fr);
        return fr.getCachedBooleanValue();
    }

    public byte getErrorCellValue() {
        switch (this.cellType) {
            case 5: {
                return ((BoolErrRecord)this.record).getErrorValue();
            }
            default: {
                throw HSSFCell.typeMismatch(5, this.cellType, false);
            }
            case 2: 
        }
        FormulaRecord fr = ((FormulaRecordAggregate)this.record).getFormulaRecord();
        HSSFCell.checkFormulaCachedValueType(5, fr);
        return (byte)fr.getCachedErrorValue();
    }

    public void setCellStyle(HSSFCellStyle style2) {
        style2.verifyBelongsToWorkbook(this.book);
        this.record.setXFIndex(style2.getIndex());
    }

    public HSSFCellStyle getCellStyle() {
        short styleIndex = this.record.getXFIndex();
        ExtendedFormatRecord xf = this.book.getWorkbook().getExFormatAt(styleIndex);
        return new HSSFCellStyle(styleIndex, xf, this.book);
    }

    protected CellValueRecordInterface getCellValueRecord() {
        return this.record;
    }

    private void checkBounds(int cellNum) {
        if (cellNum > 255) {
            throw new RuntimeException("You cannot have more than 255 columns in a given row (IV).  Because Excel can't handle it");
        }
        if (cellNum < 0) {
            throw new RuntimeException("You cannot reference columns with an index of less then 0.");
        }
    }

    public void setAsActiveCell() {
        int row = this.record.getRow();
        short col2 = this.record.getColumn();
        this.sheet.getSheet().setActiveCellRow(row);
        this.sheet.getSheet().setActiveCellCol(col2);
    }

    public String toString() {
        switch (this.getCellType()) {
            case 3: {
                return "";
            }
            case 4: {
                return this.getBooleanCellValue() ? "TRUE" : "FALSE";
            }
            case 5: {
                return ErrorEval.getText(((BoolErrRecord)this.record).getErrorValue());
            }
            case 2: {
                return this.getCellFormula();
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted(this)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
                    return sdf.format(this.getDateCellValue());
                }
                return this.getNumericCellValue() + "";
            }
            case 1: {
                return this.getStringCellValue();
            }
        }
        return "Unknown Cell Type: " + this.getCellType();
    }

    public void setCellComment(HSSFComment comment2) {
        if (comment2 == null) {
            this.removeCellComment();
            return;
        }
        comment2.setRow((short)this.record.getRow());
        comment2.setColumn(this.record.getColumn());
        this.comment = comment2;
    }

    public HSSFComment getCellComment() {
        if (this.comment == null) {
            this.comment = HSSFCell.findCellComment(this.sheet.getSheet(), this.record.getRow(), this.record.getColumn());
        }
        return this.comment;
    }

    public void removeCellComment() {
        HSSFComment comment2 = HSSFCell.findCellComment(this.sheet.getSheet(), this.record.getRow(), this.record.getColumn());
        this.comment = null;
        if (comment2 == null) {
            return;
        }
        List sheetRecords = this.sheet.getSheet().getRecords();
        sheetRecords.remove(comment2.getNoteRecord());
        if (comment2.getTextObjectRecord() != null) {
            TextObjectRecord txo = comment2.getTextObjectRecord();
            int txoAt = sheetRecords.indexOf(txo);
            if (!(sheetRecords.get(txoAt - 3) instanceof DrawingRecord && sheetRecords.get(txoAt - 2) instanceof ObjRecord && sheetRecords.get(txoAt - 1) instanceof DrawingRecord)) {
                throw new IllegalStateException("Found the wrong records before the TextObjectRecord, can't remove comment");
            }
            sheetRecords.remove(txoAt - 1);
            sheetRecords.remove(txoAt - 2);
            sheetRecords.remove(txoAt - 3);
            sheetRecords.remove(txo);
        }
    }

    protected static HSSFComment findCellComment(Sheet sheet, int row, int column) {
        HSSFComment comment2 = null;
        HashMap<Integer, RecordBase> txshapes = new HashMap<Integer, RecordBase>();
        Iterator it = sheet.getRecords().iterator();
        block0: while (it.hasNext()) {
            CommonObjectDataSubRecord cmo;
            ObjRecord obj;
            SubRecord sub2;
            RecordBase rec = (RecordBase)it.next();
            if (rec instanceof NoteRecord) {
                NoteRecord note = (NoteRecord)rec;
                if (note.getRow() != row || note.getColumn() != column) continue;
                TextObjectRecord txo = (TextObjectRecord)txshapes.get(new Integer(note.getShapeId()));
                comment2 = new HSSFComment(note, txo);
                comment2.setRow(note.getRow());
                comment2.setColumn(note.getColumn());
                comment2.setAuthor(note.getAuthor());
                comment2.setVisible(note.getFlags() == 2);
                comment2.setString(txo.getStr());
                break;
            }
            if (!(rec instanceof ObjRecord) || !((sub2 = (SubRecord)(obj = (ObjRecord)rec).getSubRecords().get(0)) instanceof CommonObjectDataSubRecord) || (cmo = (CommonObjectDataSubRecord)sub2).getObjectType() != 25) continue;
            while (it.hasNext()) {
                rec = (Record)it.next();
                if (!(rec instanceof TextObjectRecord)) continue;
                txshapes.put(new Integer(cmo.getObjectId()), rec);
                continue block0;
            }
        }
        return comment2;
    }

    public HSSFHyperlink getHyperlink() {
        Iterator it = this.sheet.getSheet().getRecords().iterator();
        while (it.hasNext()) {
            HyperlinkRecord link2;
            RecordBase rec = (RecordBase)it.next();
            if (!(rec instanceof HyperlinkRecord) || (link2 = (HyperlinkRecord)rec).getFirstColumn() != this.record.getColumn() || link2.getFirstRow() != this.record.getRow()) continue;
            return new HSSFHyperlink(link2);
        }
        return null;
    }

    public void setHyperlink(HSSFHyperlink link2) {
        link2.setFirstRow(this.record.getRow());
        link2.setLastRow(this.record.getRow());
        link2.setFirstColumn(this.record.getColumn());
        link2.setLastColumn(this.record.getColumn());
        switch (link2.getType()) {
            case 1: 
            case 3: {
                link2.setLabel("url");
                break;
            }
            case 4: {
                link2.setLabel("file");
                break;
            }
            case 2: {
                link2.setLabel("place");
            }
        }
        int eofLoc = this.sheet.getSheet().findFirstRecordLocBySid((short)10);
        this.sheet.getSheet().getRecords().add(eofLoc, link2.record);
    }

    public int getCachedFormulaResultType() {
        if (this.cellType != 2) {
            throw new IllegalStateException("Only formula cells have cached results");
        }
        return ((FormulaRecordAggregate)this.record).getFormulaRecord().getCachedResultType();
    }
}

