/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayInitializer
extends Expression {
    public Expression[] expressions;
    public ArrayBinding binding;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.expressions != null) {
            int i2 = 0;
            int max = this.expressions.length;
            while (i2 < max) {
                flowInfo = this.expressions[i2].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                ++i2;
            }
        }
        return flowInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc;
        block13: {
            pc = codeStream.position;
            int expressionLength = this.expressions == null ? 0 : this.expressions.length;
            codeStream.generateInlinedValue(expressionLength);
            codeStream.newArray(this.binding);
            if (this.expressions == null) break block13;
            int elementsTypeID = this.binding.dimensions > 1 ? -1 : this.binding.leafComponentType.id;
            int i2 = 0;
            while (i2 < expressionLength) {
                block15: {
                    Expression expr;
                    block14: {
                        expr = this.expressions[i2];
                        if (expr.constant == NotAConstant) break block14;
                        switch (elementsTypeID) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 7: 
                            case 10: {
                                if (expr.constant.longValue() != 0L) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(i2);
                                    expr.generateCode(currentScope, codeStream, true);
                                    codeStream.arrayAtPut(elementsTypeID, false);
                                    break;
                                }
                                break block15;
                            }
                            case 8: 
                            case 9: {
                                double constantValue = expr.constant.doubleValue();
                                if (constantValue == -0.0 || constantValue != 0.0) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(i2);
                                    expr.generateCode(currentScope, codeStream, true);
                                    codeStream.arrayAtPut(elementsTypeID, false);
                                    break;
                                }
                                break block15;
                            }
                            case 5: {
                                if (expr.constant.booleanValue()) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(i2);
                                    expr.generateCode(currentScope, codeStream, true);
                                    codeStream.arrayAtPut(elementsTypeID, false);
                                    break;
                                }
                                break block15;
                            }
                            default: {
                                if (!(expr instanceof NullLiteral)) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(i2);
                                    expr.generateCode(currentScope, codeStream, true);
                                    codeStream.arrayAtPut(elementsTypeID, false);
                                    break;
                                }
                                break block15;
                            }
                        }
                        break block15;
                    }
                    if (!(expr instanceof NullLiteral)) {
                        codeStream.dup();
                        codeStream.generateInlinedValue(i2);
                        expr.generateCode(currentScope, codeStream, true);
                        codeStream.arrayAtPut(elementsTypeID, false);
                    }
                }
                ++i2;
            }
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('{');
        if (this.expressions != null) {
            int j = 20;
            int i2 = 0;
            while (i2 < this.expressions.length) {
                if (i2 > 0) {
                    output.append(", ");
                }
                this.expressions[i2].printExpression(0, output);
                if (--j == 0) {
                    output.append('\n');
                    ArrayInitializer.printIndent(indent + 1, output);
                    j = 20;
                }
                ++i2;
            }
        }
        return output.append('}');
    }

    public TypeBinding resolveTypeExpecting(BlockScope scope, TypeBinding expectedType) {
        TypeBinding leafComponentType;
        this.constant = NotAConstant;
        if ((this.bits & 1) == 0 && ((leafComponentType = expectedType.leafComponentType()).isBoundParameterizedType() || leafComponentType.isGenericType() || leafComponentType.isTypeVariable())) {
            scope.problemReporter().illegalGenericArray(leafComponentType, this);
        }
        if (expectedType.isArrayType()) {
            this.binding = (ArrayBinding)expectedType;
            this.resolvedType = this.binding;
            if (this.expressions == null) {
                return this.binding;
            }
            TypeBinding elementType = this.binding.elementsType();
            int i2 = 0;
            int length = this.expressions.length;
            while (i2 < length) {
                TypeBinding exprType;
                Expression expression = this.expressions[i2];
                TypeBinding typeBinding = exprType = expression instanceof ArrayInitializer ? expression.resolveTypeExpecting(scope, elementType) : expression.resolveType(scope);
                if (exprType == null) {
                    return null;
                }
                if (elementType != exprType) {
                    scope.compilationUnitScope().recordTypeConversion(elementType, exprType);
                }
                if (expression.isConstantValueOfTypeAssignableToType(exprType, elementType) || elementType.isBaseType() && BaseTypeBinding.isWidening(elementType.id, exprType.id) || exprType.isCompatibleWith(elementType)) {
                    expression.computeConversion(scope, elementType, exprType);
                } else if (scope.isBoxingCompatibleWith(exprType, elementType) || exprType.isBaseType() && scope.compilerOptions().sourceLevel >= 0x310000L && !elementType.isBaseType() && expression.isConstantValueOfTypeAssignableToType(exprType, scope.environment().computeBoxingType(elementType))) {
                    expression.computeConversion(scope, elementType, exprType);
                } else {
                    scope.problemReporter().typeMismatchError(exprType, elementType, expression);
                    return null;
                }
                ++i2;
            }
            return this.binding;
        }
        TypeBinding leafElementType = null;
        int dim = 1;
        if (this.expressions == null) {
            leafElementType = scope.getJavaLangObject();
        } else {
            Expression currentExpression = this.expressions[0];
            while (currentExpression != null && currentExpression instanceof ArrayInitializer) {
                ++dim;
                Expression[] subExprs = ((ArrayInitializer)currentExpression).expressions;
                if (subExprs == null) {
                    leafElementType = scope.getJavaLangObject();
                    currentExpression = null;
                    break;
                }
                currentExpression = ((ArrayInitializer)currentExpression).expressions[0];
            }
            if (currentExpression != null) {
                leafElementType = currentExpression.resolveType(scope);
            }
        }
        if (leafElementType != null) {
            ArrayBinding probableTb = scope.createArrayType(leafElementType, dim);
            scope.problemReporter().typeMismatchError(probableTb, expectedType, this);
        }
        return null;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.expressions != null) {
            int expressionsLength = this.expressions.length;
            int i2 = 0;
            while (i2 < expressionsLength) {
                this.expressions[i2].traverse(visitor, scope);
                ++i2;
            }
        }
        visitor.endVisit(this, scope);
    }
}

