/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class Javadoc
extends ASTNode {
    public JavadocSingleNameReference[] paramReferences;
    public JavadocSingleTypeReference[] paramTypeParameters;
    public TypeReference[] exceptionReferences;
    public JavadocReturnStatement returnStatement;
    public Expression[] seeReferences;
    public long inheritedPositions = -1L;
    public JavadocSingleNameReference[] invalidParameters;

    public Javadoc(int sourceStart, int sourceEnd) {
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        int length;
        int i2;
        Javadoc.printIndent(indent, output).append("/**\n");
        if (this.paramReferences != null) {
            i2 = 0;
            length = this.paramReferences.length;
            while (i2 < length) {
                Javadoc.printIndent(indent + 1, output).append(" * @param ");
                this.paramReferences[i2].print(indent, output).append('\n');
                ++i2;
            }
        }
        if (this.paramTypeParameters != null) {
            i2 = 0;
            length = this.paramTypeParameters.length;
            while (i2 < length) {
                Javadoc.printIndent(indent + 1, output).append(" * @param <");
                this.paramTypeParameters[i2].print(indent, output).append(">\n");
                ++i2;
            }
        }
        if (this.returnStatement != null) {
            Javadoc.printIndent(indent + 1, output).append(" * @");
            this.returnStatement.print(indent, output).append('\n');
        }
        if (this.exceptionReferences != null) {
            i2 = 0;
            length = this.exceptionReferences.length;
            while (i2 < length) {
                Javadoc.printIndent(indent + 1, output).append(" * @throws ");
                this.exceptionReferences[i2].print(indent, output).append('\n');
                ++i2;
            }
        }
        if (this.seeReferences != null) {
            i2 = 0;
            length = this.seeReferences.length;
            while (i2 < length) {
                Javadoc.printIndent(indent + 1, output).append(" * @see");
                this.seeReferences[i2].print(indent, output).append('\n');
                ++i2;
            }
        }
        Javadoc.printIndent(indent, output).append(" */\n");
        return output;
    }

    public void resolve(ClassScope scope) {
        int paramTagsSize = this.paramReferences == null ? 0 : this.paramReferences.length;
        int i2 = 0;
        while (i2 < paramTagsSize) {
            JavadocSingleNameReference param2 = this.paramReferences[i2];
            scope.problemReporter().javadocUnexpectedTag(param2.tagSourceStart, param2.tagSourceEnd);
            ++i2;
        }
        this.resolveTypeParameterTags(scope, true);
        if (this.returnStatement != null) {
            scope.problemReporter().javadocUnexpectedTag(this.returnStatement.sourceStart, this.returnStatement.sourceEnd);
        }
        int throwsTagsLength = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
        int i3 = 0;
        while (i3 < throwsTagsLength) {
            int end;
            int start;
            TypeReference typeRef = this.exceptionReferences[i3];
            if (typeRef instanceof JavadocSingleTypeReference) {
                JavadocSingleTypeReference singleRef = (JavadocSingleTypeReference)typeRef;
                start = singleRef.tagSourceStart;
                end = singleRef.tagSourceEnd;
            } else if (typeRef instanceof JavadocQualifiedTypeReference) {
                JavadocQualifiedTypeReference qualifiedRef = (JavadocQualifiedTypeReference)typeRef;
                start = qualifiedRef.tagSourceStart;
                end = qualifiedRef.tagSourceEnd;
            } else {
                start = typeRef.sourceStart;
                end = typeRef.sourceEnd;
            }
            scope.problemReporter().javadocUnexpectedTag(start, end);
            ++i3;
        }
        int seeTagsLength = this.seeReferences == null ? 0 : this.seeReferences.length;
        int i4 = 0;
        while (i4 < seeTagsLength) {
            this.resolveReference(this.seeReferences[i4], scope);
            ++i4;
        }
    }

    public void resolve(MethodScope methScope) {
        boolean reportMissing;
        AbstractMethodDeclaration methDecl = methScope.referenceMethod();
        boolean overriding = methDecl == null || methDecl.binding == null ? false : !methDecl.binding.isStatic() && (methDecl.binding.modifiers & 0x30000000) != 0;
        int seeTagsLength = this.seeReferences == null ? 0 : this.seeReferences.length;
        boolean superRef = false;
        int i2 = 0;
        while (i2 < seeTagsLength) {
            this.resolveReference(this.seeReferences[i2], methScope);
            try {
                if (methDecl != null && (methDecl.isConstructor() || overriding) && !superRef) {
                    if (this.seeReferences[i2] instanceof JavadocMessageSend) {
                        JavadocMessageSend messageSend = (JavadocMessageSend)this.seeReferences[i2];
                        if (messageSend.binding != null && messageSend.binding.isValidBinding() && methDecl.binding.declaringClass.isCompatibleWith(messageSend.actualReceiverType) && CharOperation.equals(messageSend.selector, methDecl.selector) && methDecl.binding.returnType.isCompatibleWith(messageSend.binding.returnType)) {
                            if (messageSend.arguments == null && methDecl.arguments == null) {
                                superRef = true;
                            } else if (messageSend.arguments != null && methDecl.arguments != null) {
                                superRef = methDecl.binding.areParametersCompatibleWith(messageSend.binding.parameters);
                            }
                        }
                    } else if (this.seeReferences[i2] instanceof JavadocAllocationExpression) {
                        JavadocAllocationExpression allocationExpr = (JavadocAllocationExpression)this.seeReferences[i2];
                        if (allocationExpr.binding != null && allocationExpr.binding.isValidBinding() && methDecl.binding.declaringClass.isCompatibleWith(allocationExpr.resolvedType)) {
                            if (allocationExpr.arguments == null && methDecl.arguments == null) {
                                superRef = true;
                            } else if (allocationExpr.arguments != null && methDecl.arguments != null) {
                                superRef = methDecl.binding.areParametersCompatibleWith(allocationExpr.binding.parameters);
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {}
            ++i2;
        }
        boolean bl = reportMissing = methDecl == null || (!overriding || this.inheritedPositions == -1L) && !superRef && (methDecl.binding.declaringClass == null || !methDecl.binding.declaringClass.isLocalType());
        if (!overriding && this.inheritedPositions != -1L) {
            int start = (int)(this.inheritedPositions >>> 32);
            int end = (int)this.inheritedPositions;
            methScope.problemReporter().javadocUnexpectedTag(start, end);
        }
        this.resolveParamTags(methScope, reportMissing);
        this.resolveTypeParameterTags(methScope, reportMissing);
        if (this.returnStatement == null) {
            if (reportMissing && methDecl != null && methDecl.isMethod()) {
                MethodDeclaration meth = (MethodDeclaration)methDecl;
                if (meth.binding.returnType != VoidBinding) {
                    methScope.problemReporter().javadocMissingReturnTag(meth.returnType.sourceStart, meth.returnType.sourceEnd, methDecl.binding.modifiers);
                }
            }
        } else {
            this.returnStatement.resolve(methScope);
        }
        this.resolveThrowsTags(methScope, reportMissing);
        int length = this.invalidParameters == null ? 0 : this.invalidParameters.length;
        int i3 = 0;
        while (i3 < length) {
            this.invalidParameters[i3].resolve(methScope, false);
            ++i3;
        }
    }

    private void resolveReference(Expression reference, Scope scope) {
        int modifiers;
        boolean verifyValues;
        switch (scope.kind) {
            case 2: {
                reference.resolveType((MethodScope)scope);
                break;
            }
            case 3: {
                reference.resolveType((ClassScope)scope);
            }
        }
        boolean bl = verifyValues = scope.compilerOptions().sourceLevel >= 0x310000L;
        if (reference instanceof JavadocFieldReference) {
            JavadocFieldReference fieldRef = (JavadocFieldReference)reference;
            int n = modifiers = fieldRef.binding == null ? -1 : fieldRef.binding.modifiers;
            if (fieldRef.methodBinding != null) {
                if (fieldRef.tagValue == 10) {
                    scope.problemReporter().javadocInvalidValueReference(fieldRef.sourceStart, fieldRef.sourceEnd, modifiers);
                } else if (fieldRef.receiverType != null) {
                    fieldRef.superAccess = scope.enclosingSourceType().isCompatibleWith(fieldRef.receiverType);
                    fieldRef.methodBinding = scope.findMethod((ReferenceBinding)fieldRef.receiverType, fieldRef.token, new TypeBinding[0], fieldRef);
                }
            } else if (verifyValues && fieldRef.binding != null && fieldRef.binding.isValidBinding() && fieldRef.tagValue == 10 && !fieldRef.binding.isStatic()) {
                scope.problemReporter().javadocInvalidValueReference(fieldRef.sourceStart, fieldRef.sourceEnd, modifiers);
            }
        }
        if (!verifyValues) {
            return;
        }
        if (reference instanceof JavadocMessageSend) {
            JavadocMessageSend msgSend = (JavadocMessageSend)reference;
            int n = modifiers = msgSend.binding == null ? -1 : msgSend.binding.modifiers;
            if (msgSend.tagValue == 10) {
                scope.problemReporter().javadocInvalidValueReference(msgSend.sourceStart, msgSend.sourceEnd, modifiers);
            }
        } else if (reference instanceof JavadocAllocationExpression) {
            JavadocAllocationExpression alloc = (JavadocAllocationExpression)reference;
            int n = modifiers = alloc.binding == null ? -1 : alloc.binding.modifiers;
            if (alloc.tagValue == 10) {
                scope.problemReporter().javadocInvalidValueReference(alloc.sourceStart, alloc.sourceEnd, modifiers);
            }
        }
        if (reference.resolvedType != null && reference.resolvedType.isTypeVariable()) {
            scope.problemReporter().javadocInvalidReference(reference.sourceStart, reference.sourceEnd);
        }
    }

    private void resolveParamTags(MethodScope methScope, boolean reportMissing) {
        block14: {
            int j;
            boolean found;
            int argumentsSize;
            int paramTagsSize;
            AbstractMethodDeclaration md;
            block13: {
                md = methScope.referenceMethod();
                int n = paramTagsSize = this.paramReferences == null ? 0 : this.paramReferences.length;
                if (md == null) {
                    int i2 = 0;
                    while (i2 < paramTagsSize) {
                        JavadocSingleNameReference param2 = this.paramReferences[i2];
                        methScope.problemReporter().javadocUnexpectedTag(param2.tagSourceStart, param2.tagSourceEnd);
                        ++i2;
                    }
                    return;
                }
                int n2 = argumentsSize = md.arguments == null ? 0 : md.arguments.length;
                if (paramTagsSize != 0) break block13;
                if (!reportMissing) break block14;
                int i3 = 0;
                while (i3 < argumentsSize) {
                    Argument arg = md.arguments[i3];
                    methScope.problemReporter().javadocMissingParamTag(arg.name, arg.sourceStart, arg.sourceEnd, md.binding.modifiers);
                    ++i3;
                }
                break block14;
            }
            LocalVariableBinding[] bindings = new LocalVariableBinding[paramTagsSize];
            int maxBindings = 0;
            int i4 = 0;
            while (i4 < paramTagsSize) {
                JavadocSingleNameReference param3 = this.paramReferences[i4];
                param3.resolve(methScope);
                if (param3.binding != null && param3.binding.isValidBinding()) {
                    found = false;
                    j = 0;
                    while (j < maxBindings && !found) {
                        if (bindings[j] == param3.binding) {
                            methScope.problemReporter().javadocDuplicatedParamTag(param3.token, param3.sourceStart, param3.sourceEnd, md.binding.modifiers);
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        bindings[maxBindings++] = (LocalVariableBinding)param3.binding;
                    }
                }
                ++i4;
            }
            if (reportMissing) {
                i4 = 0;
                while (i4 < argumentsSize) {
                    Argument arg = md.arguments[i4];
                    found = false;
                    j = 0;
                    while (j < maxBindings && !found) {
                        LocalVariableBinding binding = bindings[j];
                        if (arg.binding == binding) {
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        methScope.problemReporter().javadocMissingParamTag(arg.name, arg.sourceStart, arg.sourceEnd, md.binding.modifiers);
                    }
                    ++i4;
                }
            }
        }
    }

    private void resolveTypeParameterTags(Scope scope, boolean reportMissing) {
        block24: {
            int typeParametersLength;
            TypeParameter[] parameters;
            int modifiers;
            TypeVariableBinding[] typeVariables;
            int paramTypeParamLength;
            block23: {
                paramTypeParamLength = this.paramTypeParameters == null ? 0 : this.paramTypeParameters.length;
                TypeDeclaration typeDeclaration = null;
                AbstractMethodDeclaration methodDeclaration = null;
                typeVariables = null;
                modifiers = -1;
                switch (scope.kind) {
                    case 2: {
                        methodDeclaration = ((MethodScope)scope).referenceMethod();
                        if (methodDeclaration == null) {
                            int i2 = 0;
                            while (i2 < paramTypeParamLength) {
                                JavadocSingleNameReference param2 = this.paramReferences[i2];
                                scope.problemReporter().javadocUnexpectedTag(param2.tagSourceStart, param2.tagSourceEnd);
                                ++i2;
                            }
                            return;
                        }
                        typeVariables = methodDeclaration.binding.typeVariables;
                        modifiers = methodDeclaration.binding.modifiers;
                        break;
                    }
                    case 3: {
                        typeDeclaration = ((ClassScope)scope).referenceContext;
                        typeVariables = typeDeclaration.binding.typeVariables;
                        modifiers = typeDeclaration.binding.modifiers;
                    }
                }
                if (typeVariables == null || typeVariables.length == 0) {
                    int i3 = 0;
                    while (i3 < paramTypeParamLength) {
                        JavadocSingleTypeReference param3 = this.paramTypeParameters[i3];
                        scope.problemReporter().javadocUnexpectedTag(param3.tagSourceStart, param3.tagSourceEnd);
                        ++i3;
                    }
                    return;
                }
                parameters = typeDeclaration == null ? methodDeclaration.typeParameters() : typeDeclaration.typeParameters;
                int n = typeParametersLength = parameters == null ? 0 : parameters.length;
                if (paramTypeParamLength != 0) break block23;
                if (!reportMissing) break block24;
                int i4 = 0;
                int l = parameters.length;
                while (i4 < l) {
                    scope.problemReporter().javadocMissingParamTag(parameters[i4].name, parameters[i4].sourceStart, parameters[i4].sourceEnd, modifiers);
                    ++i4;
                }
                break block24;
            }
            if (typeVariables.length == typeParametersLength) {
                JavadocSingleTypeReference param4;
                TypeVariableBinding[] bindings = new TypeVariableBinding[paramTypeParamLength];
                int i5 = 0;
                while (i5 < paramTypeParamLength) {
                    param4 = this.paramTypeParameters[i5];
                    TypeBinding paramBindind = param4.internalResolveType(scope);
                    if (paramBindind != null && paramBindind.isValidBinding()) {
                        if (paramBindind.isTypeVariable()) {
                            boolean duplicate = false;
                            int j = 0;
                            while (j < i5 && !duplicate) {
                                if (bindings[j] == param4.resolvedType) {
                                    scope.problemReporter().javadocDuplicatedParamTag(param4.token, param4.sourceStart, param4.sourceEnd, modifiers);
                                    duplicate = true;
                                }
                                ++j;
                            }
                            if (!duplicate) {
                                bindings[i5] = (TypeVariableBinding)param4.resolvedType;
                            }
                        } else {
                            scope.problemReporter().javadocUndeclaredParamTagName(param4.token, param4.sourceStart, param4.sourceEnd, modifiers);
                        }
                    }
                    ++i5;
                }
                i5 = 0;
                while (i5 < typeParametersLength) {
                    TypeParameter parameter = parameters[i5];
                    boolean found = false;
                    int j = 0;
                    while (j < paramTypeParamLength && !found) {
                        if (parameter.binding == bindings[j]) {
                            found = true;
                            bindings[j] = null;
                        }
                        ++j;
                    }
                    if (!found && reportMissing) {
                        scope.problemReporter().javadocMissingParamTag(parameter.name, parameter.sourceStart, parameter.sourceEnd, modifiers);
                    }
                    ++i5;
                }
                i5 = 0;
                while (i5 < paramTypeParamLength) {
                    if (bindings[i5] != null) {
                        param4 = this.paramTypeParameters[i5];
                        scope.problemReporter().javadocUndeclaredParamTagName(param4.token, param4.sourceStart, param4.sourceEnd, modifiers);
                    }
                    ++i5;
                }
            }
        }
    }

    private void resolveThrowsTags(MethodScope methScope, boolean reportMissing) {
        block23: {
            int j;
            TypeReference typeRef;
            int thrownExceptionLength;
            int boundExceptionLength;
            int throwsTagsLength;
            AbstractMethodDeclaration md;
            block22: {
                md = methScope.referenceMethod();
                int n = throwsTagsLength = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
                if (md == null) {
                    int i2 = 0;
                    while (i2 < throwsTagsLength) {
                        TypeReference typeRef2 = this.exceptionReferences[i2];
                        int start = typeRef2.sourceStart;
                        int end = typeRef2.sourceEnd;
                        if (typeRef2 instanceof JavadocQualifiedTypeReference) {
                            start = ((JavadocQualifiedTypeReference)typeRef2).tagSourceStart;
                            end = ((JavadocQualifiedTypeReference)typeRef2).tagSourceEnd;
                        } else if (typeRef2 instanceof JavadocSingleTypeReference) {
                            start = ((JavadocSingleTypeReference)typeRef2).tagSourceStart;
                            end = ((JavadocSingleTypeReference)typeRef2).tagSourceEnd;
                        }
                        methScope.problemReporter().javadocUnexpectedTag(start, end);
                        ++i2;
                    }
                    return;
                }
                boundExceptionLength = md.binding == null || md.binding.thrownExceptions == null ? 0 : md.binding.thrownExceptions.length;
                int n2 = thrownExceptionLength = md.thrownExceptions == null ? 0 : md.thrownExceptions.length;
                if (throwsTagsLength != 0) break block22;
                if (!reportMissing) break block23;
                int i3 = 0;
                while (i3 < boundExceptionLength) {
                    ReferenceBinding exceptionBinding = md.binding.thrownExceptions[i3];
                    if (exceptionBinding != null && exceptionBinding.isValidBinding()) {
                        int j2 = i3;
                        while (j2 < thrownExceptionLength && exceptionBinding != md.thrownExceptions[j2].resolvedType) {
                            ++j2;
                        }
                        if (j2 < thrownExceptionLength) {
                            methScope.problemReporter().javadocMissingThrowsTag(md.thrownExceptions[j2], md.binding.modifiers);
                        }
                    }
                    ++i3;
                }
                break block23;
            }
            int maxRef = 0;
            TypeReference[] typeReferences = new TypeReference[throwsTagsLength];
            int i4 = 0;
            while (i4 < throwsTagsLength) {
                typeRef = this.exceptionReferences[i4];
                typeRef.resolve(methScope);
                TypeBinding typeBinding = typeRef.resolvedType;
                if (typeBinding != null && typeBinding.isValidBinding() && typeBinding.isClass()) {
                    typeReferences[maxRef++] = typeRef;
                }
                ++i4;
            }
            i4 = 0;
            while (i4 < boundExceptionLength) {
                ReferenceBinding exceptionBinding = md.binding.thrownExceptions[i4];
                boolean found = false;
                j = 0;
                while (j < maxRef && !found) {
                    TypeBinding typeBinding;
                    if (typeReferences[j] != null && exceptionBinding == (typeBinding = typeReferences[j].resolvedType)) {
                        found = true;
                        typeReferences[j] = null;
                    }
                    ++j;
                }
                if (!found && reportMissing && exceptionBinding != null && exceptionBinding.isValidBinding()) {
                    int k = i4;
                    while (k < thrownExceptionLength && exceptionBinding != md.thrownExceptions[k].resolvedType) {
                        ++k;
                    }
                    if (k < thrownExceptionLength) {
                        methScope.problemReporter().javadocMissingThrowsTag(md.thrownExceptions[k], md.binding.modifiers);
                    }
                }
                ++i4;
            }
            i4 = 0;
            while (i4 < maxRef) {
                typeRef = typeReferences[i4];
                if (typeRef != null) {
                    boolean compatible = false;
                    j = 0;
                    while (j < thrownExceptionLength && !compatible) {
                        TypeBinding exceptionBinding = md.thrownExceptions[j].resolvedType;
                        if (exceptionBinding != null) {
                            compatible = typeRef.resolvedType.isCompatibleWith(exceptionBinding);
                        }
                        ++j;
                    }
                    if (!compatible && !typeRef.resolvedType.isUncheckedException(false)) {
                        methScope.problemReporter().javadocInvalidThrowsClassName(typeRef, md.binding.modifiers);
                    }
                }
                ++i4;
            }
        }
    }

    public ASTNode getNodeStartingAt(int start) {
        Expression param2;
        int i2;
        int length = 0;
        if (this.paramReferences != null) {
            length = this.paramReferences.length;
            i2 = 0;
            while (i2 < length) {
                param2 = this.paramReferences[i2];
                if (param2.sourceStart == start) {
                    return param2;
                }
                ++i2;
            }
        }
        if (this.invalidParameters != null) {
            length = this.invalidParameters.length;
            i2 = 0;
            while (i2 < length) {
                param2 = this.invalidParameters[i2];
                if (param2.sourceStart == start) {
                    return param2;
                }
                ++i2;
            }
        }
        if (this.paramTypeParameters != null) {
            length = this.paramTypeParameters.length;
            i2 = 0;
            while (i2 < length) {
                param2 = this.paramTypeParameters[i2];
                if (((JavadocSingleTypeReference)param2).sourceStart == start) {
                    return param2;
                }
                ++i2;
            }
        }
        if (this.exceptionReferences != null) {
            length = this.exceptionReferences.length;
            i2 = 0;
            while (i2 < length) {
                TypeReference typeRef = this.exceptionReferences[i2];
                if (typeRef.sourceStart == start) {
                    return typeRef;
                }
                ++i2;
            }
        }
        if (this.seeReferences != null) {
            length = this.seeReferences.length;
            i2 = 0;
            while (i2 < length) {
                int l;
                int j;
                Expression expression = this.seeReferences[i2];
                if (expression.sourceStart == start) {
                    return expression;
                }
                if (expression instanceof JavadocAllocationExpression) {
                    JavadocAllocationExpression allocationExpr = (JavadocAllocationExpression)this.seeReferences[i2];
                    if (allocationExpr.binding != null && allocationExpr.binding.isValidBinding() && allocationExpr.arguments != null) {
                        j = 0;
                        l = allocationExpr.arguments.length;
                        while (j < l) {
                            if (allocationExpr.arguments[j].sourceStart == start) {
                                return allocationExpr.arguments[j];
                            }
                            ++j;
                        }
                    }
                } else if (expression instanceof JavadocMessageSend) {
                    JavadocMessageSend messageSend = (JavadocMessageSend)this.seeReferences[i2];
                    if (messageSend.binding != null && messageSend.binding.isValidBinding() && messageSend.arguments != null) {
                        j = 0;
                        l = messageSend.arguments.length;
                        while (j < l) {
                            if (messageSend.arguments[j].sourceStart == start) {
                                return messageSend.arguments[j];
                            }
                            ++j;
                        }
                    }
                }
                ++i2;
            }
        }
        return null;
    }
}

