/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;

public class NormalAnnotation
extends Annotation {
    public MemberValuePair[] memberValuePairs;

    public NormalAnnotation(TypeReference type, int sourceStart) {
        this.type = type;
        this.sourceStart = sourceStart;
        this.sourceEnd = type.sourceEnd;
    }

    public MemberValuePair[] memberValuePairs() {
        return this.memberValuePairs == null ? NoValuePairs : this.memberValuePairs;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        super.printExpression(indent, output);
        output.append('(');
        if (this.memberValuePairs != null) {
            int i2 = 0;
            int max = this.memberValuePairs.length;
            while (i2 < max) {
                if (i2 > 0) {
                    output.append(',');
                }
                this.memberValuePairs[i2].print(indent, output);
                ++i2;
            }
        }
        output.append(')');
        return output;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.memberValuePairs != null) {
            int memberValuePairsLength = this.memberValuePairs.length;
            int i2 = 0;
            while (i2 < memberValuePairsLength) {
                this.memberValuePairs[i2].traverse(visitor, scope);
                ++i2;
            }
        }
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope scope) {
        if (visitor.visit(this, scope) && this.memberValuePairs != null) {
            int memberValuePairsLength = this.memberValuePairs.length;
            int i2 = 0;
            while (i2 < memberValuePairsLength) {
                this.memberValuePairs[i2].traverse(visitor, scope);
                ++i2;
            }
        }
        visitor.endVisit(this, scope);
    }
}

