/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import org.eclipse.jdt.core.compiler.CharOperation;

public class CharArrayCache {
    public char[][] keyTable;
    public int[] valueTable;
    int elementSize = 0;
    int threshold;

    public CharArrayCache() {
        this(13);
    }

    public CharArrayCache(int initialCapacity) {
        this.threshold = (int)((float)initialCapacity * 0.66f);
        this.keyTable = new char[initialCapacity][];
        this.valueTable = new int[initialCapacity];
    }

    public void clear() {
        int i2 = this.keyTable.length;
        while (--i2 >= 0) {
            this.keyTable[i2] = null;
            this.valueTable[i2] = 0;
        }
        this.elementSize = 0;
    }

    public boolean containsKey(char[] key) {
        int index = this.hashCodeChar(key);
        while (this.keyTable[index] != null) {
            if (CharOperation.equals(this.keyTable[index], key)) {
                return true;
            }
            index = (index + 1) % this.keyTable.length;
        }
        return false;
    }

    public int get(char[] key) {
        int index = this.hashCodeChar(key);
        while (this.keyTable[index] != null) {
            if (CharOperation.equals(this.keyTable[index], key)) {
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        return -1;
    }

    private int hashCodeChar(char[] val) {
        int length = val.length;
        int hash = 0;
        int n = 2;
        int i2 = 0;
        while (i2 < length) {
            hash += val[i2];
            i2 += n;
        }
        return (hash & Integer.MAX_VALUE) % this.keyTable.length;
    }

    public int put(char[] key, int value) {
        int index = this.hashCodeChar(key);
        while (this.keyTable[index] != null) {
            if (CharOperation.equals(this.keyTable[index], key)) {
                this.valueTable[index] = value;
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return value;
    }

    private void rehash() {
        CharArrayCache newHashtable = new CharArrayCache(this.keyTable.length * 2);
        int i2 = this.keyTable.length;
        while (--i2 >= 0) {
            if (this.keyTable[i2] == null) continue;
            newHashtable.put(this.keyTable[i2], this.valueTable[i2]);
        }
        this.keyTable = newHashtable.keyTable;
        this.valueTable = newHashtable.valueTable;
        this.threshold = newHashtable.threshold;
    }

    public void remove(char[] key) {
        int index = this.hashCodeChar(key);
        while (this.keyTable[index] != null) {
            if (CharOperation.equals(this.keyTable[index], key)) {
                this.valueTable[index] = 0;
                this.keyTable[index] = null;
                return;
            }
            index = (index + 1) % this.keyTable.length;
        }
    }

    public char[] returnKeyFor(int value) {
        int i2 = this.keyTable.length;
        while (i2-- > 0) {
            if (this.valueTable[i2] != value) continue;
            return this.keyTable[i2];
        }
        return null;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        int max = this.size();
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        int i2 = 0;
        while (i2 < max) {
            if (this.keyTable[i2] != null) {
                buf.append(this.keyTable[i2]).append("->").append(this.valueTable[i2]);
            }
            if (i2 < max) {
                buf.append(", ");
            }
            ++i2;
        }
        buf.append("}");
        return buf.toString();
    }
}

