/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class RawTypeBinding
extends ParameterizedTypeBinding {
    public RawTypeBinding(ReferenceBinding type, ReferenceBinding enclosingType, LookupEnvironment environment) {
        super(type, null, enclosingType, environment);
        if (enclosingType == null || (enclosingType.modifiers & 0x40000000) == 0) {
            this.modifiers &= 0xBFFFFFFF;
        }
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        StringBuffer sig = new StringBuffer(10);
        if (this.isMemberType() && this.enclosingType().isParameterizedType()) {
            char[] typeSig = this.enclosingType().computeUniqueKey(false);
            int i2 = 0;
            while (i2 < typeSig.length - 1) {
                sig.append(typeSig[i2]);
                ++i2;
            }
            sig.append('.').append(this.sourceName()).append('<').append('>').append(';');
        } else {
            sig.append(this.type.computeUniqueKey(false));
            sig.insert(sig.length() - 1, "<>");
        }
        int sigLength = sig.length();
        char[] uniqueKey = new char[sigLength];
        sig.getChars(0, sigLength, uniqueKey, 0);
        return uniqueKey;
    }

    public ParameterizedMethodBinding createParameterizedMethod(MethodBinding originalMethod) {
        if (originalMethod.typeVariables == NoTypeVariables || originalMethod.isStatic()) {
            return super.createParameterizedMethod(originalMethod);
        }
        return new ParameterizedGenericMethodBinding(originalMethod, this, this.environment);
    }

    public int kind() {
        return 1028;
    }

    public String debugName() {
        StringBuffer nameBuffer = new StringBuffer(10);
        nameBuffer.append(this.type.sourceName()).append("#RAW");
        return nameBuffer.toString();
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            StringBuffer sig = new StringBuffer(10);
            if (this.isMemberType() && this.enclosingType().isParameterizedType()) {
                char[] typeSig = this.enclosingType().genericTypeSignature();
                int i2 = 0;
                while (i2 < typeSig.length - 1) {
                    sig.append(typeSig[i2]);
                    ++i2;
                }
                sig.append('.').append(this.sourceName()).append(';');
                int sigLength = sig.length();
                this.genericTypeSignature = new char[sigLength];
                sig.getChars(0, sigLength, this.genericTypeSignature, 0);
            } else {
                this.genericTypeSignature = this.type.signature();
            }
        }
        return this.genericTypeSignature;
    }

    public boolean isEquivalentTo(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        switch (otherType.kind()) {
            case 516: {
                return ((WildcardBinding)otherType).boundCheck(this);
            }
            case 260: 
            case 1028: 
            case 2052: {
                return this.erasure() == otherType.erasure();
            }
        }
        return false;
    }

    public boolean isIntersectingWith(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        switch (otherType.kind()) {
            case 260: 
            case 1028: 
            case 2052: {
                return this.erasure() == otherType.erasure();
            }
        }
        return false;
    }

    public boolean isParameterizedType() {
        return false;
    }

    public boolean isRawType() {
        return true;
    }

    protected void initializeArguments() {
        TypeVariableBinding[] typeVariables = this.type.typeVariables();
        int length = typeVariables.length;
        TypeBinding[] typeArguments = new TypeBinding[length];
        int i2 = 0;
        while (i2 < length) {
            typeArguments[i2] = this.environment.convertToRawType(typeVariables[i2].erasure());
            ++i2;
        }
        this.arguments = typeArguments;
    }

    public char[] readableName() {
        char[] readableName = this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.') : CharOperation.concatWith(this.type.compoundName, '.');
        return readableName;
    }

    public char[] shortReadableName() {
        char[] shortReadableName = this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.') : this.type.sourceName;
        return shortReadableName;
    }
}

