/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.Util;

public class DefaultProblem
implements ProblemSeverities,
IProblem {
    private char[] fileName;
    private int id;
    private int startPosition;
    private int endPosition;
    private int line;
    private int severity;
    private String[] arguments;
    private String message;

    public DefaultProblem(char[] originatingFileName, String message, int id, String[] stringArguments, int severity, int startPosition, int endPosition, int line) {
        this.fileName = originatingFileName;
        this.message = message;
        this.id = id;
        this.arguments = stringArguments;
        this.severity = severity;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.line = line;
    }

    public String errorReportSource(char[] unitSource) {
        char c2;
        if (this.startPosition > this.endPosition || this.startPosition < 0 && this.endPosition < 0) {
            return Messages.problem_noSourceInformation;
        }
        StringBuffer errorBuffer = new StringBuffer(" ");
        errorBuffer.append(Messages.bind(Messages.problem_atLine, String.valueOf(this.line)));
        errorBuffer.append(Util.LINE_SEPARATOR).append("\t");
        int length = unitSource.length;
        int begin = this.startPosition >= length ? length - 1 : this.startPosition;
        while (begin > 0) {
            c2 = unitSource[begin - 1];
            if (c2 == '\n' || c2 == '\r') break;
            --begin;
        }
        int end = this.endPosition >= length ? length - 1 : this.endPosition;
        while (end + 1 < length) {
            c2 = unitSource[end + 1];
            if (c2 == '\r' || c2 == '\n') break;
            ++end;
        }
        while ((c2 = unitSource[begin]) == ' ' || c2 == '\t') {
            ++begin;
        }
        errorBuffer.append(unitSource, begin, end - begin + 1);
        errorBuffer.append(Util.LINE_SEPARATOR).append("\t");
        int i2 = begin;
        while (i2 < this.startPosition) {
            errorBuffer.append(unitSource[i2] == '\t' ? (char)'\t' : ' ');
            ++i2;
        }
        i2 = this.startPosition;
        while (i2 <= (this.endPosition >= length ? length - 1 : this.endPosition)) {
            errorBuffer.append('^');
            ++i2;
        }
        return errorBuffer.toString();
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public int getID() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public char[] getOriginatingFileName() {
        return this.fileName;
    }

    public int getSourceEnd() {
        return this.endPosition;
    }

    public int getSourceLineNumber() {
        return this.line;
    }

    public int getSourceStart() {
        return this.startPosition;
    }

    public boolean isError() {
        return (this.severity & 1) != 0;
    }

    public boolean isWarning() {
        return (this.severity & 1) == 0;
    }

    public void setOriginatingFileName(char[] fileName) {
        this.fileName = fileName;
    }

    public void setSourceEnd(int sourceEnd) {
        this.endPosition = sourceEnd;
    }

    public void setSourceLineNumber(int lineNumber) {
        this.line = lineNumber;
    }

    public void setSourceStart(int sourceStart) {
        this.startPosition = sourceStart;
    }

    public String toString() {
        String s2 = "Pb(" + (this.id & 0xFFFFFF) + ") ";
        if (this.message != null) {
            s2 = String.valueOf(s2) + this.message;
        } else if (this.arguments != null) {
            int i2 = 0;
            while (i2 < this.arguments.length) {
                s2 = String.valueOf(s2) + " " + this.arguments[i2];
                ++i2;
            }
        }
        return s2;
    }
}

