/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.Range;
import org.jfree.text.TextUtilities;
import org.jfree.ui.Size2D;
import org.jfree.ui.TextAnchor;

public class ShortTextTitle
extends TextTitle {
    public ShortTextTitle(String text) {
        this.setText(text);
    }

    public Size2D arrange(Graphics2D g2, RectangleConstraint constraint) {
        RectangleConstraint cc = this.toContentConstraint(constraint);
        LengthConstraintType w = cc.getWidthConstraintType();
        LengthConstraintType h7 = cc.getHeightConstraintType();
        Size2D contentSize = null;
        if (w == LengthConstraintType.NONE) {
            if (h7 == LengthConstraintType.NONE) {
                contentSize = this.arrangeNN(g2);
            } else {
                if (h7 == LengthConstraintType.RANGE) {
                    throw new RuntimeException("Not yet implemented.");
                }
                if (h7 == LengthConstraintType.FIXED) {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        } else if (w == LengthConstraintType.RANGE) {
            if (h7 == LengthConstraintType.NONE) {
                contentSize = this.arrangeRN(g2, cc.getWidthRange());
            } else if (h7 == LengthConstraintType.RANGE) {
                contentSize = this.arrangeRR(g2, cc.getWidthRange(), cc.getHeightRange());
            } else if (h7 == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not yet implemented.");
            }
        } else if (w == LengthConstraintType.FIXED) {
            if (h7 == LengthConstraintType.NONE) {
                contentSize = this.arrangeFN(g2, cc.getWidth());
            } else {
                if (h7 == LengthConstraintType.RANGE) {
                    throw new RuntimeException("Not yet implemented.");
                }
                if (h7 == LengthConstraintType.FIXED) {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        }
        if (contentSize.width <= 0.0 || contentSize.height <= 0.0) {
            return new Size2D(0.0, 0.0);
        }
        return new Size2D(this.calculateTotalWidth(contentSize.getWidth()), this.calculateTotalHeight(contentSize.getHeight()));
    }

    protected Size2D arrangeNN(Graphics2D g2) {
        Range max = new Range(0.0, 3.4028234663852886E38);
        return this.arrangeRR(g2, max, max);
    }

    protected Size2D arrangeRN(Graphics2D g2, Range widthRange) {
        Size2D s2 = this.arrangeNN(g2);
        if (widthRange.contains(s2.getWidth())) {
            return s2;
        }
        double ww = widthRange.constrain(s2.getWidth());
        return this.arrangeFN(g2, ww);
    }

    protected Size2D arrangeFN(Graphics2D g2, double w) {
        g2.setFont(this.getFont());
        FontMetrics fm = g2.getFontMetrics(this.getFont());
        Rectangle2D bounds = TextUtilities.getTextBounds(this.getText(), g2, fm);
        if (bounds.getWidth() <= w) {
            return new Size2D(w, bounds.getHeight());
        }
        return new Size2D(0.0, 0.0);
    }

    protected Size2D arrangeRR(Graphics2D g2, Range widthRange, Range heightRange) {
        g2.setFont(this.getFont());
        FontMetrics fm = g2.getFontMetrics(this.getFont());
        Rectangle2D bounds = TextUtilities.getTextBounds(this.getText(), g2, fm);
        if (bounds.getWidth() <= widthRange.getUpperBound() && bounds.getHeight() <= heightRange.getUpperBound()) {
            return new Size2D(bounds.getWidth(), bounds.getHeight());
        }
        return new Size2D(0.0, 0.0);
    }

    public Object draw(Graphics2D g2, Rectangle2D area2, Object params) {
        if (area2.isEmpty()) {
            return null;
        }
        area2 = this.trimMargin(area2);
        this.drawBorder(g2, area2);
        area2 = this.trimBorder(area2);
        area2 = this.trimPadding(area2);
        g2.setFont(this.getFont());
        g2.setPaint(this.getPaint());
        TextUtilities.drawAlignedString(this.getText(), g2, (float)area2.getMinX(), (float)area2.getMinY(), TextAnchor.TOP_LEFT);
        return null;
    }
}

