/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ProxyInputStream;

public class CountingInputStream
extends ProxyInputStream {
    private int count;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    public int read(byte[] b) throws IOException {
        int found = super.read(b);
        this.count += found;
        return found;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int found = super.read(b, off, len);
        this.count += found;
        return found;
    }

    public int read() throws IOException {
        ++this.count;
        return super.read();
    }

    public int getCount() {
        return this.count;
    }
}

