/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

import com.d_project.qrcode.BitBuffer;
import com.d_project.qrcode.GIFImage;
import com.d_project.qrcode.Polynomial;
import com.d_project.qrcode.QR8BitByte;
import com.d_project.qrcode.QRAlphaNum;
import com.d_project.qrcode.QRData;
import com.d_project.qrcode.QRKanji;
import com.d_project.qrcode.QRNumber;
import com.d_project.qrcode.QRUtil;
import com.d_project.qrcode.RSBlock;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class QRCode {
    private static final int PAD0 = 236;
    private static final int PAD1 = 17;
    private int typeNumber = 1;
    private Boolean[][] modules;
    private int moduleCount;
    private int errorCorrectLevel = 2;
    private List qrDataList = new ArrayList(1);

    public int getTypeNumber() {
        return this.typeNumber;
    }

    public void setTypeNumber(int typeNumber) {
        this.typeNumber = typeNumber;
    }

    public int getErrorCorrectLevel() {
        return this.errorCorrectLevel;
    }

    public void setErrorCorrectLevel(int errorCorrectLevel) {
        this.errorCorrectLevel = errorCorrectLevel;
    }

    public void addData(String data) {
        this.addData(data, QRUtil.getMode(data));
    }

    public void addData(String data, int mode) {
        switch (mode) {
            case 1: {
                this.addData(new QRNumber(data));
                break;
            }
            case 2: {
                this.addData(new QRAlphaNum(data));
                break;
            }
            case 4: {
                this.addData(new QR8BitByte(data));
                break;
            }
            case 8: {
                this.addData(new QRKanji(data));
                break;
            }
            default: {
                throw new IllegalArgumentException("mode:" + mode);
            }
        }
    }

    public void clearData() {
        this.qrDataList.clear();
    }

    private void addData(QRData qrData) {
        this.qrDataList.add(qrData);
    }

    private int getDataCount() {
        return this.qrDataList.size();
    }

    private QRData getData(int index) {
        return (QRData)this.qrDataList.get(index);
    }

    public boolean isDark(int row, int col) {
        if (this.modules[row][col] != null) {
            return this.modules[row][col];
        }
        return false;
    }

    public int getModuleCount() {
        return this.moduleCount;
    }

    public void make() {
        this.make(false, this.getBestMaskPattern());
    }

    private int getBestMaskPattern() {
        int minLostPoint = 0;
        int pattern = 0;
        for (int i = 0; i < 8; ++i) {
            this.make(true, i);
            int lostPoint = QRUtil.getLostPoint(this);
            if (i != 0 && minLostPoint <= lostPoint) continue;
            minLostPoint = lostPoint;
            pattern = i;
        }
        return pattern;
    }

    private void make(boolean test, int maskPattern) {
        this.moduleCount = this.typeNumber * 4 + 17;
        this.modules = new Boolean[this.moduleCount][this.moduleCount];
        this.setupPositionProbePattern(0, 0);
        this.setupPositionProbePattern(this.moduleCount - 7, 0);
        this.setupPositionProbePattern(0, this.moduleCount - 7);
        this.setupPositionAdjustPattern();
        this.setupTimingPattern();
        this.setupTypeInfo(test, maskPattern);
        if (this.typeNumber >= 7) {
            this.setupTypeNumber(test);
        }
        QRData[] dataArray = this.qrDataList.toArray(new QRData[this.qrDataList.size()]);
        byte[] data = QRCode.createData(this.typeNumber, this.errorCorrectLevel, dataArray);
        this.mapData(data, maskPattern);
    }

    private void mapData(byte[] data, int maskPattern) {
        int inc = -1;
        int row = this.moduleCount - 1;
        int bitIndex = 7;
        int byteIndex = 0;
        for (int col = this.moduleCount - 1; col > 0; col -= 2) {
            if (col == 6) {
                --col;
            }
            do {
                for (int c = 0; c < 2; ++c) {
                    boolean mask;
                    if (this.modules[row][col - c] != null) continue;
                    boolean dark = false;
                    if (byteIndex < data.length) {
                        boolean bl = dark = (data[byteIndex] >>> bitIndex & 1) == 1;
                    }
                    if (mask = QRUtil.getMask(maskPattern, row, col - c)) {
                        dark = !dark;
                    }
                    this.modules[row][col - c] = new Boolean(dark);
                    if (--bitIndex != -1) continue;
                    ++byteIndex;
                    bitIndex = 7;
                }
            } while ((row += inc) >= 0 && this.moduleCount > row);
            row -= inc;
            inc = -inc;
        }
    }

    private void setupPositionAdjustPattern() {
        int[] pos = QRUtil.getPatternPosition(this.typeNumber);
        for (int i = 0; i < pos.length; ++i) {
            for (int j = 0; j < pos.length; ++j) {
                int row = pos[i];
                int col = pos[j];
                if (this.modules[row][col] != null) continue;
                for (int r = -2; r <= 2; ++r) {
                    for (int c = -2; c <= 2; ++c) {
                        this.modules[row + r][col + c] = r == -2 || r == 2 || c == -2 || c == 2 || r == 0 && c == 0 ? new Boolean(true) : new Boolean(false);
                    }
                }
            }
        }
    }

    private void setupPositionProbePattern(int row, int col) {
        for (int r = -1; r <= 7; ++r) {
            for (int c = -1; c <= 7; ++c) {
                if (row + r <= -1 || this.moduleCount <= row + r || col + c <= -1 || this.moduleCount <= col + c) continue;
                this.modules[row + r][col + c] = 0 <= r && r <= 6 && (c == 0 || c == 6) || 0 <= c && c <= 6 && (r == 0 || r == 6) || 2 <= r && r <= 4 && 2 <= c && c <= 4 ? new Boolean(true) : new Boolean(false);
            }
        }
    }

    private void setupTimingPattern() {
        for (int r = 8; r < this.moduleCount - 8; ++r) {
            if (this.modules[r][6] != null) continue;
            this.modules[r][6] = new Boolean(r % 2 == 0);
        }
        for (int c = 8; c < this.moduleCount - 8; ++c) {
            if (this.modules[6][c] != null) continue;
            this.modules[6][c] = new Boolean(c % 2 == 0);
        }
    }

    private void setupTypeNumber(boolean test) {
        Boolean mod;
        int i;
        int bits = QRUtil.getBCHTypeNumber(this.typeNumber);
        for (i = 0; i < 18; ++i) {
            this.modules[i / 3][i % 3 + this.moduleCount - 8 - 3] = mod = new Boolean(!test && (bits >> i & 1) == 1);
        }
        for (i = 0; i < 18; ++i) {
            this.modules[i % 3 + this.moduleCount - 8 - 3][i / 3] = mod = new Boolean(!test && (bits >> i & 1) == 1);
        }
    }

    private void setupTypeInfo(boolean test, int maskPattern) {
        Boolean mod;
        int i;
        int data = this.errorCorrectLevel << 3 | maskPattern;
        int bits = QRUtil.getBCHTypeInfo(data);
        for (i = 0; i < 15; ++i) {
            mod = new Boolean(!test && (bits >> i & 1) == 1);
            if (i < 6) {
                this.modules[i][8] = mod;
                continue;
            }
            if (i < 8) {
                this.modules[i + 1][8] = mod;
                continue;
            }
            this.modules[this.moduleCount - 15 + i][8] = mod;
        }
        for (i = 0; i < 15; ++i) {
            mod = new Boolean(!test && (bits >> i & 1) == 1);
            if (i < 8) {
                this.modules[8][this.moduleCount - i - 1] = mod;
                continue;
            }
            if (i < 9) {
                this.modules[8][15 - i - 1 + 1] = mod;
                continue;
            }
            this.modules[8][15 - i - 1] = mod;
        }
        this.modules[this.moduleCount - 8][8] = new Boolean(!test);
    }

    private static byte[] createData(int typeNumber, int errorCorrectLevel, QRData[] dataArray) {
        RSBlock[] rsBlocks = RSBlock.getRSBlocks(typeNumber, errorCorrectLevel);
        BitBuffer buffer = new BitBuffer();
        for (int i = 0; i < dataArray.length; ++i) {
            QRData data = dataArray[i];
            buffer.put(data.getMode(), 4);
            buffer.put(data.getLength(), data.getLengthInBits(typeNumber));
            data.write(buffer);
        }
        int totalDataCount = 0;
        for (int i = 0; i < rsBlocks.length; ++i) {
            totalDataCount += rsBlocks[i].getDataCount();
        }
        if (buffer.getLengthInBits() > totalDataCount * 8) {
            throw new IllegalArgumentException("code length overflow. (" + buffer.getLengthInBits() + ">" + totalDataCount * 8 + ")");
        }
        if (buffer.getLengthInBits() + 4 <= totalDataCount * 8) {
            buffer.put(0, 4);
        }
        while (buffer.getLengthInBits() % 8 != 0) {
            buffer.put(false);
        }
        while (buffer.getLengthInBits() < totalDataCount * 8) {
            buffer.put(236, 8);
            if (buffer.getLengthInBits() >= totalDataCount * 8) break;
            buffer.put(17, 8);
        }
        return QRCode.createBytes(buffer, rsBlocks);
    }

    private static byte[] createBytes(BitBuffer buffer, RSBlock[] rsBlocks) {
        int i;
        int offset = 0;
        int maxDcCount = 0;
        int maxEcCount = 0;
        int[][] dcdata = new int[rsBlocks.length][];
        int[][] ecdata = new int[rsBlocks.length][];
        for (int r = 0; r < rsBlocks.length; ++r) {
            int dcCount = rsBlocks[r].getDataCount();
            int ecCount = rsBlocks[r].getTotalCount() - dcCount;
            maxDcCount = Math.max(maxDcCount, dcCount);
            maxEcCount = Math.max(maxEcCount, ecCount);
            dcdata[r] = new int[dcCount];
            for (int i2 = 0; i2 < dcdata[r].length; ++i2) {
                dcdata[r][i2] = 0xFF & buffer.getBuffer()[i2 + offset];
            }
            offset += dcCount;
            Polynomial rsPoly = QRUtil.getErrorCorrectPolynomial(ecCount);
            Polynomial rawPoly = new Polynomial(dcdata[r], rsPoly.getLength() - 1);
            Polynomial modPoly = rawPoly.mod(rsPoly);
            ecdata[r] = new int[rsPoly.getLength() - 1];
            for (int i3 = 0; i3 < ecdata[r].length; ++i3) {
                int modIndex = i3 + modPoly.getLength() - ecdata[r].length;
                ecdata[r][i3] = modIndex >= 0 ? modPoly.get(modIndex) : 0;
            }
        }
        int totalCodeCount = 0;
        for (int i4 = 0; i4 < rsBlocks.length; ++i4) {
            totalCodeCount += rsBlocks[i4].getTotalCount();
        }
        byte[] data = new byte[totalCodeCount];
        int index = 0;
        for (i = 0; i < maxDcCount; ++i) {
            for (int r = 0; r < rsBlocks.length; ++r) {
                if (i >= dcdata[r].length) continue;
                data[index++] = (byte)dcdata[r][i];
            }
        }
        for (i = 0; i < maxEcCount; ++i) {
            for (int r = 0; r < rsBlocks.length; ++r) {
                if (i >= ecdata[r].length) continue;
                data[index++] = (byte)ecdata[r][i];
            }
        }
        return data;
    }

    public static QRCode getMinimumQRCode(String data, int errorCorrectLevel) {
        int mode = QRUtil.getMode(data);
        QRCode qr = new QRCode();
        qr.setErrorCorrectLevel(errorCorrectLevel);
        qr.addData(data, mode);
        int length = qr.getData(0).getLength();
        for (int typeNumber = 1; typeNumber <= 10; ++typeNumber) {
            if (length > QRUtil.getMaxLength(typeNumber, mode, errorCorrectLevel)) continue;
            qr.setTypeNumber(typeNumber);
            break;
        }
        qr.make();
        return qr;
    }

    public GIFImage createGIFImage(int cellSize, int margin) throws IOException {
        int imageSize = this.getModuleCount() * cellSize + margin * 2;
        GIFImage image = new GIFImage(imageSize, imageSize);
        for (int y = 0; y < imageSize; ++y) {
            for (int x = 0; x < imageSize; ++x) {
                if (margin <= x && x < imageSize - margin && margin <= y && y < imageSize - margin) {
                    int row = (y - margin) / cellSize;
                    int col = (x - margin) / cellSize;
                    if (this.isDark(row, col)) {
                        image.setPixel(x, y, 0);
                        continue;
                    }
                    image.setPixel(x, y, 1);
                    continue;
                }
                image.setPixel(x, y, 1);
            }
        }
        return image;
    }

    public BufferedImage createImage(int cellSize, int margin) throws IOException {
        int imageSize = this.getModuleCount() * cellSize + margin * 2;
        BufferedImage image = new BufferedImage(imageSize, imageSize, 1);
        for (int y = 0; y < imageSize; ++y) {
            for (int x = 0; x < imageSize; ++x) {
                if (margin <= x && x < imageSize - margin && margin <= y && y < imageSize - margin) {
                    int row = (y - margin) / cellSize;
                    int col = (x - margin) / cellSize;
                    if (this.isDark(row, col)) {
                        image.setRGB(x, y, 0);
                        continue;
                    }
                    image.setRGB(x, y, 0xFFFFFF);
                    continue;
                }
                image.setRGB(x, y, 0xFFFFFF);
            }
        }
        return image;
    }
}

