/*
 * Decompiled with CFR 0.152.
 */
package com.edb.fastpath;

import com.edb.core.BaseConnection;
import com.edb.core.ParameterList;
import com.edb.core.QueryExecutor;
import com.edb.fastpath.FastpathArg;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;

public class Fastpath {
    private final Hashtable func = new Hashtable();
    private final QueryExecutor executor;
    private final BaseConnection connection;

    public Fastpath(BaseConnection conn) {
        this.connection = conn;
        this.executor = conn.getQueryExecutor();
    }

    public Object fastpath(int fnId, boolean resultType, FastpathArg[] args) throws SQLException {
        ParameterList params = this.executor.createFastpathParameters(args.length);
        for (int i = 0; i < args.length; ++i) {
            args[i].populateParameter(params, i + 1);
        }
        byte[] returnValue = this.executor.fastpathCall(fnId, params, this.connection.getAutoCommit());
        if (!resultType || returnValue == null) {
            return returnValue;
        }
        if (returnValue.length != 4) {
            throw new PSQLException(GT.tr("Fastpath call {0} - No result was returned and we expected an integer.", new Integer(fnId)));
        }
        return new Integer(returnValue[3] & 0xFF | (returnValue[2] & 0xFF) << 8 | (returnValue[1] & 0xFF) << 16 | (returnValue[0] & 0xFF) << 24);
    }

    public Object fastpath(String name, boolean resulttype, FastpathArg[] args) throws SQLException {
        if (this.connection.getLogger().logDebug()) {
            this.connection.getLogger().debug(" Fastpath: calling " + name);
        }
        return this.fastpath(this.getID(name), resulttype, args);
    }

    public int getInteger(String name, FastpathArg[] args) throws SQLException {
        Integer i = (Integer)this.fastpath(name, true, args);
        if (i == null) {
            throw new PSQLException(GT.tr("Fastpath call {0} - No result was returned and we expected an integer.", name));
        }
        return i;
    }

    public byte[] getData(String name, FastpathArg[] args) throws SQLException {
        return (byte[])this.fastpath(name, false, args);
    }

    public void addFunction(String name, int fnid) {
        this.func.put(name, new Integer(fnid));
    }

    public void addFunctions(ResultSet rs) throws SQLException {
        while (rs.next()) {
            this.func.put(rs.getString(1), new Integer(rs.getInt(2)));
        }
    }

    public int getID(String name) throws SQLException {
        Integer id = (Integer)this.func.get(name);
        if (id == null) {
            throw new PSQLException(GT.tr("The fastpath function {0} is unknown.", name), PSQLState.UNEXPECTED_ERROR);
        }
        return id;
    }
}

