/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.alarm;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.Notification;
import org.jboss.monitor.alarm.AlarmKey;
import org.jboss.monitor.alarm.AlarmNotification;
import org.jboss.monitor.alarm.AlarmTableNotification;
import org.jboss.monitor.alarm.MBeanImplAccess;

public class AlarmTable {
    protected MBeanImplAccess mbeanImpl;
    private String serverId;
    private Map alarmMap;

    public AlarmTable(MBeanImplAccess mbeanImpl) {
        this.mbeanImpl = mbeanImpl;
        this.alarmMap = new HashMap();
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void update(Notification n) {
        if (!(n instanceof AlarmTableNotification)) {
            if (n instanceof AlarmNotification) {
                AlarmNotification an = (AlarmNotification)n;
                if (an.getAlarmState() == 3) {
                    this.updateNotificationStateless(n, an.getSeverity());
                } else {
                    this.updateNotificationStatefull(an);
                }
            } else {
                this.updateNotificationStateless(n, 5);
            }
        }
    }

    public boolean acknowledge(String serverId, String source, String type, String user, String system) {
        AlarmKey key = AlarmKey.createKey(serverId, source, type);
        return this.acknowledge(key, user, system);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acknowledge(Object key, String user, String system) {
        AlarmTableNotification atn;
        AlarmTable alarmTable = this;
        synchronized (alarmTable) {
            AlarmTableNotification entry = (AlarmTableNotification)this.alarmMap.get(key);
            if (entry == null || entry.getAckState()) {
                return false;
            }
            entry.setAckParams(true, System.currentTimeMillis(), user, system);
            atn = new AlarmTableNotification(entry);
            atn.setSequenceNumber(this.mbeanImpl.getSequenceNumber());
            atn.setTimeStamp(System.currentTimeMillis());
            int alarmState = entry.getAlarmState();
            if (alarmState == 3 || alarmState == 0) {
                this.alarmMap.remove(key);
            }
        }
        this.mbeanImpl.emitNotification(atn);
        return true;
    }

    public boolean unacknowledge(String serverId, String source, String type, String user, String system) {
        AlarmKey key = AlarmKey.createKey(serverId, source, type);
        return this.unacknowledge(key, user, system);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unacknowledge(Object key, String user, String system) {
        AlarmTableNotification atn;
        AlarmTable alarmTable = this;
        synchronized (alarmTable) {
            AlarmTableNotification entry = (AlarmTableNotification)this.alarmMap.get(key);
            if (entry == null || !entry.getAckState()) {
                return false;
            }
            entry.setAckParams(false, System.currentTimeMillis(), user, system);
            atn = new AlarmTableNotification(entry);
            atn.setSequenceNumber(this.mbeanImpl.getSequenceNumber());
            atn.setTimeStamp(System.currentTimeMillis());
        }
        this.mbeanImpl.emitNotification(atn);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlarmTableNotification[] getAlarmTable() {
        AlarmTable alarmTable = this;
        synchronized (alarmTable) {
            int size = this.alarmMap.size();
            AlarmTableNotification[] copy = new AlarmTableNotification[size];
            Collection values = this.alarmMap.values();
            Iterator i = values.iterator();
            while (i.hasNext()) {
                AlarmTableNotification atn = (AlarmTableNotification)i.next();
                copy[--size] = new AlarmTableNotification(atn);
            }
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationStatefull(AlarmNotification an) {
        int alarmState = an.getAlarmState();
        int severity = an.getSeverity();
        AlarmTableNotification atn = new AlarmTableNotification("jboss.alarm.table.update", this.mbeanImpl.getMBeanName(), this.mbeanImpl.getSequenceNumber(), System.currentTimeMillis(), null, alarmState, severity, this.serverId);
        atn.setUserData(an);
        Object key = atn.createKey();
        AlarmTable alarmTable = this;
        synchronized (alarmTable) {
            if (alarmState == 0) {
                AlarmTableNotification entry = (AlarmTableNotification)this.alarmMap.get(key);
                if (entry != null && entry.getAckState()) {
                    this.alarmMap.remove(key);
                    atn.setAckParams(true, entry.getAckTime(), entry.getAckUser(), entry.getAckSystem());
                } else {
                    this.alarmMap.put(key, atn);
                }
            } else {
                this.alarmMap.put(key, atn);
            }
        }
        if (atn.getAckState()) {
            this.mbeanImpl.emitNotification(atn);
        } else {
            this.mbeanImpl.emitNotification(new AlarmTableNotification(atn));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationStateless(Notification n, int severity) {
        AlarmTableNotification atn = new AlarmTableNotification("jboss.alarm.table.update", this.mbeanImpl.getMBeanName(), this.mbeanImpl.getSequenceNumber(), System.currentTimeMillis(), null, 3, severity, this.serverId);
        atn.setUserData(n);
        Object key = atn.createKey();
        AlarmTable alarmTable = this;
        synchronized (alarmTable) {
            this.alarmMap.put(key, atn);
        }
        this.mbeanImpl.emitNotification(new AlarmTableNotification(atn));
    }
}

