/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wps.portletcontainer.cache;

import com.ibm.servlet.dynacache.FragmentInfo;
import com.ibm.websphere.servlet.cache.CacheEntry;
import com.ibm.websphere.servlet.cache.CacheableServlet;
import com.ibm.websphere.servlet.cache.DynamicCacheAccessor;
import com.ibm.websphere.servlet.cache.ServletCacheRequest;
import com.ibm.wps.services.log.Log;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.portlet.Portlet;
import org.apache.jetspeed.portlet.PortletRequest;
import org.apache.jetspeed.portletcontainer.PortletRequestImpl;
import org.apache.jetspeed.portletcontainer.om.portletinstanceregistry.PortletInstanceEntry;
import org.apache.jetspeed.portletcontainer.om.portletregistry.ConcretePortletEntry;
import org.apache.jetspeed.portletcontainer.om.portletregistry.PortletEntry;
import org.apache.jetspeed.portletcontainer.util.ThreadAttributesManager;

public abstract class CacheablePortlet
extends HttpServlet
implements CacheableServlet {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM, 5724-B88, (C) Copyright IBM Corp. 2001, 2003 - All Rights reserved.";
    private static final String COMPONENT_NAME = "portletcontainer";

    public String getId(HttpServletRequest request) {
        Integer methodIdObject;
        if (Log.isDebugEnabled((String)COMPONENT_NAME)) {
            Log.debug((String)COMPONENT_NAME, (String)"PortletAdapter CacheableServlet.getId()");
        }
        if ((methodIdObject = (Integer)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portlet.Portlet.METHOD_ID")) == null) {
            this.log("PortletAdapter.getId() METHOD_ID is null!!! :-((");
            return null;
        }
        if (methodIdObject != 120 && methodIdObject != 200) {
            return null;
        }
        PortletRequestImpl portletReq = (PortletRequestImpl)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portlet.Portlet.PORTLETREQUEST");
        if (portletReq.getWindow().getWindowState().getId() > 3) {
            if (Log.isDebugEnabled((String)COMPONENT_NAME)) {
                Log.debug((String)COMPONENT_NAME, (String)"Portlet CacheableServlet.getId() - uncachable window state...");
            }
            return null;
        }
        PortletInstanceEntry instanceEntry = portletReq.getPortletInstanceEntry();
        PortletEntry entry = instanceEntry.getConcretePortlet().getRootPortlet();
        long portletExpires = entry.getExpires();
        if (portletExpires == 0L) {
            return null;
        }
        Portlet.Mode portletMode = portletReq.getMode();
        if (portletMode != Portlet.Mode.VIEW) {
            portletReq.invalidateCache();
            return null;
        }
        String strCacheKey = portletReq.generateCacheKey();
        CacheEntry cached = DynamicCacheAccessor.getCache().getEntry(strCacheKey);
        if (cached != null) {
            ConcretePortletEntry concretePortlet = instanceEntry.getConcretePortlet();
            String cpid = concretePortlet.getPid().toString();
            String cpiid = instanceEntry.getPiid().toString();
            if (Log.isDebugEnabled((String)COMPONENT_NAME)) {
                Log.debug((String)COMPONENT_NAME, (String)("PortletInvokerCacheImpl.portletService: found cache entry for the portlet " + concretePortlet.getName() + " (CPID=" + cpid + "; CPIID=" + cpiid + ")"));
            }
            if (Log.isDebugEnabled((String)COMPONENT_NAME)) {
                Log.debug((String)COMPONENT_NAME, (String)("+++++Portlet CacheableServlet.getId(): Portlet " + concretePortlet.getName() + " is in mode: " + portletMode + " -> caching only for VIEW mode!"));
            }
            if (methodIdObject == 200) {
                portletReq.invalidateCache();
                return null;
            }
            if (this.isPortletModified(portletReq, cached)) {
                if (Log.isDebugEnabled((String)COMPONENT_NAME)) {
                    Log.debug((String)COMPONENT_NAME, (String)"PortletInvokerCacheImpl.portletService: but portlet is modified - invalidating cache entry");
                }
                portletReq.invalidateCache();
                cached = null;
            }
        }
        if (methodIdObject == 200) {
            return null;
        }
        if (cached == null) {
            com.ibm.websphere.servlet.cache.FragmentInfo fragmentInfo = ((ServletCacheRequest)request).getFragmentInfo();
            if (fragmentInfo instanceof FragmentInfo) {
                FragmentInfo tempFragmentInfo = (FragmentInfo)fragmentInfo;
                tempFragmentInfo.setConsumeSubfragments(true);
                tempFragmentInfo.setStoreAttributes(false);
                tempFragmentInfo.addDataId(portletReq.getGenericKey());
            }
            fragmentInfo.setTimeLimit((int)portletExpires);
        }
        if (Log.isDebugEnabled((String)COMPONENT_NAME)) {
            Log.debug((String)COMPONENT_NAME, (String)("PortletAdapter CacheAbleServlet.getId() -> " + strCacheKey));
        }
        return strCacheKey;
    }

    private boolean isPortletModified(PortletRequestImpl portletRequest, CacheEntry entry) {
        CacheablePortlet portlet = this;
        long portletModified = portlet.getLastModified((PortletRequest)portletRequest);
        long cacheModified = entry.getTimeStamp();
        if (Log.isDebugEnabled((String)COMPONENT_NAME)) {
            Log.debug((String)COMPONENT_NAME, (String)("PortletInvokerCacheImpl.isPortletModified: portletModified: " + portletModified + " - cacheModified: " + cacheModified));
        }
        return portletModified < 0L ? false : cacheModified < portletModified;
    }

    public int getSharingPolicy(HttpServletRequest request) {
        Log.debug((String)COMPONENT_NAME, (String)"PortletAdapter CacheableServlet.getSharingPolicy()");
        return 3;
    }

    public abstract long getLastModified(PortletRequest var1);
}

