/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEApplication;
import org.jboss.management.j2ee.J2EEDeployedObject;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEModule;
import org.jboss.management.j2ee.ResourceAdapterModuleMBean;

public class ResourceAdapterModule
extends J2EEModule
implements ResourceAdapterModuleMBean {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$management$j2ee$ResourceAdapterModule == null ? (class$org$jboss$management$j2ee$ResourceAdapterModule = ResourceAdapterModule.class$("org.jboss.management.j2ee.ResourceAdapterModule")) : class$org$jboss$management$j2ee$ResourceAdapterModule));
    private List resourceAdapters = new ArrayList();
    private static final Map fakeJ2EEApps = new HashMap();
    static /* synthetic */ Class class$org$jboss$management$j2ee$ResourceAdapterModule;

    public static ObjectName create(MBeanServer mbeanServer, String earName, String rarName, URL pURL) {
        String lDD = null;
        ObjectName lParent = null;
        ObjectName lCreated = null;
        ObjectName jsr77Name = null;
        ObjectName j2eeServerName = J2EEDomain.getDomainServerName(mbeanServer);
        try {
            Hashtable<String, String> props = j2eeServerName.getKeyPropertyList();
            String j2eeServer = props.get("j2eeType") + "=" + props.get("name");
            if (earName == null) {
                lParent = j2eeServerName;
            } else {
                ObjectName parentAppQuery = new ObjectName(J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "J2EEApplication" + "," + "name=" + earName + "," + j2eeServer + "," + "*");
                Set<ObjectName> parentApps = mbeanServer.queryNames(parentAppQuery, null);
                if (parentApps.size() == 0) {
                    lParent = lCreated = J2EEApplication.create(mbeanServer, earName, null);
                } else if (parentApps.size() == 1) {
                    lParent = parentApps.iterator().next();
                }
            }
            lDD = J2EEDeployedObject.getDeploymentDescriptor(pURL, 3);
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 ResourceAdapterModule: " + rarName), (Throwable)e);
            return null;
        }
        try {
            String[] jvms = (String[])mbeanServer.getAttribute(j2eeServerName, "javaVMs");
            ResourceAdapterModule rarModule = new ResourceAdapterModule(rarName, lParent, jvms, lDD);
            jsr77Name = rarModule.getObjectName();
            mbeanServer.registerMBean(rarModule, jsr77Name);
            if (lCreated != null) {
                fakeJ2EEApps.put(jsr77Name, lCreated);
            }
            log.debug((Object)("Created JSR-77 EJBModule: " + jsr77Name));
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 ResourceAdapterModule: " + rarName), (Throwable)e);
        }
        return jsr77Name;
    }

    public static void destroy(MBeanServer mbeanServer, ObjectName jsr77Name) {
        try {
            log.debug((Object)("destroy(), remove RARModule: " + jsr77Name));
            mbeanServer.unregisterMBean(jsr77Name);
            ObjectName jsr77ParentName = (ObjectName)fakeJ2EEApps.get(jsr77Name);
            if (jsr77ParentName != null) {
                log.debug((Object)("Remove fake JSR-77 parent Application: " + jsr77ParentName));
                J2EEApplication.destroy(mbeanServer, jsr77ParentName);
            }
        }
        catch (Exception e) {
            log.debug((Object)("Could not destroy JSR-77 RARModule: " + jsr77Name), (Throwable)e);
        }
    }

    public ResourceAdapterModule(String rarName, ObjectName jsr77ParentName, String[] pJVMs, String pDeploymentDescriptor) throws MalformedObjectNameException, InvalidParentException {
        super("ResourceAdapterModule", rarName, jsr77ParentName, pJVMs, pDeploymentDescriptor);
    }

    public String[] getresourceAdapters() {
        return this.resourceAdapters.toArray(new String[this.resourceAdapters.size()]);
    }

    public String getresourceAdapter(int pIndex) {
        if (pIndex >= 0 && pIndex < this.resourceAdapters.size()) {
            return (String)this.resourceAdapters.get(pIndex);
        }
        return null;
    }

    public void addChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("ResourceAdapter".equals(lType)) {
            this.resourceAdapters.add(pChild.getCanonicalName());
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("ResourceAdapter".equals(lType)) {
            this.resourceAdapters.remove(pChild.getCanonicalName());
        }
    }

    public String toString() {
        return "ResourceAdapterModule[ " + super.toString() + "ResourceAdapters: " + this.resourceAdapters + " ]";
    }

    protected Hashtable getParentKeys(ObjectName jsr77ParentName) {
        Hashtable<String, String> parentKeys = new Hashtable<String, String>();
        Hashtable<String, String> parentProps = jsr77ParentName.getKeyPropertyList();
        String parentName = parentProps.get("name");
        String j2eeType = parentProps.get("j2eeType");
        if (!j2eeType.equals("J2EEApplication")) {
            parentKeys.put("J2EEServer", parentName);
            parentKeys.put("J2EEApplication", "null");
        } else {
            parentKeys.put("J2EEApplication", parentName);
            String j2eeServerName = parentProps.get("J2EEServer");
            parentKeys.put("J2EEServer", j2eeServerName);
        }
        return parentKeys;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

