/*
 * Decompiled with CFR 0.152.
 */
package jnlp.sample.servlet;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.ServletContext;

public class JnlpResource {
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file";
    private static final String JAR_MIME_TYPE = "application/x-java-archive";
    private static final String JAR_MIME_TYPE_NEW = "application/java-archive";
    private static final String JNLP_EXTENSION = ".jnlp";
    private static final String JAR_EXTENSION = ".jar";
    private static String _jnlpExtension = ".jnlp";
    private static String _jarExtension = ".jar";
    private String _name;
    private String _versionId;
    private String[] _osList;
    private String[] _archList;
    private String[] _localeList;
    private String _path;
    private URL _resource;
    private long _lastModified;
    private String _mimeType;
    private String _returnVersionId;
    private String _encoding;

    public static void setDefaultExtensions(String string, String string2) {
        if (string != null && string.length() > 0) {
            if (!string.startsWith(".")) {
                string = "." + string;
            }
            _jnlpExtension = string;
        }
        if (string2 != null && string2.length() > 0) {
            if (!string2.startsWith(".")) {
                string2 = "." + string2;
            }
            _jarExtension = string2;
        }
    }

    public JnlpResource(ServletContext servletContext, String string) {
        this(servletContext, null, null, null, null, null, string, null);
    }

    public JnlpResource(ServletContext servletContext, String string, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, String string3, String string4) {
        this(servletContext, string, string2, stringArray, stringArray2, stringArray3, string3, string4, null);
    }

    public JnlpResource(ServletContext servletContext, String string, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, String string3, String string4, String string5) {
        this._encoding = string5;
        this._name = string;
        this._versionId = string2;
        this._osList = stringArray;
        this._archList = stringArray2;
        this._localeList = stringArray3;
        this._returnVersionId = string4;
        try {
            String string6;
            String string7 = string6 = string3.trim();
            this._resource = servletContext.getResource(string6);
            this._mimeType = this.getMimeType(servletContext, string6);
            if (this._resource != null) {
                boolean bl = false;
                if (string5 != null && this._mimeType != null && (this._mimeType.compareTo(JAR_MIME_TYPE) == 0 || this._mimeType.compareTo(JAR_MIME_TYPE_NEW) == 0) && string5.toLowerCase().indexOf("pack200-gzip") > -1) {
                    string7 = string6 + ".pack.gz";
                    this._resource = servletContext.getResource(string7);
                    if (this._resource != null) {
                        this._lastModified = this.getLastModified(servletContext, this._resource, string7);
                        if (this._lastModified != 0L) {
                            this._path = string7;
                            bl = true;
                        } else {
                            this._resource = null;
                        }
                    }
                }
                if (!(bl || string5 == null || this._mimeType == null || this._mimeType.compareTo(JAR_MIME_TYPE) != 0 && this._mimeType.compareTo(JAR_MIME_TYPE_NEW) != 0 || string5.toLowerCase().indexOf("gzip") <= -1)) {
                    string7 = string6 + ".gz";
                    this._resource = servletContext.getResource(string7);
                    if (this._resource != null) {
                        this._lastModified = this.getLastModified(servletContext, this._resource, string7);
                        if (this._lastModified != 0L) {
                            this._path = string7;
                            bl = true;
                        } else {
                            this._resource = null;
                        }
                    }
                }
                if (!bl) {
                    string7 = string6;
                    this._resource = servletContext.getResource(string7);
                    if (this._resource != null) {
                        this._lastModified = this.getLastModified(servletContext, this._resource, string7);
                        if (this._lastModified != 0L) {
                            this._path = string7;
                            bl = true;
                        } else {
                            this._resource = null;
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            this._resource = null;
        }
    }

    long getLastModified(ServletContext servletContext, URL uRL, String string) {
        File file;
        String string2;
        long l = 0L;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            l = uRLConnection.getLastModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l == 0L && (string2 = servletContext.getRealPath(string)) != null && (file = new File(string2)).exists()) {
            l = file.lastModified();
        }
        return l;
    }

    public String getPath() {
        return this._path;
    }

    public URL getResource() {
        return this._resource;
    }

    public String getMimeType() {
        return this._mimeType;
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public boolean exists() {
        return this._resource != null;
    }

    public boolean isJnlpFile() {
        return this._path.endsWith(_jnlpExtension);
    }

    public boolean isJarFile() {
        return this._path.endsWith(_jarExtension);
    }

    public String getName() {
        return this._name;
    }

    public String getVersionId() {
        return this._versionId;
    }

    public String[] getOSList() {
        return this._osList;
    }

    public String[] getArchList() {
        return this._archList;
    }

    public String[] getLocaleList() {
        return this._localeList;
    }

    public String getReturnVersionId() {
        return this._returnVersionId;
    }

    private String getMimeType(ServletContext servletContext, String string) {
        String string2 = servletContext.getMimeType(string);
        if (string2 != null) {
            return string2;
        }
        if (string.endsWith(_jnlpExtension)) {
            return JNLP_MIME_TYPE;
        }
        if (string.endsWith(_jarExtension)) {
            return JAR_MIME_TYPE;
        }
        return "application/unknown";
    }

    public String toString() {
        return "JnlpResource[WAR Path: " + this._path + this.showEntry(" versionId=", this._versionId) + this.showEntry(" name=", this._name) + " lastModified=" + new Date(this._lastModified) + this.showEntry(" osList=", this._osList) + this.showEntry(" archList=", this._archList) + this.showEntry(" localeList=", this._localeList) + "]" + this.showEntry(" returnVersionId=", this._returnVersionId) + "]";
    }

    private String showEntry(String string, String string2) {
        if (string2 == null) {
            return "";
        }
        return string + string2;
    }

    private String showEntry(String string, String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        return string + Arrays.asList(stringArray).toString();
    }
}

