/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Date;
import java.util.LinkedList;
import java.util.Vector;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPacketHandler;
import org.opennms.protocols.snmp.SnmpPduBulk;
import org.opennms.protocols.snmp.SnmpPduEncodingException;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpUtil;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;

public class SnmpPortal {
    public static final int DEFAULT_THREADPOOL_SIZE = 0;
    public static final int MAXIMUM_THREADPOOL_SIZE = 12;
    private SnmpPacketHandler m_handler;
    private DatagramSocket m_comm;
    private Thread m_recvThread;
    private int m_numOfExecutorThreads = 0;
    Vector m_threadPool;
    private AsnEncoder m_encoder;
    private volatile boolean m_isClosing;
    private boolean bSocketSoTimeoutRequired = true;
    private static final String PROP_SOCKET_TIMEOUT_REQUIRED = "org.opennms.joeSNMP.vmhacks.socketSoTimeoutRequired";
    private static final String PROP_SOCKET_TIMEOUT_PERIOD = "org.opennms.joeSNMP.vmhacks.socketSoTimeoutPeriod";
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Throwable;

    private SnmpPortal() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Illegal constructor call");
    }

    SnmpPortal(SnmpPacketHandler handler, AsnEncoder encoder, int port) throws SocketException {
        this(handler, encoder, port, null, 0);
    }

    SnmpPortal(SnmpPacketHandler handler, AsnEncoder encoder, int port, InetAddress laddr) throws SocketException {
        this(handler, encoder, port, laddr, 0);
    }

    SnmpPortal(SnmpPacketHandler handler, AsnEncoder encoder, int port, InetAddress laddr, int numOfThreads) throws SocketException {
        if (handler == null || encoder == null) {
            throw new IllegalArgumentException("Invalid argument");
        }
        this.m_handler = handler;
        this.m_comm = port >= 0 ? new DatagramSocket(port, laddr) : new DatagramSocket(0, laddr);
        this.bSocketSoTimeoutRequired = true;
        String strSocketSoTimeoutRequired = System.getProperty(PROP_SOCKET_TIMEOUT_REQUIRED);
        String osName = System.getProperty("os.name");
        if (strSocketSoTimeoutRequired != null && strSocketSoTimeoutRequired.equals("no")) {
            this.bSocketSoTimeoutRequired = false;
        }
        if (this.bSocketSoTimeoutRequired) {
            String strSocketSoTimeoutPeriod = System.getProperty(PROP_SOCKET_TIMEOUT_PERIOD);
            int timeout = 3000;
            if (strSocketSoTimeoutPeriod != null) {
                try {
                    timeout = Integer.parseInt(strSocketSoTimeoutPeriod);
                }
                catch (NumberFormatException e) {
                    timeout = 3000;
                }
            }
            this.m_comm.setSoTimeout(timeout);
        } else if (osName != null && osName.equalsIgnoreCase("linux")) {
            this.m_comm.setSoTimeout(100);
        }
        this.m_isClosing = false;
        if (0 < numOfThreads && numOfThreads <= 12) {
            this.m_numOfExecutorThreads = numOfThreads;
        }
        this.m_threadPool = new Vector(this.m_numOfExecutorThreads);
        for (int nThreadID = 0; nThreadID < this.m_numOfExecutorThreads; ++nThreadID) {
            Executor fastExecutor = new Executor("SnmpFastExecutor-" + (nThreadID + 1));
            this.m_threadPool.add(fastExecutor);
            fastExecutor.start();
        }
        this.m_recvThread = new Thread((Runnable)new Receiver(), "SnmpPortal-" + this.m_comm.getPort());
        this.m_encoder = encoder;
        this.m_recvThread.start();
    }

    void invokeHandlePkt(DatagramPacket pkt) {
        try {
            this.handlePkt(pkt);
        }
        catch (SnmpPduEncodingException err) {
            boolean handled = true;
            try {
                Class<?> loggerC = Class.forName("org.opennms.core.utils.ThreadCategory");
                Class[] methodParmList = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = SnmpPortal.class$("java.lang.Class")) : class$java$lang$Class};
                Method loggerM = loggerC.getMethod("getInstance", methodParmList);
                Object[] parmList = new Object[]{this.getClass()};
                Object loggerI = loggerM.invoke(null, parmList);
                methodParmList = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = SnmpPortal.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Throwable == null ? (class$java$lang$Throwable = SnmpPortal.class$("java.lang.Throwable")) : class$java$lang$Throwable};
                Method infoM = loggerC.getMethod("info", methodParmList);
                parmList = new Object[]{"An error occured decoding the protocol data unit", err};
                infoM.invoke(loggerI, parmList);
                methodParmList = new Class[]{};
                Method debugEnabledM = loggerC.getMethod("isDebugEnabled", methodParmList);
                parmList = new Object[]{};
                Boolean isEnabled = (Boolean)debugEnabledM.invoke(loggerI, parmList);
                if (isEnabled.booleanValue()) {
                    methodParmList = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = SnmpPortal.class$("java.lang.Object")) : class$java$lang$Object};
                    Method debugM = loggerC.getMethod("debug", methodParmList);
                    ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                    SnmpUtil.dumpHex(new PrintStream(ostream), pkt.getData(), 0, pkt.getLength());
                    parmList = new Object[]{ostream};
                    debugM.invoke(loggerI, parmList);
                }
            }
            catch (Throwable t) {
                handled = false;
            }
            if (!handled) {
                System.out.println(new Date() + " - SnmpPortal.Receiver.run: SnmpPduEncodingException: " + err.getMessage());
                SnmpUtil.dumpHex(System.out, pkt.getData(), 0, pkt.getLength());
            }
            this.m_handler.processBadDatagram(pkt);
        }
        catch (AsnDecodingException err) {
            boolean handled = true;
            try {
                Class<?> loggerC = Class.forName("org.opennms.core.utils.ThreadCategory");
                Class[] methodParmList = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = SnmpPortal.class$("java.lang.Class")) : class$java$lang$Class};
                Method loggerM = loggerC.getMethod("getInstance", methodParmList);
                Object[] parmList = new Object[]{this.getClass()};
                Object loggerI = loggerM.invoke(null, parmList);
                methodParmList = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = SnmpPortal.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Throwable == null ? (class$java$lang$Throwable = SnmpPortal.class$("java.lang.Throwable")) : class$java$lang$Throwable};
                Method infoM = loggerC.getMethod("info", methodParmList);
                parmList = new Object[]{"An ASN.1 error occured decoding the packet", err};
                infoM.invoke(loggerI, parmList);
                methodParmList = new Class[]{};
                Method debugEnabledM = loggerC.getMethod("isDebugEnabled", methodParmList);
                parmList = new Object[]{};
                Boolean isEnabled = (Boolean)debugEnabledM.invoke(loggerI, parmList);
                if (isEnabled.booleanValue()) {
                    methodParmList = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = SnmpPortal.class$("java.lang.Object")) : class$java$lang$Object};
                    Method debugM = loggerC.getMethod("debug", methodParmList);
                    ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                    SnmpUtil.dumpHex(new PrintStream(ostream), pkt.getData(), 0, pkt.getLength());
                    parmList = new Object[]{ostream};
                    debugM.invoke(loggerI, parmList);
                }
            }
            catch (Throwable t) {
                handled = false;
            }
            if (!handled) {
                System.out.println(new Date() + " - SnmpPortal.Receiver.run: AsnEncodingException: " + err.getMessage());
                SnmpUtil.dumpHex(System.out, pkt.getData(), 0, pkt.getLength());
            }
            this.m_handler.processBadDatagram(pkt);
        }
    }

    void handlePkt(DatagramPacket pkt) throws SnmpPduEncodingException, AsnDecodingException {
        byte[] buf = pkt.getData();
        int offset = 0;
        Object[] rVals = this.m_encoder.parseHeader(buf, offset);
        offset = (Integer)rVals[0];
        byte asnType = (Byte)rVals[1];
        int asnLength = (Integer)rVals[2];
        if (asnType != 48) {
            throw new AsnDecodingException("Invalid SNMP ASN.1 type");
        }
        if (asnLength > pkt.getLength() - offset) {
            throw new SnmpPduEncodingException("Insufficent data in packet");
        }
        SnmpInt32 int32 = new SnmpInt32();
        offset = int32.decodeASN(buf, offset, this.m_encoder);
        if (int32.getValue() != 0 && int32.getValue() != 1) {
            throw new SnmpPduEncodingException("Invalid protocol version");
        }
        SnmpOctetString community = new SnmpOctetString();
        offset = community.decodeASN(buf, offset, this.m_encoder);
        rVals = this.m_encoder.parseHeader(buf, offset);
        int cmd = ((Byte)rVals[1]).intValue() + 256;
        switch (cmd) {
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 166: 
            case 167: 
            case 168: {
                SnmpPduRequest pdu = new SnmpPduRequest();
                offset = pdu.decodeASN(buf, offset, this.m_encoder);
                this.m_handler.processSnmpMessage(pkt.getAddress(), pkt.getPort(), int32, community, cmd, pdu);
                break;
            }
            case 165: {
                SnmpPduBulk pdu = new SnmpPduBulk();
                offset = pdu.decodeASN(buf, offset, this.m_encoder);
                this.m_handler.processSnmpMessage(pkt.getAddress(), pkt.getPort(), int32, community, cmd, pdu);
                break;
            }
            case 164: {
                SnmpPduTrap trap = new SnmpPduTrap();
                offset = trap.decodeASN(buf, offset, this.m_encoder);
                this.m_handler.processSnmpTrap(pkt.getAddress(), pkt.getPort(), community, trap);
                break;
            }
            default: {
                throw new SnmpPduEncodingException("No matching PDU type found");
            }
        }
    }

    void send(SnmpPeer peer, byte[] buf, int length) throws IOException {
        DatagramPacket pkt = new DatagramPacket(buf, length, peer.getPeer(), peer.getPort());
        this.m_comm.send(pkt);
    }

    void send(SnmpPeer peer, byte[] buf) throws IOException {
        this.send(peer, buf, buf.length);
    }

    void setPacketHandler(SnmpPacketHandler hdl) {
        if (hdl == null) {
            throw new IllegalArgumentException("The packet handler must not be null");
        }
        this.m_handler = hdl;
    }

    SnmpPacketHandler getPacketHandler() {
        return this.m_handler;
    }

    void setAsnEncoder(AsnEncoder encoder) {
        if (encoder == null) {
            throw new IllegalArgumentException("The ASN.1 codec must not be null");
        }
        this.m_encoder = encoder;
    }

    AsnEncoder getAsnEncoder() {
        return this.m_encoder;
    }

    boolean isClosed() {
        return this.m_isClosing;
    }

    void close() {
        this.m_isClosing = true;
        this.m_comm.close();
        try {
            if (0 < this.m_numOfExecutorThreads) {
                for (int nThreadIndex = 0; nThreadIndex < this.m_numOfExecutorThreads; ++nThreadIndex) {
                    Executor fastExecutor = (Executor)this.m_threadPool.elementAt(nThreadIndex);
                    if (fastExecutor.isSuspended()) {
                        fastExecutor.myResume();
                        continue;
                    }
                    --nThreadIndex;
                    this.wait(100L);
                }
            }
            if (!this.m_recvThread.equals(Thread.currentThread())) {
                this.m_recvThread.join();
            }
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Receiver
    implements Runnable {
        private Receiver() {
        }

        private int setup() {
            int bufSz = 65536;
            try {
                SnmpPortal.this.m_comm.setReceiveBufferSize(bufSz);
            }
            catch (SocketException err) {
                bufSz = 0;
            }
            if (bufSz == 0) {
                try {
                    bufSz = SnmpPortal.this.m_comm.getReceiveBufferSize();
                }
                catch (SocketException err) {
                    bufSz = 0;
                }
            }
            return bufSz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            final int bufSz = this.setup();
            if (bufSz == 0) {
                return;
            }
            final LinkedList fastReceiverQ = new LinkedList();
            final LinkedList<byte[]> usedBuffers = new LinkedList<byte[]>();
            Thread fastReceiver = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (!SnmpPortal.this.m_isClosing && !Thread.interrupted()) {
                        byte[] buf = null;
                        LinkedList linkedList = usedBuffers;
                        synchronized (linkedList) {
                            if (!usedBuffers.isEmpty()) {
                                buf = (byte[])usedBuffers.removeFirst();
                            }
                        }
                        if (buf == null || buf.length != bufSz) {
                            buf = new byte[bufSz];
                        }
                        try {
                            DatagramPacket pkt = new DatagramPacket(buf, buf.length);
                            SnmpPortal.this.m_comm.receive(pkt);
                            LinkedList linkedList2 = fastReceiverQ;
                            synchronized (linkedList2) {
                                fastReceiverQ.addLast(pkt);
                                fastReceiverQ.notify();
                            }
                        }
                        catch (InterruptedIOException ioe) {
                            LinkedList linkedList3 = usedBuffers;
                            synchronized (linkedList3) {
                                usedBuffers.addLast(buf);
                            }
                        }
                        catch (Exception e) {
                            if (SnmpPortal.this.m_isClosing) continue;
                            boolean handled = true;
                            try {
                                Class<?> loggerC = Class.forName("org.opennms.core.utils.ThreadCategory");
                                Class[] methodParmList = new Class[]{class$java$lang$Class == null ? SnmpPortal.class$("java.lang.Class") : class$java$lang$Class};
                                Method loggerM = loggerC.getMethod("getInstance", methodParmList);
                                Object[] parmList = new Object[]{this.getClass()};
                                Object loggerI = loggerM.invoke(null, parmList);
                                methodParmList = new Class[]{class$java$lang$Object == null ? SnmpPortal.class$("java.lang.Object") : class$java$lang$Object, class$java$lang$Throwable == null ? SnmpPortal.class$("java.lang.Throwable") : class$java$lang$Throwable};
                                Method infoM = loggerC.getMethod("info", methodParmList);
                                parmList = new Object[]{"An unknown error occured decoding the packet", e};
                                infoM.invoke(loggerI, parmList);
                            }
                            catch (Throwable t) {
                                handled = false;
                            }
                            if (!handled) {
                                System.out.println(new Date() + " - Exception: " + e.getMessage());
                            }
                            SnmpPortal.this.m_handler.processException(e);
                        }
                    }
                }
            }, Thread.currentThread().getName() + "-FastReceiver");
            fastReceiver.start();
            while (!SnmpPortal.this.m_isClosing) {
                DatagramPacket pkt;
                block20: {
                    pkt = null;
                    try {
                        LinkedList linkedList = fastReceiverQ;
                        synchronized (linkedList) {
                            while (fastReceiverQ.isEmpty() && !SnmpPortal.this.m_isClosing) {
                                fastReceiverQ.wait(300L);
                            }
                            if (SnmpPortal.this.m_isClosing) {
                                continue;
                            }
                            pkt = (DatagramPacket)fastReceiverQ.removeFirst();
                            if (null == pkt) {
                                continue;
                            }
                        }
                        if (SnmpPortal.this.m_numOfExecutorThreads > 0) {
                            for (int nThreadIndex = 0; nThreadIndex < SnmpPortal.this.m_numOfExecutorThreads; ++nThreadIndex) {
                                Executor fastExecutor = (Executor)SnmpPortal.this.m_threadPool.elementAt(nThreadIndex);
                                if (fastExecutor.isSuspended()) {
                                    fastExecutor.pkt = pkt;
                                    fastExecutor.myResume();
                                    break block20;
                                }
                                if (nThreadIndex + 1 < SnmpPortal.this.m_numOfExecutorThreads) continue;
                                nThreadIndex = -1;
                                this.wait(100L);
                            }
                            break block20;
                        }
                        SnmpPortal.this.invokeHandlePkt(pkt);
                    }
                    catch (Exception e) {
                        if (SnmpPortal.this.m_isClosing) break block20;
                        boolean handled = true;
                        try {
                            Class<?> loggerC = Class.forName("org.opennms.core.utils.ThreadCategory");
                            Class[] methodParmList = new Class[]{class$java$lang$Class == null ? SnmpPortal.class$("java.lang.Class") : class$java$lang$Class};
                            Method loggerM = loggerC.getMethod("getInstance", methodParmList);
                            Object[] parmList = new Object[]{this.getClass()};
                            Object loggerI = loggerM.invoke(null, parmList);
                            methodParmList = new Class[]{class$java$lang$Object == null ? SnmpPortal.class$("java.lang.Object") : class$java$lang$Object, class$java$lang$Throwable == null ? SnmpPortal.class$("java.lang.Throwable") : class$java$lang$Throwable};
                            Method infoM = loggerC.getMethod("info", methodParmList);
                            parmList = new Object[]{"An unknown error occured decoding the packet", e};
                            infoM.invoke(loggerI, parmList);
                        }
                        catch (Throwable t) {
                            handled = false;
                        }
                        if (!handled) {
                            System.out.println(new Date() + " - Exception: " + e.getMessage());
                        }
                        SnmpPortal.this.m_handler.processException(e);
                    }
                }
                if (pkt == null) continue;
                LinkedList<byte[]> linkedList = usedBuffers;
                synchronized (linkedList) {
                    if (usedBuffers.size() < 20) {
                        usedBuffers.addLast(pkt.getData());
                    }
                }
            }
        }
    }

    private class Executor
    extends Thread {
        DatagramPacket pkt = null;
        boolean suspendFlag = false;

        public Executor(String str) {
            super(str);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!SnmpPortal.this.m_isClosing) {
                try {
                    if (null != this.pkt) {
                        SnmpPortal.this.invokeHandlePkt(this.pkt);
                        this.pkt = null;
                    }
                    this.mySuspend();
                    Executor executor = this;
                    synchronized (executor) {
                        while (this.suspendFlag) {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        synchronized void mySuspend() {
            this.suspendFlag = true;
        }

        synchronized boolean isSuspended() {
            return this.suspendFlag;
        }

        synchronized void myResume() {
            this.suspendFlag = false;
            this.notify();
        }
    }
}

