/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHArrayInitializer;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import java.lang.reflect.Array;

class BSHArrayDimensions
extends SimpleNode {
    public Class baseType;
    public int numDefinedDims;
    public int numUndefinedDims;
    public int[] definedDimensions;

    BSHArrayDimensions(int n) {
        super(n);
    }

    public void addDefinedDimension() {
        ++this.numDefinedDims;
    }

    public void addUndefinedDimension() {
        ++this.numUndefinedDims;
    }

    public Object eval(Class clazz, CallStack callStack, Interpreter interpreter) throws EvalError {
        if (Interpreter.DEBUG) {
            Interpreter.debug("array base type = " + clazz);
        }
        this.baseType = clazz;
        return this.eval(callStack, interpreter);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(0);
        if (simpleNode instanceof BSHArrayInitializer) {
            if (this.baseType == null) {
                throw new EvalError("Internal Array Eval err:  unknown base type", this, callStack);
            }
            Object object2 = ((BSHArrayInitializer)simpleNode).eval(this.baseType, this.numUndefinedDims, callStack, interpreter);
            Class<?> clazz = object2.getClass();
            int n = Reflect.getArrayDimensions(clazz);
            this.definedDimensions = new int[n];
            if (this.definedDimensions.length != this.numUndefinedDims) {
                throw new EvalError("Incompatible initializer. Allocation calls for a " + this.numUndefinedDims + " dimensional array, but initializer is a " + n + " dimensional array", this, callStack);
            }
            Object object3 = object2;
            int n2 = 0;
            while (n2 < this.definedDimensions.length) {
                this.definedDimensions[n2] = Array.getLength(object3);
                if (this.definedDimensions[n2] > 0) {
                    object3 = Array.get(object3, 0);
                }
                ++n2;
            }
            return object2;
        }
        this.definedDimensions = new int[this.numDefinedDims];
        int n = 0;
        while (n < this.numDefinedDims) {
            try {
                Object object4 = ((SimpleNode)this.jjtGetChild(n)).eval(callStack, interpreter);
                this.definedDimensions[n] = ((Primitive)object4).intValue();
            }
            catch (Exception exception) {
                throw new EvalError("Array index: " + n + " does not evaluate to an integer", this, callStack);
            }
            ++n;
        }
        return Primitive.VOID;
    }
}

