/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

import com.d_project.qrcode.BitBuffer;
import com.d_project.qrcode.QRData;

class QRAlphaNum
extends QRData {
    public QRAlphaNum(String data) {
        super(2, data);
    }

    public void write(BitBuffer buffer) {
        char[] c2 = this.getData().toCharArray();
        int i2 = 0;
        while (i2 + 1 < c2.length) {
            buffer.put(QRAlphaNum.getCode(c2[i2]) * 45 + QRAlphaNum.getCode(c2[i2 + 1]), 11);
            i2 += 2;
        }
        if (i2 < c2.length) {
            buffer.put(QRAlphaNum.getCode(c2[i2]), 6);
        }
    }

    public int getLength() {
        return this.getData().length();
    }

    private static int getCode(char c2) {
        if ('0' <= c2 && c2 <= '9') {
            return c2 - 48;
        }
        if ('A' <= c2 && c2 <= 'Z') {
            return c2 - 65 + 10;
        }
        switch (c2) {
            case ' ': {
                return 36;
            }
            case '$': {
                return 37;
            }
            case '%': {
                return 38;
            }
            case '*': {
                return 39;
            }
            case '+': {
                return 40;
            }
            case '-': {
                return 41;
            }
            case '.': {
                return 42;
            }
            case '/': {
                return 43;
            }
            case ':': {
                return 44;
            }
        }
        throw new IllegalArgumentException("illegal char :" + c2);
    }
}

