/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

class QRMath {
    private static final int[] EXP_TABLE;
    private static final int[] LOG_TABLE;

    private QRMath() {
    }

    public static int glog(int n) {
        if (n < 1) {
            throw new ArithmeticException("log(" + n + ")");
        }
        return LOG_TABLE[n];
    }

    public static int gexp(int n) {
        while (n < 0) {
            n += 255;
        }
        while (n >= 256) {
            n -= 255;
        }
        return EXP_TABLE[n];
    }

    static {
        int i2;
        EXP_TABLE = new int[256];
        for (i2 = 0; i2 < 8; ++i2) {
            QRMath.EXP_TABLE[i2] = 1 << i2;
        }
        for (i2 = 8; i2 < 256; ++i2) {
            QRMath.EXP_TABLE[i2] = EXP_TABLE[i2 - 4] ^ EXP_TABLE[i2 - 5] ^ EXP_TABLE[i2 - 6] ^ EXP_TABLE[i2 - 8];
        }
        LOG_TABLE = new int[256];
        for (i2 = 0; i2 < 255; ++i2) {
            QRMath.LOG_TABLE[QRMath.EXP_TABLE[i2]] = i2;
        }
    }
}

