/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfObject;

public class PdfNumber
extends PdfObject {
    private double value;

    public PdfNumber(String string) {
        super(2);
        try {
            this.value = Double.parseDouble(string.trim());
            this.setContent(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException(string + " is not a valid number - " + numberFormatException.toString());
        }
    }

    public PdfNumber(int n) {
        super(2);
        this.value = n;
        this.setContent(String.valueOf(n));
    }

    public PdfNumber(double d2) {
        super(2);
        this.value = d2;
        this.setContent(ByteBuffer.formatDouble(d2));
    }

    public PdfNumber(float f2) {
        this((double)f2);
    }

    public int intValue() {
        return (int)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public void increment() {
        this.value += 1.0;
        this.setContent(ByteBuffer.formatDouble(this.value));
    }
}

