/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools;

import com.lowagie.text.pdf.PdfEncryptor;
import com.lowagie.text.pdf.PdfReader;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class EncryptPdf {
    private static final int INPUT_FILE = 0;
    private static final int OUTPUT_FILE = 1;
    private static final int USER_PASSWORD = 2;
    private static final int OWNER_PASSWORD = 3;
    private static final int PERMISSIONS = 4;
    private static final int STRENGTH = 5;
    private static final int MOREINFO = 6;
    private static final int[] permit = new int[]{2052, 8, 16, 32, 256, 512, 1024, 4};

    private static void usage() {
        System.out.println("usage: input_file output_file user_password owner_password permissions 128|40 [new info string pairs]");
        System.out.println("permissions is 8 digit long 0 or 1. Each digit has a particular security function:");
        System.out.println();
        System.out.println("AllowPrinting");
        System.out.println("AllowModifyContents");
        System.out.println("AllowCopy");
        System.out.println("AllowModifyAnnotations");
        System.out.println("AllowFillIn (128 bit only)");
        System.out.println("AllowScreenReaders (128 bit only)");
        System.out.println("AllowAssembly (128 bit only)");
        System.out.println("AllowDegradedPrinting (128 bit only)");
        System.out.println("Example permissions to copy and print would be: 10100000");
    }

    public static void main(String[] stringArray) {
        System.out.println("PDF document encryptor");
        if (stringArray.length <= 5 || stringArray[4].length() != 8) {
            EncryptPdf.usage();
            return;
        }
        try {
            int n = 0;
            String string = stringArray[4];
            for (int j = 0; j < string.length(); ++j) {
                n |= string.charAt(j) == '0' ? 0 : permit[j];
            }
            System.out.println("Reading " + stringArray[0]);
            PdfReader pdfReader = new PdfReader(stringArray[0]);
            System.out.println("Writing " + stringArray[1]);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int j = 6; j < stringArray.length - 1; j += 2) {
                hashMap.put(stringArray[j], stringArray[j + 1]);
            }
            PdfEncryptor.encrypt(pdfReader, (OutputStream)new FileOutputStream(stringArray[1]), stringArray[2].getBytes(), stringArray[3].getBytes(), n, stringArray[5].equals("128"), hashMap);
            System.out.println("Done.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

