/*
 * Decompiled with CFR 0.152.
 */
package groovy.sql;

import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import groovy.sql.Sql;
import groovy.sql.SqlOrderByVisitor;
import groovy.sql.SqlWhereVisitor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.stmt.Statement;

public class DataSet
extends Sql {
    private Closure where;
    private Closure sort;
    private boolean reversed = false;
    private DataSet parent;
    private String table;
    private SqlWhereVisitor visitor;
    private SqlOrderByVisitor sortVisitor;
    private String sql;
    private List params;

    public DataSet(Sql sql, Class type) {
        super(sql);
        String table2 = type.getName();
        int idx = table2.lastIndexOf(46);
        if (idx > 0) {
            table2 = table2.substring(idx + 1);
        }
        this.table = table2.toLowerCase();
    }

    public DataSet(Sql sql, String table2) {
        super(sql);
        this.table = table2;
    }

    private DataSet(DataSet parent, Closure where) {
        super(parent);
        this.table = parent.table;
        this.parent = parent;
        this.where = where;
    }

    private DataSet(DataSet parent, Closure where, Closure sort) {
        super(parent);
        this.table = parent.table;
        this.parent = parent;
        this.where = where;
        this.sort = sort;
    }

    private DataSet(DataSet parent) {
        super(parent);
        this.table = parent.table;
        this.parent = parent;
        this.reversed = true;
    }

    public void add(Map values) throws SQLException {
        StringBuffer buffer = new StringBuffer("insert into ");
        buffer.append(this.table);
        buffer.append(" (");
        StringBuffer paramBuffer = new StringBuffer();
        boolean first = true;
        Iterator iter = values.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String column = entry.getKey().toString();
            if (first) {
                first = false;
                paramBuffer.append("?");
            } else {
                buffer.append(", ");
                paramBuffer.append(", ?");
            }
            buffer.append(column);
        }
        buffer.append(") values (");
        buffer.append(paramBuffer.toString());
        buffer.append(")");
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(buffer.toString());
            int i2 = 1;
            Iterator iter2 = values.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry = iter2.next();
                this.setObject(statement, i2++, entry.getValue());
            }
            int answer = statement.executeUpdate();
            if (answer != 1) {
                this.log.log(Level.WARNING, "Should have updated 1 row not " + answer + " when trying to add: " + values);
            }
        }
        catch (SQLException e2) {
            this.log.log(Level.WARNING, "Failed to add row for: " + values, e2);
            throw e2;
        }
        finally {
            this.closeResources(connection, statement);
        }
    }

    public DataSet findAll(Closure where) {
        return new DataSet(this, where);
    }

    public DataSet sort(Closure sort) {
        return new DataSet(this, null, sort);
    }

    public DataSet reverse() {
        if (this.sort == null) {
            throw new GroovyRuntimeException("reverse() only allowed immediately after a sort()");
        }
        return new DataSet(this);
    }

    public void each(Closure closure) throws SQLException {
        this.eachRow(this.getSql(), this.getParameters(), closure);
    }

    private String getSqlWhere() {
        String whereClaus = "";
        String parentClaus = "";
        if (this.parent != null) {
            parentClaus = this.parent.getSqlWhere();
        }
        if (this.where != null) {
            whereClaus = whereClaus + this.getSqlWhereVisitor().getWhere();
        }
        if (parentClaus.length() == 0) {
            return whereClaus;
        }
        if (whereClaus.length() == 0) {
            return parentClaus;
        }
        return parentClaus + " and " + whereClaus;
    }

    private String getSqlOrderBy() {
        String sortByClaus = "";
        String parentClaus = "";
        if (this.parent != null) {
            parentClaus = this.parent.getSqlOrderBy();
        }
        if (this.reversed && parentClaus.length() > 0) {
            parentClaus = parentClaus + " DESC";
        }
        if (this.sort != null) {
            sortByClaus = sortByClaus + this.getSqlOrderByVisitor().getOrderBy();
        }
        if (parentClaus.length() == 0) {
            return sortByClaus;
        }
        if (sortByClaus.length() == 0) {
            return parentClaus;
        }
        return parentClaus + ", " + sortByClaus;
    }

    public String getSql() {
        if (this.sql == null) {
            String orerByClaus;
            this.sql = "select * from " + this.table;
            String whereClaus = this.getSqlWhere();
            if (whereClaus.length() > 0) {
                this.sql = this.sql + " where " + whereClaus;
            }
            if ((orerByClaus = this.getSqlOrderBy()).length() > 0) {
                this.sql = this.sql + " order by " + orerByClaus;
            }
        }
        return this.sql;
    }

    public List getParameters() {
        if (this.params == null) {
            this.params = new ArrayList();
            if (this.parent != null) {
                this.params.addAll(this.parent.getParameters());
            }
            this.params.addAll(this.getSqlWhereVisitor().getParameters());
        }
        return this.params;
    }

    protected SqlWhereVisitor getSqlWhereVisitor() {
        if (this.visitor == null) {
            this.visitor = new SqlWhereVisitor();
            this.visit(this.where, this.visitor);
        }
        return this.visitor;
    }

    protected SqlOrderByVisitor getSqlOrderByVisitor() {
        if (this.sortVisitor == null) {
            this.sortVisitor = new SqlOrderByVisitor();
            this.visit(this.sort, this.sortVisitor);
        }
        return this.sortVisitor;
    }

    private void visit(Closure closure, CodeVisitorSupport visitor) {
        if (closure != null) {
            Statement statement;
            MethodNode method;
            ClassNode classNode = closure.getMetaClass().getClassNode();
            if (classNode == null) {
                throw new GroovyRuntimeException("Could not find the ClassNode for MetaClass: " + closure.getMetaClass());
            }
            List methods = classNode.getDeclaredMethods("doCall");
            if (!methods.isEmpty() && (method = (MethodNode)methods.get(0)) != null && (statement = method.getCode()) != null) {
                statement.visit(visitor);
            }
        }
    }

    public DataSet createView(Closure criteria) {
        return new DataSet(this, criteria);
    }

    public List rows() throws SQLException {
        return this.rows(this.getSql(), this.getParameters());
    }

    public Object firstRow() throws SQLException {
        List rows = this.rows();
        if (rows.isEmpty()) {
            return null;
        }
        return rows.get(0);
    }
}

