/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.fill.JRFillXySeries;
import net.sf.jasperreports.charts.util.XYDatasetLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.util.Pair;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class JRFillXyDataset
extends JRFillChartDataset
implements JRXyDataset {
    protected JRFillXySeries[] xySeries = null;
    private List seriesNames = null;
    private Map seriesMap = null;
    private Map labelsMap = null;
    private Map itemHyperlinks;

    public JRFillXyDataset(JRXyDataset xyDataset, JRFillObjectFactory factory) {
        super(xyDataset, factory);
        JRXySeries[] srcXySeries = xyDataset.getSeries();
        if (srcXySeries != null && srcXySeries.length > 0) {
            this.xySeries = new JRFillXySeries[srcXySeries.length];
            for (int i2 = 0; i2 < this.xySeries.length; ++i2) {
                this.xySeries[i2] = (JRFillXySeries)factory.getXySeries(srcXySeries[i2]);
            }
        }
    }

    public JRXySeries[] getSeries() {
        return this.xySeries;
    }

    protected void customInitialize() {
        this.seriesNames = null;
        this.seriesMap = null;
        this.labelsMap = null;
        this.itemHyperlinks = null;
    }

    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        if (this.xySeries != null && this.xySeries.length > 0) {
            for (int i2 = 0; i2 < this.xySeries.length; ++i2) {
                this.xySeries[i2].evaluate(calculator);
            }
        }
    }

    protected void customIncrement() {
        if (this.xySeries != null && this.xySeries.length > 0) {
            if (this.seriesNames == null) {
                this.seriesNames = new ArrayList();
                this.seriesMap = new HashMap();
                this.labelsMap = new HashMap();
                this.itemHyperlinks = new HashMap();
            }
            for (int i2 = 0; i2 < this.xySeries.length; ++i2) {
                JRFillXySeries crtXySeries = this.xySeries[i2];
                Comparable seriesName = crtXySeries.getSeries();
                XYSeries xySrs = (XYSeries)this.seriesMap.get(seriesName);
                if (xySrs == null) {
                    xySrs = new XYSeries(seriesName);
                    this.seriesNames.add(seriesName);
                    this.seriesMap.put(seriesName, xySrs);
                }
                xySrs.addOrUpdate(crtXySeries.getXValue(), crtXySeries.getYValue());
                if (crtXySeries.getLabelExpression() != null) {
                    HashMap<Number, String> seriesLabels = (HashMap<Number, String>)this.labelsMap.get(seriesName);
                    if (seriesLabels == null) {
                        seriesLabels = new HashMap<Number, String>();
                        this.labelsMap.put(seriesName, seriesLabels);
                    }
                    seriesLabels.put(crtXySeries.getXValue(), crtXySeries.getLabel());
                }
                if (!crtXySeries.hasItemHyperlinks()) continue;
                HashMap<Pair, JRPrintHyperlink> seriesLinks = (HashMap<Pair, JRPrintHyperlink>)this.itemHyperlinks.get(seriesName);
                if (seriesLinks == null) {
                    seriesLinks = new HashMap<Pair, JRPrintHyperlink>();
                    this.itemHyperlinks.put(seriesName, seriesLinks);
                }
                Pair xyKey = new Pair(crtXySeries.getXValue(), crtXySeries.getYValue());
                seriesLinks.put(xyKey, crtXySeries.getPrintItemHyperlink());
            }
        }
    }

    public Dataset getCustomDataset() {
        XYSeriesCollection dataset = new XYSeriesCollection();
        if (this.seriesNames != null) {
            for (int i2 = 0; i2 < this.seriesNames.size(); ++i2) {
                Comparable seriesName = (Comparable)this.seriesNames.get(i2);
                dataset.addSeries((XYSeries)this.seriesMap.get(seriesName));
            }
        }
        return dataset;
    }

    public byte getDatasetType() {
        return 3;
    }

    public Object getLabelGenerator() {
        return new XYDatasetLabelGenerator(this.labelsMap);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public Map getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    public boolean hasItemHyperlinks() {
        boolean foundLinks = false;
        if (this.xySeries != null && this.xySeries.length > 0) {
            for (int i2 = 0; i2 < this.xySeries.length && !foundLinks; ++i2) {
                JRFillXySeries serie = this.xySeries[i2];
                foundLinks = serie.hasItemHyperlinks();
            }
        }
        return foundLinks;
    }

    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }
}

