/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barbecue;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sf.jasperreports.engine.JRAbstractSvgRenderer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.output.OutputException;

public class BarbecueRenderer
extends JRAbstractSvgRenderer {
    private static final long serialVersionUID = 1L;
    private Barcode barcode = null;

    public BarbecueRenderer(Barcode barcode) {
        this.barcode = barcode;
    }

    public Dimension2D getDimension() {
        return this.barcode.getSize();
    }

    public void render(Graphics2D grx, Rectangle2D rectangle) {
        AffineTransform origTransform = grx.getTransform();
        try {
            Dimension size = this.barcode.getSize();
            grx.translate(rectangle.getX(), rectangle.getY());
            if (rectangle.getWidth() != size.getWidth() || rectangle.getHeight() != size.getHeight()) {
                grx.scale(rectangle.getWidth() / size.getWidth(), rectangle.getHeight() / size.getHeight());
            }
            this.barcode.draw(grx, 0, 0);
        }
        catch (OutputException e2) {
            throw new JRRuntimeException(e2);
        }
        finally {
            grx.setTransform(origTransform);
        }
    }
}

