/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;

public class ParagraphHelper
extends BaseHelper {
    private static final String HORIZONTAL_ALIGN_LEFT = "left";
    private static final String HORIZONTAL_ALIGN_RIGHT = "right";
    private static final String HORIZONTAL_ALIGN_CENTER = "center";
    private static final String HORIZONTAL_ALIGN_BOTH = "both";
    private boolean pageBreak = false;

    public ParagraphHelper(Writer writer, boolean pageBreak) {
        super(writer);
        this.pageBreak = pageBreak;
    }

    public void exportProps(JRStyle style2) throws IOException {
        this.exportPropsHeader(null);
        this.exportAlignment(ParagraphHelper.getHorizontalAlignment(style2.getOwnHorizontalAlignment()));
        this.exportPropsFooter();
    }

    public void exportProps(JRPrintText text) throws IOException {
        this.exportPropsHeader(text.getStyle() == null ? null : text.getStyle().getName());
        this.exportAlignment(ParagraphHelper.getHorizontalAlignment(text.getOwnHorizontalAlignment()));
        this.exportPropsFooter();
    }

    private void exportPropsHeader(String styleNameReference) throws IOException {
        this.writer.write("      <w:pPr>\n");
        if (styleNameReference != null) {
            this.writer.write("        <w:pStyle w:val=\"" + styleNameReference + "\"/>\n");
        }
        if (this.pageBreak) {
            this.writer.write("        <w:pageBreakBefore/>\n");
            this.pageBreak = false;
        }
    }

    private void exportAlignment(String horizontalAlignment) throws IOException {
        if (horizontalAlignment != null) {
            this.writer.write("   <w:jc w:val=\"" + horizontalAlignment + "\" />\n");
        }
    }

    private void exportPropsFooter() throws IOException {
        this.writer.write("      </w:pPr>\n");
    }

    public void exportEmptyParagraph() throws IOException {
        this.writer.write("     <w:p><w:pPr>\n");
        if (this.pageBreak) {
            this.writer.write("        <w:pageBreakBefore/>\n");
            this.pageBreak = false;
        }
        this.writer.write("     </w:pPr></w:p>\n");
    }

    public static String getHorizontalAlignment(Byte horizontalAlignment) {
        if (horizontalAlignment != null) {
            switch (horizontalAlignment) {
                case 3: {
                    return HORIZONTAL_ALIGN_RIGHT;
                }
                case 2: {
                    return HORIZONTAL_ALIGN_CENTER;
                }
                case 4: {
                    return HORIZONTAL_ALIGN_BOTH;
                }
            }
            return HORIZONTAL_ALIGN_LEFT;
        }
        return null;
    }
}

