/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.ParagraphHelper;
import net.sf.jasperreports.engine.export.ooxml.RunHelper;

public class ReportStyleHelper
extends BaseHelper {
    private ParagraphHelper paragraphHelper = null;
    private RunHelper runHelper = null;

    public ReportStyleHelper(Writer writer, Map fontMap) {
        super(writer);
        this.paragraphHelper = new ParagraphHelper(writer, false);
        this.runHelper = new RunHelper(writer, fontMap);
    }

    public void export(List jasperPrintList) throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.writer.write("<w:styles\n");
        this.writer.write(" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"\n");
        this.writer.write(" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n");
        this.writer.write(" <w:docDefaults>\n");
        this.writer.write("  <w:rPrDefault>\n");
        this.writer.write("   <w:rPr>\n");
        this.writer.write("    <w:rFonts w:ascii=\"Times New Roman\" w:eastAsia=\"Times New Roman\" w:hAnsi=\"Times New Roman\" w:cs=\"Times New Roman\"/>\n");
        this.writer.write("   </w:rPr>\n");
        this.writer.write("  </w:rPrDefault>\n");
        this.writer.write("  <w:pPrDefault>\n");
        this.writer.write("  </w:pPrDefault>\n");
        this.writer.write(" </w:docDefaults>\n");
        for (int reportIndex = 0; reportIndex < jasperPrintList.size(); ++reportIndex) {
            JasperPrint jasperPrint = (JasperPrint)jasperPrintList.get(reportIndex);
            JRStyle[] styles = jasperPrint.getStyles();
            if (styles == null) continue;
            for (int i2 = 0; i2 < styles.length; ++i2) {
                JRStyle style2 = styles[i2];
                this.exportHeader(style2);
                this.paragraphHelper.exportProps(style2);
                this.runHelper.exportProps(style2);
                this.exportFooter();
            }
        }
        this.writer.write("</w:styles>\n");
    }

    private void exportHeader(JRStyle style2) throws IOException {
        String styleNameReference;
        this.writer.write(" <w:style w:type=\"paragraph\" w:styleId=\"" + style2.getName() + "\"");
        if (style2.isDefault()) {
            this.writer.write(" w:default=\"1\"");
        }
        this.writer.write(">\n");
        this.writer.write("  <w:name w:val=\"" + style2.getName() + "\" />\n");
        this.writer.write("  <w:qFormat />\n");
        String string = styleNameReference = style2.getStyle() == null ? null : style2.getStyle().getName();
        if (styleNameReference != null) {
            this.writer.write("  <w:basedOn w:val=\"" + styleNameReference + "\" />\n");
        }
    }

    private void exportFooter() throws IOException {
        this.writer.write(" </w:style>\n");
    }
}

