/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuter;
import org.apache.commons.collections.ReferenceMap;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaxenXPathExecuter
implements JRXPathExecuter {
    private final Map cachedXPaths = new ReferenceMap();

    protected XPath getXPath(String expression) throws JRException {
        XPath xPath = (XPath)this.cachedXPaths.get(expression);
        if (xPath == null) {
            try {
                xPath = new DOMXPath(expression);
            }
            catch (JaxenException e2) {
                throw new JRException("XPath compilation failed. Expression: " + expression, e2);
            }
            this.cachedXPaths.put(expression, xPath);
        }
        return xPath;
    }

    public NodeList selectNodeList(Node contextNode, String expression) throws JRException {
        try {
            ArrayList<Object> nodes;
            XPath xpath = this.getXPath(expression);
            Object object2 = xpath.evaluate((Object)contextNode);
            if (object2 instanceof List) {
                nodes = (ArrayList<Object>)object2;
            } else {
                nodes = new ArrayList<Object>();
                nodes.add(object2);
            }
            return new NodeListWrapper(nodes);
        }
        catch (JaxenException e2) {
            throw new JRException("XPath selection failed. Expression: " + expression, e2);
        }
    }

    public Object selectObject(Node contextNode, String expression) throws JRException {
        try {
            List list;
            DOMXPath xpath = new DOMXPath(expression);
            Object object2 = xpath.evaluate((Object)contextNode);
            Object value = object2 instanceof List ? ((list = (List)object2).isEmpty() ? null : list.get(0)) : (object2 instanceof Number || object2 instanceof Boolean ? object2 : object2.toString());
            return value;
        }
        catch (JaxenException e2) {
            throw new JRException("XPath selection failed. Expression: " + expression, e2);
        }
    }

    protected static final class NodeListWrapper
    implements NodeList {
        private final List nodes;

        public NodeListWrapper(List nodes) {
            this.nodes = nodes;
        }

        public int getLength() {
            return this.nodes.size();
        }

        public Node item(int index) {
            return (Node)this.nodes.get(index);
        }
    }
}

