/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.bcel.analyser;

import java.util.HashSet;
import java.util.Hashtable;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.ExceptionHandler;

public class ExceptionHandlers {
    private Hashtable exceptionhandlers = new Hashtable();

    public ExceptionHandlers(MethodGen mg) {
        CodeExceptionGen[] cegs = mg.getExceptionHandlers();
        for (int i2 = 0; i2 < cegs.length; ++i2) {
            ExceptionHandler eh = new ExceptionHandler(cegs[i2].getCatchType(), cegs[i2].getHandlerPC());
            for (InstructionHandle ih = cegs[i2].getStartPC(); ih != cegs[i2].getEndPC().getNext(); ih = ih.getNext()) {
                HashSet<ExceptionHandler> hs = (HashSet<ExceptionHandler>)this.exceptionhandlers.get(ih);
                if (hs == null) {
                    hs = new HashSet<ExceptionHandler>();
                    this.exceptionhandlers.put(ih, hs);
                }
                hs.add(eh);
            }
        }
    }

    public ExceptionHandler[] getExceptionHandlers(InstructionHandle ih) {
        HashSet hs = (HashSet)this.exceptionhandlers.get(ih);
        if (hs == null) {
            return new ExceptionHandler[0];
        }
        ExceptionHandler[] ret = new ExceptionHandler[hs.size()];
        return hs.toArray(ret);
    }
}

