/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.cf.CellRangeUtil;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.hssf.util.CellRangeAddressList;
import org.apache.poi.util.LittleEndian;

public final class CFHeaderRecord
extends Record {
    public static final short sid = 432;
    private int field_1_numcf;
    private int field_2_need_recalculation;
    private CellRangeAddress field_3_enclosing_cell_range;
    private CellRangeAddressList field_4_cell_ranges;

    public CFHeaderRecord() {
        this.field_4_cell_ranges = new CellRangeAddressList();
    }

    public CFHeaderRecord(CellRangeAddress[] regions, int nRules) {
        CellRangeAddress[] unmergedRanges = regions;
        CellRangeAddress[] mergeCellRanges = CellRangeUtil.mergeCellRanges(unmergedRanges);
        this.setCellRanges(mergeCellRanges);
        this.field_1_numcf = nRules;
    }

    public CFHeaderRecord(RecordInputStream in) {
        this.field_1_numcf = in.readShort();
        this.field_2_need_recalculation = in.readShort();
        this.field_3_enclosing_cell_range = new CellRangeAddress(in);
        this.field_4_cell_ranges = new CellRangeAddressList(in);
    }

    public int getNumberOfConditionalFormats() {
        return this.field_1_numcf;
    }

    public void setNumberOfConditionalFormats(int n) {
        this.field_1_numcf = n;
    }

    public boolean getNeedRecalculation() {
        return this.field_2_need_recalculation == 1;
    }

    public void setNeedRecalculation(boolean b2) {
        this.field_2_need_recalculation = b2 ? 1 : 0;
    }

    public CellRangeAddress getEnclosingCellRange() {
        return this.field_3_enclosing_cell_range;
    }

    public void setEnclosingCellRange(CellRangeAddress cr) {
        this.field_3_enclosing_cell_range = cr;
    }

    public void setCellRanges(CellRangeAddress[] cellRanges) {
        if (cellRanges == null) {
            throw new IllegalArgumentException("cellRanges must not be null");
        }
        CellRangeAddressList cral = new CellRangeAddressList();
        CellRangeAddress enclosingRange = null;
        for (int i2 = 0; i2 < cellRanges.length; ++i2) {
            CellRangeAddress cr = cellRanges[i2];
            enclosingRange = CellRangeUtil.createEnclosingCellRange(cr, enclosingRange);
            cral.addCellRangeAddress(cr);
        }
        this.field_3_enclosing_cell_range = enclosingRange;
        this.field_4_cell_ranges = cral;
    }

    public CellRangeAddress[] getCellRanges() {
        return this.field_4_cell_ranges.getCellRangeAddresses();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CFHEADER]\n");
        buffer.append("\t.id\t\t= ").append(Integer.toHexString(432)).append("\n");
        buffer.append("\t.numCF\t\t\t= ").append(this.getNumberOfConditionalFormats()).append("\n");
        buffer.append("\t.needRecalc\t   = ").append(this.getNeedRecalculation()).append("\n");
        buffer.append("\t.enclosingCellRange= ").append(this.getEnclosingCellRange()).append("\n");
        buffer.append("\t.cfranges=[");
        for (int i2 = 0; i2 < this.field_4_cell_ranges.countRanges(); ++i2) {
            buffer.append(i2 == 0 ? "" : ",").append(this.field_4_cell_ranges.getCellRangeAddress(i2).toString());
        }
        buffer.append("]\n");
        buffer.append("[/CFHEADER]\n");
        return buffer.toString();
    }

    private int getDataSize() {
        return 12 + this.field_4_cell_ranges.getSize();
    }

    public int serialize(int offset, byte[] data) {
        int dataSize = this.getDataSize();
        LittleEndian.putUShort(data, 0 + offset, 432);
        LittleEndian.putUShort(data, 2 + offset, dataSize);
        LittleEndian.putUShort(data, 4 + offset, this.field_1_numcf);
        LittleEndian.putUShort(data, 6 + offset, this.field_2_need_recalculation);
        this.field_3_enclosing_cell_range.serialize(8 + offset, data);
        this.field_4_cell_ranges.serialize(16 + offset, data);
        return 4 + dataSize;
    }

    public int getRecordSize() {
        return 4 + this.getDataSize();
    }

    public short getSid() {
        return 432;
    }

    public Object clone() {
        CFHeaderRecord result = new CFHeaderRecord();
        result.field_1_numcf = this.field_1_numcf;
        result.field_2_need_recalculation = this.field_2_need_recalculation;
        result.field_3_enclosing_cell_range = this.field_3_enclosing_cell_range;
        result.field_4_cell_ranges = this.field_4_cell_ranges.copy();
        return result;
    }
}

