/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.MergeCellsRecord;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.hssf.util.CellRangeAddressList;

public final class MergedCellsTable
extends RecordAggregate {
    private static int MAX_MERGED_REGIONS = 1027;
    private final List _mergedRegions = new ArrayList();
    static /* synthetic */ Class class$org$apache$poi$hssf$record$MergeCellsRecord;

    public void read(RecordStream rs) {
        List temp = this._mergedRegions;
        while (rs.peekNextClass() == (class$org$apache$poi$hssf$record$MergeCellsRecord == null ? MergedCellsTable.class$("org.apache.poi.hssf.record.MergeCellsRecord") : class$org$apache$poi$hssf$record$MergeCellsRecord)) {
            MergeCellsRecord mcr = (MergeCellsRecord)rs.getNext();
            int nRegions = mcr.getNumAreas();
            for (int i2 = 0; i2 < nRegions; ++i2) {
                temp.add(mcr.getAreaAt(i2));
            }
        }
    }

    public int getRecordSize() {
        int nRegions = this._mergedRegions.size();
        if (nRegions < 1) {
            return 0;
        }
        int nMergedCellsRecords = nRegions / MAX_MERGED_REGIONS;
        int nLeftoverMergedRegions = nRegions % MAX_MERGED_REGIONS;
        int result = nMergedCellsRecords * (4 + CellRangeAddressList.getEncodedSize(MAX_MERGED_REGIONS)) + 4 + CellRangeAddressList.getEncodedSize(nLeftoverMergedRegions);
        return result;
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor rv) {
        int nRegions = this._mergedRegions.size();
        if (nRegions < 1) {
            return;
        }
        int nFullMergedCellsRecords = nRegions / MAX_MERGED_REGIONS;
        int nLeftoverMergedRegions = nRegions % MAX_MERGED_REGIONS;
        CellRangeAddress[] cras = new CellRangeAddress[nRegions];
        this._mergedRegions.toArray(cras);
        for (int i2 = 0; i2 < nFullMergedCellsRecords; ++i2) {
            int startIx = i2 * MAX_MERGED_REGIONS;
            rv.visitRecord(new MergeCellsRecord(cras, startIx, MAX_MERGED_REGIONS));
        }
        if (nLeftoverMergedRegions > 0) {
            int startIx = nFullMergedCellsRecords * MAX_MERGED_REGIONS;
            rv.visitRecord(new MergeCellsRecord(cras, startIx, nLeftoverMergedRegions));
        }
    }

    public void addRecords(MergeCellsRecord[] mcrs) {
        for (int i2 = 0; i2 < mcrs.length; ++i2) {
            this.addMergeCellsRecord(mcrs[i2]);
        }
    }

    private void addMergeCellsRecord(MergeCellsRecord mcr) {
        int nRegions = mcr.getNumAreas();
        for (int i2 = 0; i2 < nRegions; ++i2) {
            this._mergedRegions.add(mcr.getAreaAt(i2));
        }
    }

    public CellRangeAddress get(int index) {
        this.checkIndex(index);
        return (CellRangeAddress)this._mergedRegions.get(index);
    }

    public void remove(int index) {
        this.checkIndex(index);
        this._mergedRegions.remove(index);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this._mergedRegions.size()) {
            throw new IllegalArgumentException("Specified CF index " + index + " is outside the allowable range (0.." + (this._mergedRegions.size() - 1) + ")");
        }
    }

    public void addArea(int rowFrom, int colFrom, int rowTo, int colTo) {
        this._mergedRegions.add(new CellRangeAddress(rowFrom, rowTo, colFrom, colTo));
    }

    public int getNumberOfMergedRegions() {
        return this._mergedRegions.size();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

