/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import org.apache.poi.hssf.record.ArrayRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.SharedValueRecordBase;
import org.apache.poi.hssf.record.TableRecord;

public final class SharedValueManager {
    public static final SharedValueManager EMPTY = new SharedValueManager(new SharedFormulaRecord[0], new ArrayRecord[0], new TableRecord[0]);
    private final SharedFormulaRecord[] _sfrs;
    private final ArrayRecord[] _arrayRecords;
    private final TableRecord[] _tableRecords;

    private SharedValueManager(SharedFormulaRecord[] sharedFormulaRecords, ArrayRecord[] arrayRecords, TableRecord[] tableRecords) {
        this._sfrs = sharedFormulaRecords;
        this._arrayRecords = arrayRecords;
        this._tableRecords = tableRecords;
    }

    public static SharedValueManager create(SharedFormulaRecord[] sharedFormulaRecords, ArrayRecord[] arrayRecords, TableRecord[] tableRecords) {
        if (sharedFormulaRecords.length + arrayRecords.length + tableRecords.length < 1) {
            return EMPTY;
        }
        return new SharedValueManager(sharedFormulaRecords, arrayRecords, tableRecords);
    }

    public void convertSharedFormulaRecord(FormulaRecord formula) {
        int row = formula.getRow();
        short column = formula.getColumn();
        for (int i2 = 0; i2 < this._sfrs.length; ++i2) {
            SharedFormulaRecord shrd = this._sfrs[i2];
            if (!shrd.isInRange(row, column)) continue;
            shrd.convertSharedFormulaRecord(formula);
            return;
        }
        SharedValueManager.handleMissingSharedFormulaRecord(formula);
    }

    private static void handleMissingSharedFormulaRecord(FormulaRecord formula) {
        formula.setSharedFormula(false);
    }

    public SharedValueRecordBase getRecordForFirstCell(FormulaRecord formulaRecord) {
        int i2;
        int row = formulaRecord.getRow();
        short column = formulaRecord.getColumn();
        for (i2 = 0; i2 < this._tableRecords.length; ++i2) {
            TableRecord tr2 = this._tableRecords[i2];
            if (!tr2.isFirstCell(row, column)) continue;
            return tr2;
        }
        for (i2 = 0; i2 < this._arrayRecords.length; ++i2) {
            ArrayRecord ar = this._arrayRecords[i2];
            if (!ar.isFirstCell(row, column)) continue;
            return ar;
        }
        return null;
    }
}

