/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public final class If
implements Function {
    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        boolean b2;
        Eval falseResult;
        switch (args.length) {
            case 3: {
                falseResult = args[2];
                break;
            }
            case 2: {
                falseResult = BoolEval.FALSE;
                break;
            }
            default: {
                return ErrorEval.VALUE_INVALID;
            }
        }
        try {
            b2 = If.evaluateFirstArg(args[0], srcCellRow, srcCellCol);
        }
        catch (EvaluationException e2) {
            return e2.getErrorEval();
        }
        if (b2) {
            return args[1];
        }
        return falseResult;
    }

    private static boolean evaluateFirstArg(Eval arg, int srcCellRow, short srcCellCol) throws EvaluationException {
        ValueEval ve = OperandResolver.getSingleValue(arg, srcCellRow, srcCellCol);
        Boolean b2 = OperandResolver.coerceValueToBoolean(ve, false);
        if (b2 == null) {
            return false;
        }
        return b2;
    }
}

