/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.FormulaCellCache;
import org.apache.poi.ss.formula.FormulaCellCacheEntry;
import org.apache.poi.ss.formula.FormulaUsedBlankCellSet;
import org.apache.poi.ss.formula.IEvaluationListener;
import org.apache.poi.ss.formula.PlainCellCache;
import org.apache.poi.ss.formula.PlainValueCellCacheEntry;
import org.apache.poi.ss.formula.WorkbookEvaluator;

final class EvaluationCache {
    private final PlainCellCache _plainCellCache;
    private final FormulaCellCache _formulaCellCache;
    final IEvaluationListener _evaluationListener;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$NumberEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$StringEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$BoolEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$ErrorEval;

    EvaluationCache(IEvaluationListener evaluationListener) {
        this._evaluationListener = evaluationListener;
        this._plainCellCache = new PlainCellCache();
        this._formulaCellCache = new FormulaCellCache();
    }

    public void notifyUpdateCell(int bookIndex, int sheetIndex, EvaluationCell cell) {
        FormulaCellCacheEntry fcce = this._formulaCellCache.get(cell);
        PlainCellCache.Loc loc = new PlainCellCache.Loc(bookIndex, sheetIndex, cell.getRowIndex(), cell.getColumnIndex());
        PlainValueCellCacheEntry pcce = this._plainCellCache.get(loc);
        if (cell.getCellType() == 2) {
            if (fcce == null) {
                if (pcce == null) {
                    this.updateAnyBlankReferencingFormulas(bookIndex, sheetIndex, cell.getRowIndex(), cell.getColumnIndex());
                }
                fcce = new FormulaCellCacheEntry();
                this._formulaCellCache.put(cell, fcce);
            } else {
                fcce.recurseClearCachedFormulaResults(this._evaluationListener);
                fcce.clearFormulaEntry();
            }
            if (pcce != null) {
                pcce.recurseClearCachedFormulaResults(this._evaluationListener);
                this._plainCellCache.remove(loc);
            }
        } else {
            ValueEval value = WorkbookEvaluator.getValueFromNonFormulaCell(cell);
            if (pcce == null) {
                if (fcce == null) {
                    this.updateAnyBlankReferencingFormulas(bookIndex, sheetIndex, cell.getRowIndex(), cell.getColumnIndex());
                }
                pcce = new PlainValueCellCacheEntry(value);
                this._plainCellCache.put(loc, pcce);
                if (this._evaluationListener != null) {
                    this._evaluationListener.onReadPlainValue(sheetIndex, cell.getRowIndex(), cell.getColumnIndex(), pcce);
                }
            } else if (pcce.updateValue(value)) {
                pcce.recurseClearCachedFormulaResults(this._evaluationListener);
            }
            if (fcce != null) {
                this._formulaCellCache.remove(cell);
                fcce.setSensitiveInputCells(null);
                fcce.recurseClearCachedFormulaResults(this._evaluationListener);
            }
        }
    }

    private void updateAnyBlankReferencingFormulas(int bookIndex, int sheetIndex, final int rowIndex, final int columnIndex) {
        final FormulaUsedBlankCellSet.BookSheetKey bsk = new FormulaUsedBlankCellSet.BookSheetKey(bookIndex, sheetIndex);
        this._formulaCellCache.applyOperation(new FormulaCellCache.IEntryOperation(){

            public void processEntry(FormulaCellCacheEntry entry) {
                entry.notifyUpdatedBlankCell(bsk, rowIndex, columnIndex, EvaluationCache.this._evaluationListener);
            }
        });
    }

    public PlainValueCellCacheEntry getPlainValueEntry(int bookIndex, int sheetIndex, int rowIndex, int columnIndex, ValueEval value) {
        PlainCellCache.Loc loc = new PlainCellCache.Loc(bookIndex, sheetIndex, rowIndex, columnIndex);
        PlainValueCellCacheEntry result = this._plainCellCache.get(loc);
        if (result == null) {
            result = new PlainValueCellCacheEntry(value);
            this._plainCellCache.put(loc, result);
            if (this._evaluationListener != null) {
                this._evaluationListener.onReadPlainValue(sheetIndex, rowIndex, columnIndex, result);
            }
        } else {
            if (!this.areValuesEqual(result.getValue(), value)) {
                throw new IllegalStateException("value changed");
            }
            if (this._evaluationListener != null) {
                this._evaluationListener.onCacheHit(sheetIndex, rowIndex, columnIndex, value);
            }
        }
        return result;
    }

    private boolean areValuesEqual(ValueEval a2, ValueEval b2) {
        if (a2 == null) {
            return false;
        }
        Class<?> cls = a2.getClass();
        if (cls != b2.getClass()) {
            return false;
        }
        if (a2 == BlankEval.INSTANCE) {
            return b2 == a2;
        }
        if (cls == (class$org$apache$poi$hssf$record$formula$eval$NumberEval == null ? (class$org$apache$poi$hssf$record$formula$eval$NumberEval = EvaluationCache.class$("org.apache.poi.hssf.record.formula.eval.NumberEval")) : class$org$apache$poi$hssf$record$formula$eval$NumberEval)) {
            return ((NumberEval)a2).getNumberValue() == ((NumberEval)b2).getNumberValue();
        }
        if (cls == (class$org$apache$poi$hssf$record$formula$eval$StringEval == null ? (class$org$apache$poi$hssf$record$formula$eval$StringEval = EvaluationCache.class$("org.apache.poi.hssf.record.formula.eval.StringEval")) : class$org$apache$poi$hssf$record$formula$eval$StringEval)) {
            return ((StringEval)a2).getStringValue().equals(((StringEval)b2).getStringValue());
        }
        if (cls == (class$org$apache$poi$hssf$record$formula$eval$BoolEval == null ? (class$org$apache$poi$hssf$record$formula$eval$BoolEval = EvaluationCache.class$("org.apache.poi.hssf.record.formula.eval.BoolEval")) : class$org$apache$poi$hssf$record$formula$eval$BoolEval)) {
            return ((BoolEval)a2).getBooleanValue() == ((BoolEval)b2).getBooleanValue();
        }
        if (cls == (class$org$apache$poi$hssf$record$formula$eval$ErrorEval == null ? (class$org$apache$poi$hssf$record$formula$eval$ErrorEval = EvaluationCache.class$("org.apache.poi.hssf.record.formula.eval.ErrorEval")) : class$org$apache$poi$hssf$record$formula$eval$ErrorEval)) {
            return ((ErrorEval)a2).getErrorCode() == ((ErrorEval)b2).getErrorCode();
        }
        throw new IllegalStateException("Unexpected value class (" + cls.getName() + ")");
    }

    public FormulaCellCacheEntry getOrCreateFormulaCellEntry(EvaluationCell cell) {
        FormulaCellCacheEntry result = this._formulaCellCache.get(cell);
        if (result == null) {
            result = new FormulaCellCacheEntry();
            this._formulaCellCache.put(cell, result);
        }
        return result;
    }

    public void clear() {
        if (this._evaluationListener != null) {
            this._evaluationListener.onClearWholeCache();
        }
        this._plainCellCache.clear();
        this._formulaCellCache.clear();
    }

    public void notifyDeleteCell(int bookIndex, int sheetIndex, EvaluationCell cell) {
        if (cell.getCellType() == 2) {
            FormulaCellCacheEntry fcce = this._formulaCellCache.remove(cell);
            if (fcce != null) {
                fcce.setSensitiveInputCells(null);
                fcce.recurseClearCachedFormulaResults(this._evaluationListener);
            }
        } else {
            PlainCellCache.Loc loc = new PlainCellCache.Loc(bookIndex, sheetIndex, cell.getRowIndex(), cell.getColumnIndex());
            PlainValueCellCacheEntry pcce = this._plainCellCache.get(loc);
            if (pcce != null) {
                pcce.recurseClearCachedFormulaResults(this._evaluationListener);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

