/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.control.SourceUnit;

public class VariableScopeVisitor
extends ClassCodeVisitorSupport {
    private VariableScope currentScope = null;
    private VariableScope headScope = new VariableScope();
    private ClassNode currentClass = null;
    private SourceUnit source;
    private boolean inClosure = false;
    private boolean inPropertyExpression = false;
    private boolean isSpecialConstructorCall = false;
    private LinkedList stateStack = new LinkedList();

    public VariableScopeVisitor(SourceUnit source) {
        this.source = source;
        this.currentScope = this.headScope;
    }

    private void pushState(boolean isStatic) {
        this.stateStack.add(new StateStackElement());
        this.currentScope = new VariableScope(this.currentScope);
        this.currentScope.setInStaticContext(isStatic);
    }

    private void pushState() {
        this.pushState(this.currentScope.isInStaticContext());
    }

    private void popState() {
        if (this.inClosure) {
            this.currentScope.setInStaticContext(false);
        }
        StateStackElement element = (StateStackElement)this.stateStack.removeLast();
        this.currentScope = element.scope;
        this.currentClass = element.clazz;
        this.inClosure = element.closure;
    }

    private void declare(Parameter[] parameters, ASTNode node) {
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            if (parameters[i2].hasInitialExpression()) {
                parameters[i2].getInitialExpression().visit(this);
            }
            this.declare(parameters[i2], node);
        }
    }

    private void declare(VariableExpression expr) {
        this.declare(expr, (ASTNode)expr);
    }

    private void declare(Variable var2, ASTNode expr) {
        String scopeType = "scope";
        String variableType = "variable";
        if (expr.getClass() == FieldNode.class) {
            scopeType = "class";
            variableType = "field";
        } else if (expr.getClass() == PropertyNode.class) {
            scopeType = "class";
            variableType = "property";
        }
        StringBuffer msg = new StringBuffer();
        msg.append("The current ").append(scopeType);
        msg.append(" already contains a ").append(variableType);
        msg.append(" of the name ").append(var2.getName());
        if (this.currentScope.getDeclaredVariable(var2.getName()) != null) {
            this.addError(msg.toString(), expr);
            return;
        }
        for (VariableScope scope = this.currentScope.getParent(); scope != null && scope.getClassScope() == null; scope = scope.getParent()) {
            if (scope.getDeclaredVariable(var2.getName()) == null) continue;
            this.addError(msg.toString(), expr);
            break;
        }
        this.currentScope.putDeclaredVariable(var2);
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    private Variable findClassMember(ClassNode cn, String name) {
        AnnotatedNode f2;
        if (cn == null) {
            return null;
        }
        if (cn.isScript()) {
            return new DynamicVariable(name, false);
        }
        List l = cn.getFields();
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            f2 = (FieldNode)iter.next();
            if (!((FieldNode)f2).getName().equals(name)) continue;
            return f2;
        }
        l = cn.getMethods();
        iter = l.iterator();
        while (iter.hasNext()) {
            f2 = (MethodNode)iter.next();
            String methodName = ((MethodNode)f2).getName();
            String pName = this.getPropertyName((MethodNode)f2);
            if (pName == null || !pName.equals(name)) continue;
            PropertyNode var2 = new PropertyNode(pName, ((MethodNode)f2).getModifiers(), this.getPropertyType((MethodNode)f2), cn, null, null, null);
            return var2;
        }
        l = cn.getProperties();
        iter = l.iterator();
        while (iter.hasNext()) {
            f2 = (PropertyNode)iter.next();
            if (!((PropertyNode)f2).getName().equals(name)) continue;
            return f2;
        }
        Variable ret = this.findClassMember(cn.getSuperClass(), name);
        if (ret != null) {
            return ret;
        }
        return this.findClassMember(cn.getOuterClass(), name);
    }

    private ClassNode getPropertyType(MethodNode m) {
        String name = m.getName();
        if (m.getReturnType() != ClassHelper.VOID_TYPE) {
            return m.getReturnType();
        }
        return m.getParameters()[0].getType();
    }

    private String getPropertyName(MethodNode m) {
        String name = m.getName();
        if (!name.startsWith("set") && !name.startsWith("get")) {
            return null;
        }
        String pname = name.substring(3);
        if (pname.length() == 0) {
            return null;
        }
        String s2 = pname.substring(0, 1).toLowerCase();
        String rest = pname.substring(1);
        pname = s2 + rest;
        if (name.startsWith("get") && m.getReturnType() == ClassHelper.VOID_TYPE) {
            return null;
        }
        if (name.startsWith("set") && m.getParameters().length != 1) {
            return null;
        }
        return pname;
    }

    private Variable checkVariableNameForDeclaration(String name, Expression expression) {
        if ("super".equals(name) || "this".equals(name)) {
            return null;
        }
        VariableScope scope = this.currentScope;
        Variable var2 = new DynamicVariable(name, this.currentScope.isInStaticContext());
        DynamicVariable dummyStart = var2;
        VariableScope dynamicScope = null;
        while (!scope.isRoot()) {
            Variable var1;
            if (dynamicScope == null && scope.isResolvingDynamic()) {
                dynamicScope = scope;
            }
            if ((var1 = scope.getDeclaredVariable(var2.getName())) != null) {
                var2 = var1;
                break;
            }
            var1 = scope.getReferencedLocalVariable(var2.getName());
            if (var1 != null) {
                var2 = var1;
                break;
            }
            var1 = scope.getReferencedClassVariable(var2.getName());
            if (var1 != null) {
                var2 = var1;
                break;
            }
            ClassNode classScope = scope.getClassScope();
            if (classScope != null) {
                Variable member = this.findClassMember(classScope, var2.getName());
                if (member == null) break;
                boolean cc = this.currentScope.isInStaticContext() || this.isSpecialConstructorCall;
                boolean cm = member.isInStaticContext();
                if (!cm && cm != cc) break;
                var2 = member;
                break;
            }
            scope = scope.getParent();
        }
        VariableScope end = scope;
        if (scope.isRoot() && dynamicScope == null) {
            this.declare(var2, (ASTNode)expression);
            this.addError("The variable " + var2.getName() + " is undefined in the current scope", expression);
        } else if (scope.isRoot() && dynamicScope != null) {
            scope = dynamicScope;
        }
        if (!scope.isRoot()) {
            for (scope = this.currentScope; scope != end; scope = scope.getParent()) {
                Object references = null;
                if (end.isClassScope() || end.isRoot() || end.isReferencedClassVariable(name) && end.getDeclaredVariable(name) == null) {
                    scope.putReferencedClassVariable(var2);
                    continue;
                }
                var2.setClosureSharedVariable(var2.isClosureSharedVariable() || this.inClosure);
                scope.putReferencedLocalVariable(var2);
            }
            if (end.isResolvingDynamic() && end.getDeclaredVariable(var2.getName()) == null) {
                end.putDeclaredVariable(var2);
            }
        }
        return var2;
    }

    private void checkPropertyOnExplicitThis(PropertyExpression pe) {
        if (!this.currentScope.isInStaticContext()) {
            return;
        }
        Expression object2 = pe.getObjectExpression();
        if (!(object2 instanceof VariableExpression)) {
            return;
        }
        VariableExpression ve = (VariableExpression)object2;
        if (!ve.getName().equals("this")) {
            return;
        }
        String name = pe.getPropertyAsString();
        if (name == null) {
            return;
        }
        Variable member = this.findClassMember(this.currentClass, name);
        if (member == null) {
            return;
        }
        this.checkVariableContextAccess(member, pe);
    }

    private void checkVariableContextAccess(Variable v, Expression expr) {
        if (this.inPropertyExpression || v.isInStaticContext() || !this.currentScope.isInStaticContext()) {
            return;
        }
        String msg = v.getName() + " is declared in a dynamic context, but you tried to" + " access it from a static context.";
        this.addError(msg, expr);
        DynamicVariable v2 = new DynamicVariable(v.getName(), this.currentScope.isInStaticContext());
        this.currentScope.putDeclaredVariable(v2);
    }

    public void visitBlockStatement(BlockStatement block) {
        this.pushState();
        block.setVariableScope(this.currentScope);
        super.visitBlockStatement(block);
        this.popState();
    }

    public void visitForLoop(ForStatement forLoop) {
        this.pushState();
        forLoop.setVariableScope(this.currentScope);
        Parameter p2 = forLoop.getVariable();
        p2.setInStaticContext(this.currentScope.isInStaticContext());
        if (p2 != ForStatement.FOR_LOOP_DUMMY) {
            this.declare(p2, (ASTNode)forLoop);
        }
        super.visitForLoop(forLoop);
        this.popState();
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        expression.getRightExpression().visit(this);
        VariableExpression vex = expression.getVariableExpression();
        vex.setInStaticContext(this.currentScope.isInStaticContext());
        this.declare(vex);
        vex.setAccessedVariable(vex);
    }

    public void visitVariableExpression(VariableExpression expression) {
        String name = expression.getName();
        Variable v = this.checkVariableNameForDeclaration(name, expression);
        if (v == null) {
            return;
        }
        expression.setAccessedVariable(v);
        this.checkVariableContextAccess(v, expression);
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        boolean ipe = this.inPropertyExpression;
        this.inPropertyExpression = true;
        expression.getObjectExpression().visit(this);
        this.inPropertyExpression = false;
        expression.getProperty().visit(this);
        this.checkPropertyOnExplicitThis(expression);
        this.inPropertyExpression = ipe;
    }

    public void visitClosureExpression(ClosureExpression expression) {
        this.pushState();
        this.inClosure = true;
        this.currentScope.setDynamicResolving(true);
        expression.setVariableScope(this.currentScope);
        if (expression.isParameterSpecified()) {
            Parameter[] parameters = expression.getParameters();
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                parameters[i2].setInStaticContext(this.currentScope.isInStaticContext());
                if (parameters[i2].hasInitialExpression()) {
                    parameters[i2].getInitialExpression().visit(this);
                }
                this.declare(parameters[i2], (ASTNode)expression);
            }
        } else if (expression.getParameters() != null) {
            DynamicVariable var2 = new DynamicVariable("it", this.currentScope.isInStaticContext());
            this.currentScope.putDeclaredVariable(var2);
        }
        super.visitClosureExpression(expression);
        this.popState();
    }

    public void visitCatchStatement(CatchStatement statement) {
        this.pushState();
        Parameter p2 = statement.getVariable();
        p2.setInStaticContext(this.currentScope.isInStaticContext());
        this.declare(p2, (ASTNode)statement);
        super.visitCatchStatement(statement);
        this.popState();
    }

    public void visitFieldExpression(FieldExpression expression) {
        String name = expression.getFieldName();
        Variable v = this.checkVariableNameForDeclaration(name, expression);
        this.checkVariableContextAccess(v, expression);
    }

    public void visitClass(ClassNode node) {
        this.pushState();
        this.currentClass = node;
        boolean dynamicMode = node.isScript();
        this.currentScope.setDynamicResolving(dynamicMode);
        this.currentScope.setClassScope(node);
        super.visitClass(node);
        this.popState();
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.pushState(node.isStatic());
        node.setVariableScope(this.currentScope);
        Parameter[] parameters = node.getParameters();
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            Parameter parameter = parameters[i2];
            this.visitAnnotations(parameter);
        }
        this.declare(node.getParameters(), (ASTNode)node);
        super.visitConstructorOrMethod(node, isConstructor);
        this.popState();
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        if (call.isImplicitThis() && call.getMethod() instanceof ConstantExpression) {
            String value = ((ConstantExpression)call.getMethod()).getText();
            if (!(value instanceof String)) {
                throw new GroovyBugError("tried to make a method call with a non-String constant method name.");
            }
            String methodName = value;
            Variable v = this.checkVariableNameForDeclaration(methodName, call);
            if (v != null && !(v instanceof DynamicVariable)) {
                this.checkVariableContextAccess(v, call);
            }
        }
        super.visitMethodCallExpression(call);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        this.isSpecialConstructorCall = call.isSpecialCall();
        super.visitConstructorCallExpression(call);
        this.isSpecialConstructorCall = false;
    }

    public void visitProperty(PropertyNode node) {
        this.pushState(node.isStatic());
        super.visitProperty(node);
        this.popState();
    }

    public void visitField(FieldNode node) {
        this.pushState(node.isStatic());
        super.visitField(node);
        this.popState();
    }

    private class StateStackElement {
        VariableScope scope;
        ClassNode clazz;
        boolean closure;

        StateStackElement() {
            this.scope = VariableScopeVisitor.this.currentScope;
            this.clazz = VariableScopeVisitor.this.currentClass;
            this.closure = VariableScopeVisitor.this.inClosure;
        }
    }
}

