/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import groovy.lang.GroovyInterceptable;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MissingMethodException;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.NullObject;
import org.codehaus.groovy.runtime.wrappers.PojoWrapper;

public class Invoker {
    protected static final Object[] EMPTY_ARGUMENTS = new Object[0];
    protected static final Class[] EMPTY_TYPES = new Class[0];
    private final MetaClassRegistry metaRegistry = GroovySystem.getMetaClassRegistry();

    public MetaClassRegistry getMetaRegistry() {
        return this.metaRegistry;
    }

    public MetaClass getMetaClass(Object object2) {
        return this.metaRegistry.getMetaClass(object2.getClass());
    }

    public Object invokeMethod(Object object2, String methodName, Object arguments) {
        if (object2 == null) {
            object2 = NullObject.getNullObject();
        }
        if (object2 instanceof Class) {
            Class theClass = (Class)object2;
            MetaClass metaClass = this.metaRegistry.getMetaClass(theClass);
            return metaClass.invokeStaticMethod(object2, methodName, this.asArray(arguments));
        }
        if (!(object2 instanceof GroovyObject)) {
            return this.invokePojoMethod(object2, methodName, arguments);
        }
        return this.invokePogoMethod(object2, methodName, arguments);
    }

    private Object invokePojoMethod(Object object2, String methodName, Object arguments) {
        Class<?> theClass = object2.getClass();
        MetaClass metaClass = this.metaRegistry.getMetaClass(theClass);
        return metaClass.invokeMethod(object2, methodName, this.asArray(arguments));
    }

    private Object invokePogoMethod(Object object2, String methodName, Object arguments) {
        GroovyObject groovy = (GroovyObject)object2;
        boolean intercepting = groovy instanceof GroovyInterceptable;
        try {
            if (intercepting) {
                return groovy.invokeMethod(methodName, this.asUnwrappedArray(arguments));
            }
            return groovy.getMetaClass().invokeMethod(object2, methodName, this.asArray(arguments));
        }
        catch (MissingMethodException e2) {
            if (!intercepting && e2.getMethod().equals(methodName) && object2.getClass() == e2.getType()) {
                return groovy.invokeMethod(methodName, this.asUnwrappedArray(arguments));
            }
            throw e2;
        }
    }

    public Object invokeSuperMethod(Object object2, String methodName, Object arguments) {
        if (object2 == null) {
            throw new NullPointerException("Cannot invoke method " + methodName + "() on null object");
        }
        Class<?> theClass = object2.getClass();
        MetaClass metaClass = this.metaRegistry.getMetaClass(theClass.getSuperclass());
        return metaClass.invokeMethod(object2, methodName, this.asArray(arguments));
    }

    public Object invokeStaticMethod(Class type, String method, Object arguments) {
        MetaClass metaClass = this.metaRegistry.getMetaClass(type);
        return metaClass.invokeStaticMethod(type, method, this.asArray(arguments));
    }

    public Object invokeConstructorOf(Class type, Object arguments) {
        MetaClass metaClass = this.metaRegistry.getMetaClass(type);
        return metaClass.invokeConstructor(this.asArray(arguments));
    }

    public Object[] asArray(Object arguments) {
        if (arguments == null) {
            return EMPTY_ARGUMENTS;
        }
        if (arguments instanceof Object[]) {
            return (Object[])arguments;
        }
        return new Object[]{arguments};
    }

    public Object[] asUnwrappedArray(Object arguments) {
        Object[] args = this.asArray(arguments);
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (!(args[i2] instanceof PojoWrapper)) continue;
            args[i2] = ((PojoWrapper)args[i2]).unwrap();
        }
        return args;
    }

    public Object getProperty(Object object2, String property) {
        if (object2 == null) {
            throw new NullPointerException("Cannot get property: " + property + " on null object");
        }
        if (object2 instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object2;
            return pogo.getProperty(property);
        }
        if (object2 instanceof Class) {
            Class c2 = (Class)object2;
            return this.metaRegistry.getMetaClass(c2).getProperty(object2, property);
        }
        return this.metaRegistry.getMetaClass(object2.getClass()).getProperty(object2, property);
    }

    public void setProperty(Object object2, String property, Object newValue) {
        if (object2 == null) {
            throw new GroovyRuntimeException("Cannot set property on null object");
        }
        if (object2 instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object2;
            pogo.setProperty(property, newValue);
        } else if (object2 instanceof Class) {
            this.metaRegistry.getMetaClass((Class)object2).setProperty((Class)object2, property, newValue);
        } else {
            this.metaRegistry.getMetaClass(object2.getClass()).setProperty(object2, property, newValue);
        }
    }

    public Object getAttribute(Object object2, String attribute) {
        if (object2 == null) {
            throw new NullPointerException("Cannot get attribute: " + attribute + " on null object");
        }
        if (object2 instanceof Class) {
            return this.metaRegistry.getMetaClass((Class)object2).getAttribute(object2, attribute);
        }
        if (object2 instanceof GroovyObject) {
            return ((GroovyObject)object2).getMetaClass().getAttribute(object2, attribute);
        }
        return this.metaRegistry.getMetaClass(object2.getClass()).getAttribute(object2, attribute);
    }

    public void setAttribute(Object object2, String attribute, Object newValue) {
        if (object2 == null) {
            throw new GroovyRuntimeException("Cannot set attribute on null object");
        }
        if (object2 instanceof Class) {
            this.metaRegistry.getMetaClass((Class)object2).setAttribute(object2, attribute, newValue);
        } else if (object2 instanceof GroovyObject) {
            ((GroovyObject)object2).getMetaClass().setAttribute(object2, attribute, newValue);
        } else {
            this.metaRegistry.getMetaClass(object2.getClass()).setAttribute(object2, attribute, newValue);
        }
    }

    public Closure getMethodPointer(Object object2, String methodName) {
        if (object2 == null) {
            throw new NullPointerException("Cannot access method pointer for '" + methodName + "' on null object");
        }
        return MetaClassHelper.getMethodPointer(object2, methodName);
    }

    public void removeMetaClass(Class clazz) {
        this.metaRegistry.removeMetaClass(clazz);
    }
}

