/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.shell.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import jline.ANSIBuffer;
import jline.Terminal;
import org.codehaus.groovy.tools.shell.util.MessageSource;

public class ANSI {
    private static Boolean enabled;
    static /* synthetic */ Class class$org$codehaus$groovy$tools$shell$util$ANSI$Code;

    private static boolean detect() {
        boolean enabled = Terminal.getTerminal().isANSISupported();
        if (!enabled) {
            String force = System.getProperty(ANSI.class.getName() + ".force", "false");
            enabled = Boolean.valueOf(force);
        }
        return enabled;
    }

    public static boolean isDetected() {
        return ANSI.detect();
    }

    public static void setEnabled(boolean flag) {
        enabled = flag;
    }

    public static boolean isEnabled() {
        if (enabled == null) {
            enabled = ANSI.isDetected();
        }
        return enabled;
    }

    public static class RenderMessageSource
    extends MessageSource {
        private final Renderer renderer = new Renderer();

        public RenderMessageSource(String[] names) {
            super(names);
        }

        public RenderMessageSource(String name) {
            super(name);
        }

        public RenderMessageSource(Class[] types) {
            super(types);
        }

        public RenderMessageSource(Class type) {
            super(type);
        }

        public String getMessage(String code2) {
            String msg = super.getMessage(code2);
            if (Renderer.test(msg)) {
                return this.renderer.render(msg);
            }
            return msg;
        }
    }

    public static class RenderWriter
    extends PrintWriter {
        private final Renderer renderer = new Renderer();

        public RenderWriter(OutputStream out) {
            super(out);
        }

        public RenderWriter(OutputStream out, boolean autoFlush) {
            super(out, autoFlush);
        }

        public RenderWriter(Writer out) {
            super(out);
        }

        public RenderWriter(Writer out, boolean autoFlush) {
            super(out, autoFlush);
        }

        public void write(String s2) {
            if (Renderer.test(s2)) {
                super.write(this.renderer.render(s2));
            } else {
                super.write(s2);
            }
        }
    }

    public static class Renderer {
        public static final String BEGIN_TOKEN = "@|";
        private static final int BEGIN_TOKEN_SIZE;
        public static final String END_TOKEN = "|";
        private static final int END_TOKEN_SIZE;
        public static final String CODE_TEXT_SEPARATOR = " ";
        public static final String CODE_LIST_SEPARATOR = ",";
        private final Buffer buff = new Buffer();
        static final /* synthetic */ boolean $assertionsDisabled;

        public String render(String input2) throws RenderException {
            int p2;
            if (!$assertionsDisabled && input2 == null) {
                throw new AssertionError();
            }
            int c2 = 0;
            while (c2 < input2.length() && (p2 = input2.indexOf(BEGIN_TOKEN, c2)) >= 0) {
                int s2 = input2.indexOf(END_TOKEN, p2 + BEGIN_TOKEN_SIZE);
                if (s2 < 0) {
                    throw new RenderException("Missing '|': " + input2);
                }
                String expr = input2.substring(p2 + BEGIN_TOKEN_SIZE, s2);
                this.buff.append(input2.substring(c2, p2));
                this.evaluate(expr);
                c2 = s2 + END_TOKEN_SIZE;
            }
            this.buff.append(input2.substring(c2));
            return this.buff.toString();
        }

        private void evaluate(String input2) throws RenderException {
            if (!$assertionsDisabled && input2 == null) {
                throw new AssertionError();
            }
            int i2 = input2.indexOf(CODE_TEXT_SEPARATOR);
            if (i2 < 0) {
                throw new RenderException("Missing ANSI code/text separator ' ': " + input2);
            }
            String tmp = input2.substring(0, i2);
            String[] codes = tmp.split(CODE_LIST_SEPARATOR);
            String text = input2.substring(i2 + 1, input2.length());
            for (int j = 0; j < codes.length; ++j) {
                int code2 = Code.forName(codes[j]);
                this.buff.attrib(code2);
            }
            this.buff.append(text);
            this.buff.attrib(0);
        }

        public static boolean test(String text) {
            return text != null && text.indexOf(BEGIN_TOKEN) >= 0;
        }

        public static String encode(String text, int code2) {
            return BEGIN_TOKEN + Code.name(code2) + CODE_TEXT_SEPARATOR + text + END_TOKEN;
        }

        static {
            $assertionsDisabled = !(class$org$codehaus$groovy$tools$shell$util$ANSI == null ? (class$org$codehaus$groovy$tools$shell$util$ANSI = ANSI.class$("org.codehaus.groovy.tools.shell.util.ANSI")) : class$org$codehaus$groovy$tools$shell$util$ANSI).desiredAssertionStatus();
            BEGIN_TOKEN_SIZE = BEGIN_TOKEN.length();
            END_TOKEN_SIZE = END_TOKEN.length();
        }

        public static class RenderException
        extends RuntimeException {
            public RenderException(String msg) {
                super(msg);
            }
        }
    }

    public static class Buffer {
        private final StringBuffer buff = new StringBuffer();
        public final boolean autoClear = true;
        static final /* synthetic */ boolean $assertionsDisabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            try {
                String string = this.buff.toString();
                return string;
            }
            finally {
                this.clear();
            }
        }

        public void clear() {
            this.buff.setLength(0);
        }

        public int size() {
            return this.buff.length();
        }

        public Buffer append(String text) {
            this.buff.append(text);
            return this;
        }

        public Buffer append(Object obj) {
            return this.append(String.valueOf(obj));
        }

        public Buffer attrib(int code2) {
            if (ANSI.isEnabled()) {
                this.buff.append(ANSIBuffer.ANSICodes.attrib((int)code2));
            }
            return this;
        }

        public Buffer attrib(String text, int code2) {
            if (!$assertionsDisabled && text == null) {
                throw new AssertionError();
            }
            if (ANSI.isEnabled()) {
                this.buff.append(ANSIBuffer.ANSICodes.attrib((int)code2)).append(text).append(ANSIBuffer.ANSICodes.attrib((int)0));
            } else {
                this.buff.append(text);
            }
            return this;
        }

        public Buffer attrib(String text, String codeName) {
            return this.attrib(text, Code.forName(codeName));
        }

        static {
            $assertionsDisabled = !(class$org$codehaus$groovy$tools$shell$util$ANSI == null ? (class$org$codehaus$groovy$tools$shell$util$ANSI = ANSI.class$("org.codehaus.groovy.tools.shell.util.ANSI")) : class$org$codehaus$groovy$tools$shell$util$ANSI).desiredAssertionStatus();
        }
    }

    public static class Code {
        public static final int OFF = 0;
        public static final int BOLD = 1;
        public static final int UNDERSCORE = 4;
        public static final int BLINK = 5;
        public static final int REVERSE = 7;
        public static final int CONCEALED = 8;
        public static final int FG_BLACK = 30;
        public static final int FG_RED = 31;
        public static final int FG_GREEN = 32;
        public static final int FG_YELLOW = 33;
        public static final int FG_BLUE = 34;
        public static final int FG_MAGENTA = 35;
        public static final int FG_CYAN = 36;
        public static final int FG_WHITE = 37;
        public static final int BLACK = 30;
        public static final int RED = 31;
        public static final int GREEN = 32;
        public static final int YELLOW = 33;
        public static final int BLUE = 34;
        public static final int MAGENTA = 35;
        public static final int CYAN = 36;
        public static final int WHITE = 37;
        public static final int BG_BLACK = 40;
        public static final int BG_RED = 41;
        public static final int BG_GREEN = 42;
        public static final int BG_YELLOW = 43;
        public static final int BG_BLUE = 44;
        public static final int BG_MAGENTA = 45;
        public static final int BG_CYAN = 46;
        public static final int BG_WHITE = 47;
        private static final Map NAMES_TO_CODES;
        private static final Map CODES_TO_NAMES;
        static final /* synthetic */ boolean $assertionsDisabled;

        public static int forName(String name) throws IllegalArgumentException {
            if (!$assertionsDisabled && name == null) {
                throw new AssertionError();
            }
            String tmp = name.toUpperCase();
            Number code2 = (Number)NAMES_TO_CODES.get(tmp);
            if (code2 == null) {
                throw new IllegalArgumentException("Invalid ANSI code name: " + name);
            }
            return code2.intValue();
        }

        public static String name(int code2) throws IllegalArgumentException {
            String name = (String)CODES_TO_NAMES.get(new Integer(code2));
            if (name == null) {
                throw new IllegalArgumentException("Invalid ANSI code: " + code2);
            }
            return name;
        }

        static {
            $assertionsDisabled = !(class$org$codehaus$groovy$tools$shell$util$ANSI == null ? (class$org$codehaus$groovy$tools$shell$util$ANSI = ANSI.class$("org.codehaus.groovy.tools.shell.util.ANSI")) : class$org$codehaus$groovy$tools$shell$util$ANSI).desiredAssertionStatus();
            Field[] fields = (class$org$codehaus$groovy$tools$shell$util$ANSI$Code == null ? (class$org$codehaus$groovy$tools$shell$util$ANSI$Code = ANSI.class$("org.codehaus.groovy.tools.shell.util.ANSI$Code")) : class$org$codehaus$groovy$tools$shell$util$ANSI$Code).getDeclaredFields();
            HashMap<String, Number> names = new HashMap<String, Number>(fields.length);
            HashMap<Number, String> codes = new HashMap<Number, String>(fields.length);
            try {
                for (int i2 = 0; i2 < fields.length; ++i2) {
                    int mods = fields[i2].getModifiers();
                    if (!Modifier.isPublic(mods)) continue;
                    String name = fields[i2].getName();
                    Number code2 = (Number)fields[i2].get(class$org$codehaus$groovy$tools$shell$util$ANSI$Code == null ? ANSI.class$("org.codehaus.groovy.tools.shell.util.ANSI$Code") : class$org$codehaus$groovy$tools$shell$util$ANSI$Code);
                    names.put(name, code2);
                    codes.put(code2, name);
                }
            }
            catch (IllegalAccessException e2) {
                throw new Error(e2);
            }
            NAMES_TO_CODES = names;
            CODES_TO_NAMES = codes;
        }
    }
}

