/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class ClasspathDirectory
extends ClasspathLocation {
    String path;
    Hashtable directoryCache;
    String[] missingPackageHolder = new String[1];
    String encoding;
    public int mode;
    public static final int SOURCE = 1;
    public static final int BINARY = 2;

    ClasspathDirectory(File directory, String encoding, int mode, AccessRuleSet accessRuleSet) {
        super(accessRuleSet);
        this.mode = mode == 0 ? 3 : mode;
        this.path = directory.getAbsolutePath();
        if (!this.path.endsWith(File.separator)) {
            this.path = String.valueOf(this.path) + File.separator;
        }
        this.directoryCache = new Hashtable(11);
        this.encoding = encoding;
    }

    ClasspathDirectory(File directory, String encoding) {
        this(directory, encoding, 3, null);
    }

    String[] directoryList(String qualifiedPackageName) {
        String[] dirList = (String[])this.directoryCache.get(qualifiedPackageName);
        if (dirList == this.missingPackageHolder) {
            return null;
        }
        if (dirList != null) {
            return dirList;
        }
        File dir2 = new File(String.valueOf(this.path) + qualifiedPackageName);
        if (dir2 != null && dir2.isDirectory()) {
            String parentPackage;
            String packageName;
            int index = qualifiedPackageName.length();
            int last = qualifiedPackageName.lastIndexOf(File.separatorChar);
            while (--index > last && !Character.isUpperCase(qualifiedPackageName.charAt(index))) {
            }
            if (index <= last || !(last != -1 ? !this.doesFileExist(packageName = qualifiedPackageName.substring(last + 1), parentPackage = qualifiedPackageName.substring(0, last)) : !this.doesFileExist(qualifiedPackageName, ""))) {
                dirList = dir2.list();
                if (dirList == null) {
                    dirList = new String[]{};
                }
                this.directoryCache.put(qualifiedPackageName, dirList);
                return dirList;
            }
        }
        this.directoryCache.put(qualifiedPackageName, this.missingPackageHolder);
        return null;
    }

    boolean doesFileExist(String fileName, String qualifiedPackageName) {
        String[] dirList = this.directoryList(qualifiedPackageName);
        if (dirList == null) {
            return false;
        }
        int i2 = dirList.length;
        while (--i2 >= 0) {
            if (!fileName.equals(dirList[i2])) continue;
            return true;
        }
        return false;
    }

    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        boolean sourceExists;
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        String fileName = new String(typeName);
        boolean binaryExists = (this.mode & 2) != 0 && this.doesFileExist(String.valueOf(fileName) + ".class", qualifiedPackageName);
        boolean bl = sourceExists = (this.mode & 1) != 0 && this.doesFileExist(String.valueOf(fileName) + ".java", qualifiedPackageName);
        if (sourceExists) {
            String fullSourcePath = String.valueOf(this.path) + qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - 6) + ".java";
            if (!binaryExists) {
                return new NameEnvironmentAnswer(new CompilationUnit(null, fullSourcePath, this.encoding), this.fetchAccessRestriction(qualifiedBinaryFileName));
            }
            String fullBinaryPath = String.valueOf(this.path) + qualifiedBinaryFileName;
            long binaryModified = new File(fullBinaryPath).lastModified();
            long sourceModified = new File(fullSourcePath).lastModified();
            if (sourceModified > binaryModified) {
                return new NameEnvironmentAnswer(new CompilationUnit(null, fullSourcePath, this.encoding), this.fetchAccessRestriction(qualifiedBinaryFileName));
            }
        }
        if (binaryExists) {
            try {
                ClassFileReader reader = ClassFileReader.read(String.valueOf(this.path) + qualifiedBinaryFileName);
                if (reader != null) {
                    return new NameEnvironmentAnswer(reader, this.fetchAccessRestriction(qualifiedBinaryFileName));
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void initialize() throws IOException {
    }

    public boolean isPackage(String qualifiedPackageName) {
        return this.directoryList(qualifiedPackageName) != null;
    }

    public void reset() {
        this.directoryCache = new Hashtable(11);
    }

    public String toString() {
        return "ClasspathDirectory " + this.path;
    }

    public String normalizedPath() {
        return this.path;
    }

    public String getPath() {
        return this.path;
    }
}

